/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TrendReport {
    private ReportContainer actualResult;
    private ReportContainer oldResult;

    public TrendReport(ReportContainer actualReport, ReportContainer oldReport) {
        this.actualResult = actualReport;
        this.oldResult = oldReport;
    }

    public static double floor(double a, int n) {
        double p = Math.pow(10.0, n);
        return Math.floor(a * p + 0.5) / p;
    }

    public ReportContainer getActualReportContainer() {
        return this.actualResult;
    }

    public void setActualReportContainer(ReportContainer actualReportContainer) {
        this.actualResult = actualReportContainer;
    }

    public ReportContainer getOldReport() {
        return this.oldResult;
    }

    public void setOldReport(ReportContainer oldReportContainer) {
        this.oldResult = oldReportContainer;
    }

    public boolean isNumberOfTestHasIncrease() {
        return this.actualResult.getNumberOfTest() > this.oldResult.getNumberOfTest();
    }

    public boolean isNumberOfTestHasDecrease() {
        return this.actualResult.getNumberOfTest() < this.oldResult.getNumberOfTest();
    }

    public boolean isNumberOfTestStable() {
        return this.actualResult.getNumberOfTest() == this.oldResult.getNumberOfTest();
    }

    public boolean isPercentOfPassedTestHasIncrease() {
        return this.actualResult.getPercentOfPassedTest() > this.oldResult.getPercentOfPassedTest();
    }

    public boolean isPercentOfPassedTestHasDecrease() {
        return this.actualResult.getPercentOfPassedTest() < this.oldResult.getPercentOfPassedTest();
    }

    public boolean isPercentOfPassedTestStable() {
        return this.actualResult.getPercentOfPassedTest() == this.oldResult.getPercentOfPassedTest();
    }

    public boolean isNumberOfExecutedTestHasIncreased() {
        return this.actualResult.getNumberOfExecutedTest() > this.oldResult.getNumberOfExecutedTest();
    }

    public boolean isNumberOfExecutedTestHasDecrease() {
        return this.actualResult.getNumberOfExecutedTest() < this.oldResult.getNumberOfExecutedTest();
    }

    public boolean isNumberOfExecutedTestStable() {
        return this.actualResult.getNumberOfExecutedTest() == this.oldResult.getNumberOfExecutedTest();
    }

    public boolean isPercentOfExecutedTestHasIncreased() {
        return this.actualResult.getPercentOfExecutedTest() > this.oldResult.getPercentOfExecutedTest();
    }

    public boolean isNumberOfNotExecutedTestHasIncreased() {
        return this.actualResult.getNumberOfNotExecutedTest() > this.oldResult.getNumberOfNotExecutedTest();
    }

    public boolean isNumberOfNotExecutedTestHasDecrease() {
        return this.actualResult.getNumberOfNotExecutedTest() < this.oldResult.getNumberOfNotExecutedTest();
    }

    public boolean isNumberOfNotExecutedTestStable() {
        return this.actualResult.getNumberOfNotExecutedTest() == this.oldResult.getNumberOfNotExecutedTest();
    }

    public boolean isPercentOfNotExecutedTestHasIncreased() {
        return this.actualResult.getPercentOfNotExecutedTest() > this.oldResult.getPercentOfNotExecutedTest();
    }

    public boolean isPercentOfFailedTestHasIncrease() {
        return this.actualResult.getPercentOfFailedTest() > this.oldResult.getPercentOfFailedTest();
    }

    public boolean isPercentOfFailedTestHasDecrease() {
        return this.actualResult.getPercentOfFailedTest() < this.oldResult.getPercentOfFailedTest();
    }

    public boolean isPercentOfFailedTestStable() {
        return this.actualResult.getPercentOfFailedTest() == this.oldResult.getPercentOfFailedTest();
    }

    public boolean isAverageOfCompileTimeHasIncrease() {
        return this.actualResult.getAverageOfCompileTime() > this.oldResult.getAverageOfCompileTime();
    }

    public boolean isAverageOfCompileTimeHasDecrease() {
        return this.actualResult.getAverageOfCompileTime() < this.oldResult.getAverageOfCompileTime();
    }

    public boolean isAverageOfCompileTimeStable() {
        return this.actualResult.getAverageOfCompileTime() == this.oldResult.getAverageOfCompileTime();
    }

    public boolean isAverageOfExecutionTimeHasIncrease() {
        return this.actualResult.getAverageOfExecutionTime() > this.oldResult.getAverageOfExecutionTime();
    }

    public boolean isAverageOfExecutionTimeHasDecrease() {
        return this.actualResult.getAverageOfExecutionTime() < this.oldResult.getAverageOfExecutionTime();
    }

    public boolean isAverageOfExecutionTimeStable() {
        return this.actualResult.getAverageOfExecutionTime() == this.oldResult.getAverageOfExecutionTime();
    }

    public boolean isAverageOfPerformanceHasIncrease() {
        return this.actualResult.getAverageOfPerformance() > this.oldResult.getAverageOfPerformance();
    }

    public boolean isAverageOfPerformanceHasDecrease() {
        return this.actualResult.getAverageOfPerformance() < this.oldResult.getAverageOfPerformance();
    }

    public boolean isAverageOfPerformanceStable() {
        return this.actualResult.getAverageOfPerformance() == this.oldResult.getAverageOfPerformance();
    }

    public ArrayList<Test> getNewTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.actualResult.getTests().size(); ++i) {
            if (this.oldResult.getTestWithName(((Test)this.actualResult.getTests().get(i)).getName()) != null) continue;
            result.add((Test)this.actualResult.getTests().get(i));
        }
        return result;
    }

    public int getNumberOfNewTests() {
        return this.getNewTests().size();
    }

    public double getPercentOfNewTests() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfNewTests() / (double)this.actualResult.getNumberOfTest() * 100.0;
        return TrendReport.floor((double)resultat, (int)2);
    }

    public int getNumberOfDeletedTests() {
        return this.getDeletedTests().size();
    }

    public ArrayList<Test> getDeletedTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.oldResult.getTests().size(); ++i) {
            if (this.actualResult.getTestWithName(((Test)this.oldResult.getTests().get(i)).getName()) != null) continue;
            result.add((Test)this.oldResult.getTests().get(i));
        }
        return result;
    }

    public double getPercentOfDeletedTests() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfDeletedTests() / (double)this.actualResult.getNumberOfTest() * 100.0;
        return TrendReport.floor((double)resultat, (int)2);
    }

    public List<Test> getExecutionStatusChangedTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.actualResult.getTests().size(); ++i) {
            Test currentTest = (Test)this.actualResult.getTests().get(i);
            Test oldTest = this.oldResult.getTestWithName(currentTest.getName());
            if (oldTest == null || oldTest.isExecuted() == currentTest.isExecuted()) continue;
            result.add(currentTest);
        }
        return result;
    }

    public int getNumberOfExecutionStatusChangedTests() {
        return this.getExecutionStatusChangedTests().size();
    }

    public double getPercentOfExecutionStatusChangedTests() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfExecutionStatusChangedTests() / (double)this.actualResult.getNumberOfTest() * 100.0;
        return TrendReport.floor((double)resultat, (int)2);
    }

    public List<Test> getSuccessStatusChangedTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.actualResult.getTests().size(); ++i) {
            Test currentTest = (Test)this.actualResult.getTests().get(i);
            Test oldTest = this.oldResult.getTestWithName(currentTest.getName());
            if (oldTest == null || oldTest.isSuccessfull() == currentTest.isSuccessfull()) continue;
            result.add(currentTest);
        }
        return result;
    }

    public int getNumberOfSuccessStatusChangedTests() {
        return this.getSuccessStatusChangedTests().size();
    }

    public double getPercentOfSuccessStatusChangedTests() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfSuccessStatusChangedTests() / (double)this.actualResult.getNumberOfTest() * 100.0;
        return TrendReport.floor((double)resultat, (int)2);
    }
}

