/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.plugins.PerfPublisher.Report.CommandLine;
import hudson.plugins.PerfPublisher.Report.CompileTime;
import hudson.plugins.PerfPublisher.Report.Compiler;
import hudson.plugins.PerfPublisher.Report.Core;
import hudson.plugins.PerfPublisher.Report.DataSet;
import hudson.plugins.PerfPublisher.Report.ExecutionTime;
import hudson.plugins.PerfPublisher.Report.Hardware;
import hudson.plugins.PerfPublisher.Report.Log;
import hudson.plugins.PerfPublisher.Report.Param;
import hudson.plugins.PerfPublisher.Report.Performance;
import hudson.plugins.PerfPublisher.Report.Platform;
import hudson.plugins.PerfPublisher.Report.Processor;
import hudson.plugins.PerfPublisher.Report.Report;
import hudson.plugins.PerfPublisher.Report.Source;
import hudson.plugins.PerfPublisher.Report.Success;
import hudson.plugins.PerfPublisher.Report.Target;
import hudson.plugins.PerfPublisher.Report.Test;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserXml {
    private static Report resultat;
    private static URI xml_path;

    public ParserXml(URI xml) {
        resultat = new Report();
        xml_path = xml;
    }

    public void parse() throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory fabrique = SAXParserFactory.newInstance();
        SAXParser parseur = fabrique.newSAXParser();
        Analyse gestionnaire = new Analyse();
        parseur.parse(new File(xml_path), (DefaultHandler)gestionnaire);
    }

    public Report result() {
        return resultat;
    }

    static class Analyse
    extends DefaultHandler {
        private Report report = new Report();
        private StringBuffer buffer;
        private Platform tmp_platform = new Platform();
        private Test tmp_test;
        private Source tmp_source;
        private DataSet tmp_dataset;
        private CommandLine tmp_cmdline;
        private Param tmp_param;
        private Success tmp_success;
        private CompileTime tmp_compiletime;
        private ExecutionTime tmp_executiontime;
        private Performance tmp_performance;
        private Processor tmp_processor;
        private Core tmp_core;
        private Hardware tmp_hardware;
        private Log tmp_log;
        private Target tmp_target;
        private Compiler tmp_compiler;
        private boolean f_report = false;
        private boolean f_start = false;
        private boolean f_start_date = false;
        private boolean f_start_time = false;
        private boolean f_platform = false;
        private boolean f_os = false;
        private boolean f_os_type = false;
        private boolean f_os_name = false;
        private boolean f_os_version = false;
        private boolean f_os_distribution = false;
        private boolean f_processor = false;
        private boolean f_frequency = false;
        private boolean f_core = false;
        private boolean f_hardware = false;
        private boolean f_compiler = false;
        private boolean f_test = false;
        private boolean f_description = false;
        private boolean f_targets = false;
        private boolean f_target = false;
        private boolean f_errorlog = false;
        private boolean f_source = false;
        private boolean f_dataset = false;
        private boolean f_commandline = false;
        private boolean f_param = false;
        private boolean f_result = false;
        private boolean f_success = false;
        private boolean f_compiletime = false;
        private boolean f_executiontime = false;
        private boolean f_performance = false;
        private boolean f_end = false;
        private boolean f_end_date = false;
        private boolean f_end_time = false;
        private boolean f_log = false;

        public void characters(char[] ch, int start, int length) throws SAXException {
            String lecture = new String(ch, start, length);
            if (this.buffer != null) {
                this.buffer.append(lecture);
            }
        }

        public void endDocument() throws SAXException {
            resultat = this.report;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("report") && this.f_report) {
                this.buffer = new StringBuffer();
                this.f_report = false;
            } else if (qName.equals("start") && this.f_report && this.f_start) {
                this.f_start = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("date") && this.f_report && this.f_start && this.f_start_date) {
                this.f_start_date = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("time") && this.f_report && this.f_start && this.f_start_time) {
                this.f_start_time = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("test") && this.f_report && this.f_test) {
                this.f_test = false;
                this.report.addTest(this.tmp_test);
                this.buffer = new StringBuffer();
            } else if (qName.equals("description") && this.f_report && this.f_test && this.f_description) {
                this.f_description = false;
                this.tmp_test.setDescription(this.buffer.toString());
                this.buffer = new StringBuffer();
            } else if (qName.equals("targets") && this.f_report && this.f_test && this.f_targets) {
                this.f_targets = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("target") && this.f_report && this.f_test && this.f_targets && this.f_target) {
                this.f_target = false;
                this.tmp_target.setName(this.buffer.toString().toUpperCase());
                this.tmp_test.addTarget(this.tmp_target);
                this.buffer = new StringBuffer();
            } else if (qName.equals("platform") && this.f_report && this.f_test && this.f_platform) {
                this.f_platform = false;
                this.tmp_test.setPlateforme(this.tmp_platform);
                this.buffer = new StringBuffer();
            } else if (qName.equals("os") && this.f_report && this.f_test && this.f_platform && this.f_os) {
                this.f_os = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("type") && this.f_report && this.f_test && this.f_platform && this.f_os && this.f_os_type) {
                this.f_os_type = false;
                this.tmp_platform.setOsType(this.buffer.toString());
                this.buffer = new StringBuffer();
            } else if (qName.equals("name") && this.f_report && this.f_test && this.f_platform && this.f_os && this.f_os_name) {
                this.f_os_name = false;
                this.tmp_platform.setOsName(this.buffer.toString());
                this.buffer = new StringBuffer();
            } else if (qName.equals("version") && this.f_report && this.f_test && this.f_platform && this.f_os && this.f_os_version) {
                this.f_os_version = false;
                this.tmp_platform.setOsVersion(this.buffer.toString());
                this.buffer = new StringBuffer();
            } else if (qName.equals("distribution") && this.f_report && this.f_test && this.f_platform && this.f_os && this.f_os_distribution) {
                this.f_os_distribution = false;
                this.tmp_platform.setOsDistribution(this.buffer.toString());
                this.buffer = new StringBuffer();
            } else if (qName.equals("processor") && this.f_report && this.f_test && this.f_platform && this.f_processor) {
                this.f_processor = false;
                this.tmp_platform.setProcessor(this.tmp_processor);
                this.buffer = new StringBuffer();
            } else if (qName.equals("frequency") && this.f_report && this.f_test && this.f_platform && this.f_processor && this.f_frequency) {
                this.f_frequency = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("core") && this.f_report && this.f_test && this.f_platform && this.f_processor && this.f_core) {
                this.f_core = false;
                this.tmp_processor.addCore(this.tmp_core);
                this.buffer = new StringBuffer();
            } else if (qName.equals("hardware") && this.f_report && this.f_test && this.f_platform && this.f_hardware) {
                this.f_hardware = false;
                this.tmp_hardware.setName(this.buffer.toString());
                this.tmp_platform.addHardware(this.tmp_hardware);
                this.buffer = new StringBuffer();
            } else if (qName.equals("compiler") && this.f_report && this.f_test && this.f_platform && this.f_compiler) {
                this.f_compiler = false;
                this.tmp_platform.addCompiler(this.tmp_compiler);
                this.buffer = new StringBuffer();
            } else if (qName.equals("source") && this.f_report && this.f_test && this.f_source) {
                this.f_source = false;
                this.tmp_source.setSource(this.buffer.toString());
                this.tmp_test.addSource(this.tmp_source);
                this.buffer = new StringBuffer();
            } else if (qName.equals("dataset") && this.f_report && this.f_test && this.f_dataset) {
                this.f_dataset = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("commandline") && this.f_report && this.f_test && this.f_commandline) {
                this.tmp_cmdline.setCommand(this.buffer.toString());
                this.tmp_test.addCommandLine(this.tmp_cmdline);
                this.f_commandline = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("param") && this.f_report && this.f_test && this.f_param) {
                this.f_param = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("result") && this.f_report && this.f_test && this.f_result) {
                this.f_result = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("log") && this.f_report && this.f_test && this.f_result && this.f_log) {
                this.f_log = false;
                this.tmp_log.setLog(this.buffer.toString());
                this.tmp_test.addLog(this.tmp_log);
                this.buffer = new StringBuffer();
            } else if (qName.equals("success") && this.f_report && this.f_test && this.f_result && this.f_success) {
                this.f_success = false;
                this.tmp_test.setSuccess(this.tmp_success);
                this.buffer = new StringBuffer();
            } else if (qName.equals("compiletime") && this.f_report && this.f_test && this.f_result && this.f_compiletime) {
                this.f_compiletime = false;
                this.tmp_test.setCompileTime(this.tmp_compiletime);
                this.buffer = new StringBuffer();
            } else if (qName.equals("executiontime") && this.f_report && this.f_test && this.f_result && this.f_executiontime) {
                this.f_executiontime = false;
                this.tmp_test.setExecutionTime(this.tmp_executiontime);
                this.buffer = new StringBuffer();
            } else if (qName.equals("performance") && this.f_report && this.f_test && this.f_result && this.f_performance) {
                this.f_performance = false;
                this.tmp_test.setPerformance(this.tmp_performance);
                this.buffer = new StringBuffer();
            } else if (qName.equals("errorlog") && this.f_report && this.f_test && this.f_result && this.f_errorlog) {
                this.f_errorlog = false;
                if (!this.buffer.toString().equals("") && this.buffer.toString().length() > 1) {
                    this.tmp_test.setMessage(this.buffer.toString());
                }
                this.buffer = new StringBuffer();
            } else if (qName.equals("end") && this.f_report && this.f_end) {
                this.f_end = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("end") && this.f_report && this.f_end) {
                this.f_end = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("date") && this.f_report && this.f_end && this.f_end_date) {
                this.f_end_date = false;
                this.buffer = new StringBuffer();
            } else if (qName.equals("time") && this.f_report && this.f_end && this.f_end_time) {
                this.f_end_time = false;
                this.buffer = new StringBuffer();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("report")) {
                this.report = new Report();
                this.report.setName(attributes.getValue("name"));
                this.report.setCategorie(attributes.getValue("categ"));
                this.buffer = new StringBuffer();
                this.f_report = true;
            } else if (qName.equals("start") && this.f_report) {
                this.f_start = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("date") && this.f_report && this.f_start) {
                this.f_start_date = true;
                this.report.setStartDate(attributes.getValue("val"));
                this.report.setStartDateFormat(attributes.getValue("format"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("time") && this.f_report && this.f_start) {
                this.f_start_time = true;
                this.report.setStartTime(attributes.getValue("val"));
                this.report.setStartTimeFormat(attributes.getValue("format"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("test") && this.f_report) {
                this.f_test = true;
                this.tmp_test = new Test();
                this.tmp_test.setName(attributes.getValue("name"));
                if (attributes.getValue("executed").equals("yes")) {
                    this.tmp_test.setExecuted(true);
                } else {
                    this.tmp_test.setExecuted(false);
                }
                this.buffer = new StringBuffer();
            } else if (qName.equals("description") && this.f_report && this.f_test) {
                this.f_description = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("targets") && this.f_report && this.f_test) {
                this.f_targets = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("target") && this.f_report && this.f_test && this.f_targets) {
                this.f_target = true;
                this.tmp_target = new Target();
                this.tmp_target.setThreaded(Boolean.parseBoolean(attributes.getValue("threaded")));
                this.buffer = new StringBuffer();
            } else if (qName.equals("platform") && this.f_report && this.f_test) {
                this.f_platform = true;
                this.tmp_platform = new Platform();
                this.tmp_platform.setName(attributes.getValue("name"));
                this.tmp_platform.setRemote(Boolean.parseBoolean(attributes.getValue("capspool")));
                this.buffer = new StringBuffer();
            } else if (qName.equals("os") && this.f_report && this.f_test && this.f_platform) {
                this.f_os = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("type") && this.f_report && this.f_test && this.f_platform && this.f_os) {
                this.f_os_type = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("name") && this.f_report && this.f_test && this.f_platform && this.f_os) {
                this.f_os_name = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("version") && this.f_report && this.f_test && this.f_platform && this.f_os) {
                this.f_os_version = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("distribution") && this.f_report && this.f_test && this.f_platform && this.f_os) {
                this.f_os_distribution = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("processor") && this.f_report && this.f_test && this.f_platform) {
                this.f_processor = true;
                this.tmp_processor = new Processor();
                this.tmp_processor.setProcArch(attributes.getValue("arch"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("frequency") && this.f_report && this.f_test && this.f_platform && this.f_processor) {
                this.f_frequency = true;
                this.tmp_processor.setProcFreq(attributes.getValue("cpufreq"));
                this.tmp_processor.setProcFreqUnit(attributes.getValue("unit"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("core") && this.f_report && this.f_test && this.f_platform && this.f_processor) {
                this.f_core = true;
                this.tmp_core = new Core();
                this.tmp_core.setCoreid(Integer.parseInt(attributes.getValue("coreid")));
                this.tmp_core.setProc(Integer.parseInt(attributes.getValue("proc")));
                this.tmp_core.setPhysid(Integer.parseInt(attributes.getValue("physid")));
                this.buffer = new StringBuffer();
            } else if (qName.equals("hardware") && this.f_report && this.f_test && this.f_platform) {
                this.f_hardware = true;
                this.tmp_hardware = new Hardware();
                if (attributes.getValue("hwa") != null && attributes.getValue("hwa").equals("yes")) {
                    this.tmp_hardware.setHwa(true);
                } else {
                    this.tmp_hardware.setHwa(false);
                }
                this.buffer = new StringBuffer();
            } else if (qName.equals("compiler") && this.f_report && this.f_test && this.f_platform) {
                this.f_compiler = true;
                this.tmp_compiler = new Compiler();
                this.tmp_compiler.setName(attributes.getValue("name"));
                this.tmp_compiler.setVersion(attributes.getValue("version"));
                this.tmp_compiler.setPath(attributes.getValue("path"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("source") && this.f_report && this.f_test) {
                this.f_source = true;
                this.tmp_source = new Source();
                this.tmp_source.setComment(attributes.getValue("comment"));
                this.tmp_source.setLanguage(attributes.getValue("language"));
                this.tmp_source.setPath(attributes.getValue("path"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("dataset") && this.f_report && this.f_test) {
                this.f_dataset = true;
                this.tmp_dataset = new DataSet();
                this.tmp_dataset.setPath(attributes.getValue("path"));
                this.tmp_dataset.setType(attributes.getValue("type"));
                if (this.tmp_dataset.getType().equals("input")) {
                    this.tmp_test.setDataSetIn(this.tmp_dataset);
                } else if (this.tmp_dataset.getType().equals("output")) {
                    this.tmp_test.setDataSetOut(this.tmp_dataset);
                }
                this.buffer = new StringBuffer();
            } else if (qName.equals("commandline") && this.f_report && this.f_test) {
                this.f_commandline = true;
                this.tmp_cmdline = new CommandLine();
                this.tmp_cmdline.setTime(attributes.getValue("time"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("param") && this.f_report && this.f_test) {
                this.f_param = true;
                this.tmp_param = new Param();
                this.tmp_param.setName(attributes.getValue("name"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("result") && this.f_report && this.f_test) {
                this.f_result = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("success") && this.f_report && this.f_test && this.f_result) {
                this.f_success = true;
                this.tmp_success = new Success();
                if (attributes.getValue("passed").equals("yes")) {
                    this.tmp_success.setPassed(true);
                } else {
                    this.tmp_success.setPassed(false);
                }
                this.tmp_success.setState(Float.parseFloat(attributes.getValue("state")));
                this.tmp_success.setHasTimedOut(Boolean.parseBoolean(attributes.getValue("hasTimedOut")));
                this.buffer = new StringBuffer();
                this.tmp_test.setIsSuccess(true);
            } else if (qName.equals("compiletime") && this.f_report && this.f_test && this.f_result) {
                this.f_compiletime = true;
                this.tmp_compiletime = new CompileTime();
                this.tmp_compiletime.setUnit(attributes.getValue("unit"));
                this.tmp_compiletime.setMeasure(Double.parseDouble(attributes.getValue("mesure")));
                this.tmp_compiletime.setRelevant(Boolean.parseBoolean(attributes.getValue("isRelevant")));
                this.tmp_test.setIsCompileTime(true);
                this.buffer = new StringBuffer();
            } else if (qName.equals("executiontime") && this.f_report && this.f_test && this.f_result) {
                this.f_executiontime = true;
                this.tmp_executiontime = new ExecutionTime();
                this.tmp_executiontime.setUnit(attributes.getValue("unit"));
                this.tmp_executiontime.setMeasure(Double.parseDouble(attributes.getValue("mesure")));
                this.tmp_executiontime.setRelevant(Boolean.parseBoolean(attributes.getValue("isRelevant")));
                this.tmp_test.setIsExecutionTime(true);
                this.buffer = new StringBuffer();
            } else if (qName.equals("performance") && this.f_report && this.f_test && this.f_result) {
                this.f_performance = true;
                this.tmp_performance = new Performance();
                this.tmp_performance.setUnit(attributes.getValue("unit"));
                this.tmp_performance.setMeasure(Double.parseDouble(attributes.getValue("mesure")));
                this.tmp_performance.setRelevant(Boolean.parseBoolean(attributes.getValue("isRelevant")));
                this.tmp_test.setIsPerformance(true);
                this.buffer = new StringBuffer();
            } else if (qName.equals("errorlog") && this.f_report && this.f_test && this.f_result) {
                this.f_errorlog = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("log") && this.f_report && this.f_test && this.f_result) {
                this.f_log = true;
                this.tmp_log = new Log(attributes.getValue("name"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("end") && this.f_report) {
                this.f_end = true;
                this.buffer = new StringBuffer();
            } else if (qName.equals("date") && this.f_report && this.f_end) {
                this.f_end_date = true;
                this.report.setEndDate(attributes.getValue("val"));
                this.report.setEndDateFormat(attributes.getValue("format"));
                this.buffer = new StringBuffer();
            } else if (qName.equals("time") && this.f_report && this.f_end && this.f_end_time) {
                this.f_end_time = false;
                this.report.setEndTime(attributes.getValue("val"));
                this.report.setEndTimeFormat(attributes.getValue("format"));
                this.buffer = new StringBuffer();
            } else {
                this.buffer = new StringBuffer();
            }
        }
    }
}

