/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.PerfPublisher.AbstractPerfPublisherAction;
import hudson.plugins.PerfPublisher.BrokenDetails;
import hudson.plugins.PerfPublisher.CategoryDetails;
import hudson.plugins.PerfPublisher.ChangedStatusTestsDetails;
import hudson.plugins.PerfPublisher.DeletedTestsDetails;
import hudson.plugins.PerfPublisher.DownloadDiff;
import hudson.plugins.PerfPublisher.ErrorsDetails;
import hudson.plugins.PerfPublisher.FilesDetails;
import hudson.plugins.PerfPublisher.HealthDescriptor;
import hudson.plugins.PerfPublisher.HealthReportBuilder;
import hudson.plugins.PerfPublisher.NewTestsDetails;
import hudson.plugins.PerfPublisher.Report.FileContainer;
import hudson.plugins.PerfPublisher.Report.Report;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import hudson.plugins.PerfPublisher.ReportReader;
import hudson.plugins.PerfPublisher.ReportsDiff;
import hudson.plugins.PerfPublisher.TestDetails;
import hudson.plugins.PerfPublisher.TrendReport;
import hudson.plugins.PerfPublisher.ValidDetails;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfPublisherBuildAction
extends AbstractPerfPublisherAction
implements HealthReportingAction {
    private final AbstractBuild<?, ?> build;
    private Report report;
    private ReportContainer reports = new ReportContainer();
    private FileContainer reportsFiles = new FileContainer();
    private final HealthDescriptor healthDescriptor;
    private int numberOfTest = -1;
    private int numberOfExecutedTest = -1;
    private double percentOfExecutedTest = -1.0;
    private int numberOfNotExecutedTest = -1;
    private double percentOfNotExecutedTest = -1.0;
    private int numberOfPassedTest = -1;
    private double percentOfPassedTest = -1.0;
    private int numberOfFailedTest = -1;
    private double percentOfFailedTest = -1.0;
    private int numberOfCompileTimeTest = -1;
    private double averageOfCompileTime = -1.0;
    private int numberOfExecutionTimeTest = -1;
    private double averageOfExecutionTime = -1.0;
    private int numberOfPerformanceTest = -1;
    private double averageOfPerformance = -1.0;
    private int numberOfNewTests = -1;
    private double percentOfNewTests = -1.0;
    private int numberOfDeletedTests = -1;
    private double percentOfDeletedTests = -1.0;
    private List<Test> executedTests;
    private TrendReport trendReport;
    private int numberOfSuccessStatusChangedTests = -1;
    private int numberOfExecutionStatusChangedTests = -1;
    private double percentOfSuccessStatusChangedTests = -1.0;
    private double percentOfExecutionStatusChangedTests = -1.0;

    public final AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    @Override
    public String getDisplayName() {
        return "Build test report";
    }

    public PerfPublisherBuildAction(AbstractBuild<?, ?> build, ArrayList<String> files, PrintStream logger, HealthDescriptor healthDescriptor) {
        int i;
        this.build = build;
        this.executedTests = new ArrayList<Test>();
        this.healthDescriptor = healthDescriptor;
        for (i = 0; i < files.size(); ++i) {
            String current_report = files.get(i);
            try {
                URI is = build.getWorkspace().child(current_report).toURI();
                logger.println("[CapsAnalysis] Parsing du Report : " + current_report);
                ReportReader rs = new ReportReader(is, logger);
                this.report = rs.getReport();
                this.report.setFile(current_report);
                this.reports.addReport(this.report, false);
                this.reports.addFile(current_report);
            }
            catch (IOException e) {
                logger.println("[CapsAnalysis] Impossible to analyse report " + current_report + ", file can't be read.");
                build.setResult(Result.UNSTABLE);
            }
            catch (InterruptedException e) {
                logger.println("[CapsAnalysis] Impossible to analyse report " + current_report + ", file can't be read.");
                build.setResult(Result.UNSTABLE);
            }
            if (healthDescriptor.getUnstableHealth() <= 0 || this.reports.getNumberOfFailedTest() <= healthDescriptor.getUnstableHealth()) continue;
            build.setResult(Result.UNSTABLE);
            logger.println("[CapsAnalysis] Build status set to UNSTABLE (number of failed test greater than acceptable health level");
        }
        logger.println("[CapsAnalysis] Compute global statistics...");
        this.reports.computeStats();
        logger.println("[CapsAnalysis] [--------------------------------------------------]");
        logger.println("[CapsAnalysis] Number of parsed files : " + this.reports.getNumberOfFiles());
        logger.println("[CapsAnalysis] Number of reports : " + this.reports.getNumberOfReports());
        logger.println("[CapsAnalysis] Number of test : " + this.reports.getNumberOfTest());
        logger.println("[CapsAnalysis] Number of executed test : " + this.reports.getNumberOfExecutedTest());
        logger.println("[CapsAnalysis] Number of not executed test : " + this.reports.getNumberOfNotExecutedTest());
        logger.println("[CapsAnalysis] Number of passed test : " + this.reports.getNumberOfPassedTest());
        logger.println("[CapsAnalysis] Number of failed test : " + this.reports.getNumberOfFailedTest());
        for (i = 0; i < this.reports.getCategories().size(); ++i) {
            logger.println("[CapsAnalysis] ---------------------------------------------------");
            logger.println("[CapsAnalysis] Category : " + this.reports.getCategories().get(i));
            logger.println("[CapsAnalysis]  - Number of test : " + this.reports.getReportOfThisCategorie(this.reports.getCategories().get(i)).getNumberOfTest());
        }
        for (int j = 0; j < this.reports.getNumberOfTest(); ++j) {
            logger.println("[CapsAnalysis] " + this.reports.getTests().get(j).getName());
        }
        logger.println("[CapsAnalysis] ---------------------------------------------------");
        logger.println("[CapsAnalysis] Analysis :");
        logger.println("[CapsAnalysis] ---------------------------------------------------");
        logger.println("[CapsAnalysis] Performance :");
        logger.println("[CapsAnalysis]  - Worst Perfomance : " + this.getReports().getWorstPerformanceTestValue());
        logger.println("[CapsAnalysis]  - Best Perfomance : " + this.getReports().getBestPerformanceTestValue());
        logger.println("[CapsAnalysis]  - Average Perfomance : " + this.getReports().getAverageOfPerformance());
        logger.println("[CapsAnalysis] Execution Time :");
        logger.println("[CapsAnalysis]  - Worst Execution Time : " + this.getReports().getWorstExecutionTimeTestValue());
        logger.println("[CapsAnalysis]  - Best Execution Time : " + this.getReports().getBestExecutionTimeTestValue());
        logger.println("[CapsAnalysis]  - Average Execution Time : " + this.getReports().getAverageOfExecutionTime());
        logger.println("[CapsAnalysis] Compile Time :");
        logger.println("[CapsAnalysis]  - Worst Compile Time : " + this.getReports().getWorstCompileTimeTestValue());
        logger.println("[CapsAnalysis]  - Best Compile Time : " + this.getReports().getBestCompileTimeTestValue());
        logger.println("[CapsAnalysis]  - Average Compile Time : " + this.getReports().getAverageOfCompileTime());
        logger.println("[CapsAnalysis] [--------------------------------------------------]");
    }

    public List<Test> getExecutedTests() {
        if (this.executedTests == null || this.executedTests.size() == 0) {
            this.executedTests = this.reports.getExecutedTests();
        }
        return this.executedTests;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Report getReport() {
        return this.report;
    }

    public ReportContainer getReports() {
        return this.reports;
    }

    public FileContainer getFiles() {
        return this.reportsFiles;
    }

    public String getHtmlListOfBuildsInOptions() {
        StringBuilder strbuilder = new StringBuilder();
        for (AbstractBuild build : this.build.getProject().getBuilds()) {
            PerfPublisherBuildAction ac;
            AbstractBuild abstractBuild = build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (ac = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null) continue;
            strbuilder.append("<option value=\"" + abstractBuild.getNumber() + "\"");
            strbuilder.append(">" + abstractBuild.getNumber() + "</option>\n");
        }
        return strbuilder.toString();
    }

    public String getHtmlListOfBuildsInOptionsWithSelected() {
        StringBuilder strbuilder = new StringBuilder();
        for (AbstractBuild build : this.build.getProject().getBuilds()) {
            PerfPublisherBuildAction ac;
            AbstractBuild abstractBuild = build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (ac = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null) continue;
            strbuilder.append("<option value=\"" + abstractBuild.getNumber() + "\"");
            if (abstractBuild.getNumber() == this.build.getNumber()) {
                strbuilder.append(" selected");
            }
            strbuilder.append(">" + abstractBuild.getNumber() + "</option>\n");
        }
        return strbuilder.toString();
    }

    public String getSummary() {
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("<div class=\"progress-container\">");
        int tmp1 = this.getNumberOfFailedTest();
        int tmp2 = this.getNumberOfPassedTest();
        double tmp3 = this.getPercentOfFailedTest();
        double tmp4 = this.getPercentOfPassedTest();
        if (tmp3 < 15.0) {
            strbuilder.append("<div id=\"red\" style=\"width:15%;\">" + tmp1 + "</div>");
            strbuilder.append("<div id=\"blue\" style=\"width:85%;\">" + tmp2 + "</div>");
        } else {
            strbuilder.append("<div id=\"red\" style=\"width:" + tmp3 + "%;\">" + tmp3 + "% (" + tmp1 + ")</div>");
            strbuilder.append("<div id=\"blue\" style=\"width:" + tmp4 + "%;\">" + tmp4 + "% (" + tmp2 + ")</div>");
        }
        strbuilder.append("</div>");
        return strbuilder.toString();
    }

    public String getDetailSummary() {
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("Number of parsed files : <b>" + this.reports.getNumberOfFiles() + ".</b>");
        strbuilder.append("<br />");
        strbuilder.append("Number of executed tests : <b>" + this.getNumberOfExecutedTest() + ".</b>");
        strbuilder.append("<br />");
        return strbuilder.toString();
    }

    public String getRegression() {
        StringBuilder strb = new StringBuilder();
        ArrayList<Test> regressions = new ArrayList<Test>();
        if (this.getTrendReport() != null) {
            List<Test> tmpTests = this.getTrendReport().getSuccessStatusChangedTests();
            for (int i = 0; i < tmpTests.size(); ++i) {
                if (tmpTests.get(i).isSuccessfull()) continue;
                regressions.add(tmpTests.get(i));
            }
            if (!regressions.isEmpty()) {
                strb.append("<div class=\"warning_regression\">");
                strb.append("This build has discovered " + regressions.size() + " regression(s).");
                strb.append("</div>");
            }
        }
        return strb.toString();
    }

    public void doPolarGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createPolarGraph(), (int)250, (int)250);
    }

    private JFreeChart createPolarGraph() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"a"));
        s1.add(0.0, (double)this.getNumberOfExecutedTest());
        s1.add(90.0, this.getAverageOfPerformance());
        s1.add(180.0, this.getAverageOfExecutionTime());
        s1.add(270.0, this.getAverageOfCompileTime());
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(s1);
        XYSeriesCollection dataset = data;
        JFreeChart chart = ChartFactory.createPolarChart((String)"Polar Chart", (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        PolarPlot plot = (PolarPlot)chart.getPlot();
        DefaultPolarItemRenderer renderer = (DefaultPolarItemRenderer)plot.getRenderer();
        renderer.setSeriesFilled(0, true);
        return chart;
    }

    public TrendReport getTrendReport() {
        if (this.trendReport == null) {
            this.trendReport = this.computeTrendReport();
        }
        return this.trendReport;
    }

    private TrendReport computeTrendReport() {
        PerfPublisherBuildAction ac;
        Run ob = this.build.getPreviousNotFailedBuild();
        AbstractBuild build = (AbstractBuild)ob;
        if (build != null && (ac = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class)) != null) {
            return new TrendReport(this.reports, ac.getReports());
        }
        return null;
    }

    public void doTestGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response, (Run)this.build)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createTestGraph(), (int)800, (int)400);
        }
    }

    private JFreeChart createTestGraph() {
        DefaultStatisticalCategoryDataset timeDS = new DefaultStatisticalCategoryDataset();
        DataSetBuilder lengthDS = new DataSetBuilder();
        for (Test test : this.report.getTests()) {
            timeDS.add((double)test.getSuccess().getState(), test.getCompileTime().getMeasure(), (Comparable)((Object)"Report success state"), (Comparable)((Object)test.getName()));
            lengthDS.add((Number)test.getExecutionTime().getMeasure(), (Comparable)((Object)"Report execution time"), (Comparable)((Object)test.getName()));
        }
        CategoryAxis xAxis = new CategoryAxis("Test name");
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        xAxis.setMaximumCategoryLabelLines(3);
        NumberAxis timeAxis = new NumberAxis("Time (ms)");
        NumberAxis lengthAxis = new NumberAxis("Length (bytes)");
        StatisticalBarRenderer timeRenderer = new StatisticalBarRenderer();
        timeRenderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        timeRenderer.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        timeRenderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        timeRenderer.setItemMargin(0.0);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)timeDS, xAxis, (ValueAxis)timeAxis, (CategoryItemRenderer)timeRenderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        LineAndShapeRenderer lengthRenderer = new LineAndShapeRenderer();
        plot.setRangeAxis(1, (ValueAxis)lengthAxis);
        plot.setDataset(1, lengthDS.build());
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRenderer(1, (CategoryItemRenderer)lengthRenderer);
        JFreeChart chart = new JFreeChart("Test time", (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        Object resultat = null;
        if (link.startsWith("testDetails.")) {
            String testName = StringUtils.substringAfter((String)link, (String)"testDetails.");
            resultat = new TestDetails(this.getOwner(), this.reports.getTestWithName(Test.ResolveTestNameInUrl(testName)));
        } else if (link.startsWith("categoryDetails.")) {
            int indiceCat = Integer.parseInt(StringUtils.substringAfter((String)link, (String)"categoryDetails."));
            resultat = new CategoryDetails(this.getOwner(), this.reports.getReportOfThisCategorie(this.reports.getCategories().get(indiceCat)));
        } else if (link.startsWith("filesDetails.")) {
            int indiceFil = Integer.parseInt(StringUtils.substringAfter((String)link, (String)"filesDetails."));
            resultat = new FilesDetails(this.getOwner(), this.reports.getReportOfThisFile(this.reports.getFiles().get(indiceFil)));
        } else if (link.startsWith("diff")) {
            resultat = new DownloadDiff(this.getOwner(), this.reports);
        } else if (link.startsWith("errorsDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"errorsDetails.");
            resultat = message.equals("all") ? new ErrorsDetails(this.getOwner(), this.reports) : new ErrorsDetails(this.getOwner(), this.reports);
        } else if (link.startsWith("validDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"validDetails.");
            resultat = message.equals("all") ? new ValidDetails(this.getOwner(), this.reports) : new ValidDetails(this.getOwner(), this.reports);
        } else if (link.startsWith("brokenDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"brokenDetails.");
            resultat = message.equals("all") ? new BrokenDetails(this.getOwner(), this.reports) : new BrokenDetails(this.getOwner(), this.reports);
        } else if (link.startsWith("newTestsDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"newTestsDetails.");
            resultat = message.equals("all") ? new NewTestsDetails(this.getOwner(), this.getTrendReport()) : new NewTestsDetails(this.getOwner(), this.getTrendReport());
        } else if (link.startsWith("deletedTestsDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"deletedTestsDetails.");
            resultat = message.equals("all") ? new DeletedTestsDetails(this.getOwner(), this.getTrendReport()) : new DeletedTestsDetails(this.getOwner(), this.getTrendReport());
        } else if (link.startsWith("statusChangedTestsDetails.")) {
            String message = StringUtils.substringAfter((String)link, (String)"statusChangedTestsDetails.");
            resultat = message.equals("all") ? new ChangedStatusTestsDetails(this.getOwner(), this.getTrendReport()) : new ChangedStatusTestsDetails(this.getOwner(), this.getTrendReport());
        } else if (link.startsWith("reportsDiff") && request.getParameter("build1") != null && request.getParameter("build2") != null && request.getParameter("build3") != null) {
            int nb_build1 = 0;
            int nb_build2 = 0;
            int nb_build3 = 0;
            AbstractBuild build1 = null;
            AbstractBuild build2 = null;
            AbstractBuild build3 = null;
            ReportContainer report1 = null;
            ReportContainer report2 = null;
            ReportContainer report3 = null;
            if (!request.getParameter("build1").equals("none")) {
                nb_build1 = Integer.parseInt(request.getParameter("build1"));
                build1 = (AbstractBuild)this.build.getProject().getBuildByNumber(nb_build1);
                PerfPublisherBuildAction ac = (PerfPublisherBuildAction)build1.getAction(PerfPublisherBuildAction.class);
                if (ac != null) {
                    report1 = ac.getReports();
                }
            }
            if (!request.getParameter("build2").equals("none")) {
                nb_build2 = Integer.parseInt(request.getParameter("build2"));
                build2 = (AbstractBuild)this.build.getProject().getBuildByNumber(nb_build2);
                PerfPublisherBuildAction ac2 = (PerfPublisherBuildAction)build2.getAction(PerfPublisherBuildAction.class);
                if (ac2 != null) {
                    report2 = ac2.getReports();
                }
            }
            if (!request.getParameter("build3").equals("none")) {
                nb_build3 = Integer.parseInt(request.getParameter("build3"));
                build3 = (AbstractBuild)this.build.getProject().getBuildByNumber(nb_build3);
                PerfPublisherBuildAction ac3 = (PerfPublisherBuildAction)build3.getAction(PerfPublisherBuildAction.class);
                if (ac3 != null) {
                    report3 = ac3.getReports();
                }
            }
            resultat = new ReportsDiff(this.getOwner(), request, nb_build1, report1, nb_build2, report2, nb_build3, report3);
            return resultat;
        }
        return resultat;
    }

    public HealthDescriptor getHealthDescriptor() {
        return this.healthDescriptor;
    }

    public final HealthReportBuilder getHealthReportBuilder() {
        return new HealthReportBuilder(this.getHealthDescriptor());
    }

    public HealthReport getBuildHealth() {
        return this.getHealthReportBuilder().computeHealth(this.healthDescriptor, this.getReports());
    }

    public FileContainer getReportsFiles() {
        return this.reportsFiles;
    }

    public int getNumberOfTest() {
        if (this.numberOfTest == -1 || this.numberOfTest == 0) {
            this.numberOfTest = this.getReports().getNumberOfTest();
        }
        return this.numberOfTest;
    }

    public int getNumberOfExecutedTest() {
        if (this.numberOfExecutedTest == -1 || this.numberOfExecutedTest == 0) {
            this.numberOfExecutedTest = this.getReports().getNumberOfExecutedTest();
        }
        return this.numberOfExecutedTest;
    }

    public double getPercentOfExecutedTest() {
        if (this.percentOfExecutedTest == -1.0 || this.percentOfExecutedTest == 0.0) {
            this.percentOfExecutedTest = this.getReports().getPercentOfExecutedTest();
        }
        return this.percentOfExecutedTest;
    }

    public int getNumberOfNotExecutedTest() {
        if (this.numberOfNotExecutedTest == -1 || this.numberOfNotExecutedTest == 0) {
            this.numberOfNotExecutedTest = this.getReports().getNumberOfNotExecutedTest();
        }
        return this.numberOfNotExecutedTest;
    }

    public double getPercentOfNotExecutedTest() {
        if (this.percentOfNotExecutedTest == -1.0 || this.percentOfNotExecutedTest == 0.0) {
            this.percentOfNotExecutedTest = this.getReports().getPercentOfNotExecutedTest();
        }
        return this.percentOfNotExecutedTest;
    }

    public int getNumberOfPassedTest() {
        if (this.numberOfPassedTest == -1 || this.numberOfPassedTest == 0) {
            this.numberOfPassedTest = this.getReports().getNumberOfPassedTest();
        }
        return this.numberOfPassedTest;
    }

    public double getPercentOfPassedTest() {
        if (this.percentOfPassedTest == -1.0 || this.percentOfPassedTest == 0.0) {
            this.percentOfPassedTest = this.getReports().getPercentOfPassedTest();
        }
        return this.percentOfPassedTest;
    }

    public int getNumberOfFailedTest() {
        if (this.numberOfFailedTest == -1 || this.numberOfFailedTest == 0) {
            this.numberOfFailedTest = this.getReports().getNumberOfFailedTest();
        }
        return this.numberOfFailedTest;
    }

    public double getPercentOfFailedTest() {
        if (this.percentOfFailedTest == -1.0 || this.percentOfFailedTest == 0.0) {
            this.percentOfFailedTest = this.getReports().getPercentOfFailedTest();
        }
        return this.percentOfFailedTest;
    }

    public int getNumberOfCompileTimeTest() {
        if (this.numberOfCompileTimeTest == -1 || this.numberOfCompileTimeTest == 0) {
            this.numberOfCompileTimeTest = this.getReports().getNumberOfCompileTimeTest();
        }
        return this.numberOfCompileTimeTest;
    }

    public double getAverageOfCompileTime() {
        if (this.averageOfCompileTime == -1.0 || this.averageOfCompileTime == 0.0) {
            this.averageOfCompileTime = this.getReports().getAverageOfCompileTime();
        }
        return this.averageOfCompileTime;
    }

    public int getNumberOfExecutionTimeTest() {
        if (this.numberOfExecutionTimeTest == -1 || this.numberOfExecutionTimeTest == 0) {
            this.numberOfExecutionTimeTest = this.getReports().getNumberOfExecutionTimeTest();
        }
        return this.numberOfExecutionTimeTest;
    }

    public double getAverageOfExecutionTime() {
        if (this.averageOfExecutionTime == -1.0 || this.averageOfExecutionTime == 0.0) {
            this.averageOfExecutionTime = this.getReports().getAverageOfExecutionTime();
        }
        return this.averageOfExecutionTime;
    }

    public int getNumberOfPerformanceTest() {
        if (this.numberOfPerformanceTest == -1 || this.numberOfPerformanceTest == 0) {
            this.numberOfPerformanceTest = this.getReports().getNumberOfPerformanceTest();
        }
        return this.numberOfPerformanceTest;
    }

    public double getAverageOfPerformance() {
        if (this.averageOfPerformance == -1.0 || this.averageOfPerformance == 0.0) {
            this.averageOfPerformance = this.getReports().getAverageOfPerformance();
        }
        return this.averageOfPerformance;
    }

    public int getNumberOfNewTests() {
        if (this.numberOfNewTests == -1 || this.numberOfNewTests == 0) {
            this.numberOfNewTests = this.getTrendReport().getNumberOfNewTests();
        }
        return this.numberOfNewTests;
    }

    public double getPercentOfNewTests() {
        if (this.percentOfNewTests == -1.0 || this.percentOfNewTests == 0.0) {
            this.percentOfNewTests = this.getTrendReport().getPercentOfNewTests();
        }
        return this.percentOfNewTests;
    }

    public int getNumberOfDeletedTests() {
        if (this.numberOfDeletedTests == -1 || this.numberOfDeletedTests == 0) {
            this.numberOfDeletedTests = this.getTrendReport().getNumberOfDeletedTests();
        }
        return this.numberOfDeletedTests;
    }

    public double getPercentOfDeletedTests() {
        if (this.percentOfDeletedTests == -1.0 || this.percentOfDeletedTests == 0.0) {
            this.percentOfDeletedTests = this.getTrendReport().getPercentOfDeletedTests();
        }
        return this.percentOfDeletedTests;
    }

    public int getNumberOfSuccessStatusChangedTests() {
        if (this.numberOfSuccessStatusChangedTests == -1 || this.numberOfSuccessStatusChangedTests == 0) {
            this.numberOfSuccessStatusChangedTests = this.getTrendReport().getNumberOfSuccessStatusChangedTests();
        }
        return this.numberOfSuccessStatusChangedTests;
    }

    public double getPercentOfSuccessStatusChangedTests() {
        if (this.percentOfSuccessStatusChangedTests == -1.0 || this.percentOfSuccessStatusChangedTests == 0.0) {
            this.percentOfSuccessStatusChangedTests = this.getTrendReport().getPercentOfSuccessStatusChangedTests();
        }
        return this.percentOfSuccessStatusChangedTests;
    }

    public int getNumberOfExecutionStatusChangedTests() {
        if (this.numberOfExecutionStatusChangedTests == -1 || this.numberOfExecutionStatusChangedTests == 0) {
            this.numberOfExecutionStatusChangedTests = this.getTrendReport().getNumberOfExecutionStatusChangedTests();
        }
        return this.numberOfExecutionStatusChangedTests;
    }

    public double getPercentOfExecutionStatusChangedTests() {
        if (this.percentOfExecutionStatusChangedTests == -1.0 || this.percentOfExecutionStatusChangedTests == 0.0) {
            this.percentOfExecutionStatusChangedTests = this.getTrendReport().getPercentOfExecutionStatusChangedTests();
        }
        return this.percentOfExecutionStatusChangedTests;
    }
}

