/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.plugins.PerfPublisher.HealthDescriptor;
import hudson.plugins.PerfPublisher.HealthPublisher;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.PerfPublisherParseException;
import hudson.plugins.PerfPublisher.PerfPublisherResultAggregator;
import hudson.plugins.PerfPublisher.projectsAction.PerfPublisherFreestyleProjectAction;
import hudson.plugins.PerfPublisher.projectsAction.PerfPublisherMatrixConfigurationAction;
import hudson.plugins.PerfPublisher.projectsAction.PerfPublisherMatrixProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfPublisherPublisher
extends HealthPublisher
implements MatrixAggregatable {
    private String name;
    private String threshold;
    private String healthy;
    private String unhealthy;
    public static final Descriptor<Publisher> DESCRIPTOR = new PerfPublisherDescriptor();

    @DataBoundConstructor
    public PerfPublisherPublisher(String name, String threshold, String healthy, String unhealthy) {
        this.name = name;
        this.threshold = threshold != "" ? threshold : "0";
        this.healthy = healthy != "" ? healthy : "0";
        this.unhealthy = unhealthy != "" ? unhealthy : "0";
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnhealthy() {
        return this.unhealthy;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getName() {
        return this.name;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixBuild, Launcher launcher, BuildListener listener) {
        return new PerfPublisherResultAggregator(matrixBuild, launcher, listener);
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        HealthDescriptor hl = new HealthDescriptor();
        try {
            hl.setMaxHealth(Integer.parseInt(this.unhealthy));
        }
        catch (NumberFormatException e) {
            hl.setMaxHealth(0);
        }
        try {
            hl.setMinHealth(Integer.parseInt(this.healthy));
        }
        catch (NumberFormatException e) {
            hl.setMinHealth(0);
        }
        try {
            hl.setUnstableHealth(Integer.parseInt(this.threshold));
        }
        catch (NumberFormatException e) {
            hl.setUnstableHealth(0);
        }
        String[] files = this.name.split(",");
        if (files.length > 1) {
            logger.println("[CapsAnalysis] Multiple reports detected.");
        }
        ArrayList<String> filesToParse = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            FileSet fileSet = new FileSet();
            File workspace = new File(build.getWorkspace().toURI());
            fileSet.setDir(workspace);
            fileSet.setIncludes(files[i].trim());
            Project antProject = new Project();
            fileSet.setProject(antProject);
            String[] tmp_files = fileSet.getDirectoryScanner(antProject).getIncludedFiles();
            for (int j = 0; j < tmp_files.length; ++j) {
                if (build.getProject().getWorkspace().child(tmp_files[j]).exists()) {
                    filesToParse.add(tmp_files[j]);
                    continue;
                }
                logger.println("[CapsAnalysis] Impossible to analyse report " + tmp_files[j] + " file not found!");
                build.setResult(Result.UNSTABLE);
            }
        }
        try {
            build.addAction((Action)new PerfPublisherBuildAction(build, filesToParse, logger, hl));
        }
        catch (PerfPublisherParseException gpe) {
            logger.println("[CapsAnalysis] generating reports analysis failed!");
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject project) {
        if (project instanceof MatrixProject) {
            return new PerfPublisherMatrixProjectAction((MatrixProject)project);
        }
        if (project instanceof MatrixConfiguration) {
            return new PerfPublisherMatrixConfigurationAction((MatrixConfiguration)project);
        }
        if (project instanceof FreeStyleProject) {
            return new PerfPublisherFreestyleProjectAction((FreeStyleProject)project);
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PerfPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        protected PerfPublisherDescriptor() {
            super(PerfPublisherPublisher.class);
        }

        public String getDisplayName() {
            return "Activate PerfPublisher for this project";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

