/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher.Report;

import hudson.plugins.PerfPublisher.Report.ErrorMessage;
import hudson.plugins.PerfPublisher.Report.ErrorMessageContainer;
import hudson.plugins.PerfPublisher.Report.Report;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportContainer {
    ArrayList<Report> reports;
    ArrayList<String> files;
    ArrayList<Test> tests = new ArrayList();
    ArrayList<Test> compileTimeTest;
    ArrayList<Test> performanceTest;
    ArrayList<Test> executionTimeTest;
    private Test bestCompileTimeTest;
    private double averageCompileTime;
    private Test worstCompileTimeTest;
    private Test bestExecutionTimeTest;
    private double averageExecutionTime;
    private Test worstExecutionTimeTest;
    private Test bestPerformanceTest;
    private double averagePerformance;
    private Test worstPerformanceTest;
    private int numberOfTest;
    private int numberOfPassedTest;
    private int numberOfNotExecutedTest;
    private int numberOfFailedTest;

    public ReportContainer() {
        this.reports = new ArrayList();
        this.files = new ArrayList();
        this.compileTimeTest = new ArrayList();
        this.performanceTest = new ArrayList();
        this.executionTimeTest = new ArrayList();
    }

    public static double floor(double a, int n) {
        double p = Math.pow(10.0, n);
        return Math.floor(a * p + 0.5) / p;
    }

    public void addReport(Report report, boolean computeStats) {
        if (computeStats) {
            this.addReport(report);
        } else if (this.getReportOfThisCategorie(report.getCategorie()) != null) {
            for (int j = 0; j < report.getNumberOfTest(); ++j) {
                this.getReportOfThisCategorie(report.getCategorie()).addTest(report.getTests().get(j));
            }
        } else {
            this.reports.add(report);
        }
    }

    public void addReport(Report report) {
        if (this.getReportOfThisCategorie(report.getCategorie()) != null) {
            for (int j = 0; j < report.getNumberOfTest(); ++j) {
                this.getReportOfThisCategorie(report.getCategorie()).addTest(report.getTests().get(j));
            }
        } else {
            this.reports.add(report);
        }
        this.computeStats();
    }

    public void computeStats() {
        this.computeGetTests();
        this.computeCompileTimeTest();
        this.computePerformanceTest();
        this.computeExecutionTimeTest();
        this.numberOfTest = this.computeNumberOfTest();
        this.numberOfFailedTest = this.computeNumberOfFailedTest();
        this.numberOfNotExecutedTest = this.computeNumberOfNotExecutedTest();
        this.numberOfPassedTest = this.computeNumberOfPassedTest();
        this.bestCompileTimeTest = this.computeBestCompileTimeTest();
        this.averageCompileTime = this.computeAverageOfCompileTime();
        this.worstCompileTimeTest = this.computeWorstCompileTimeTest();
        this.bestExecutionTimeTest = this.computeBestExecutionTimeTest();
        this.averageExecutionTime = this.computeAverageOfExecutionTime();
        this.worstExecutionTimeTest = this.computeWorstExecutionTimeTest();
        this.bestPerformanceTest = this.computeBestPerformanceTest();
        this.averagePerformance = this.computeAverageOfPerformance();
        this.worstPerformanceTest = this.computeWorstPerformanceTest();
    }

    public String getXmlForDiff() {
        String date = new Date().toString();
        StringBuilder result = new StringBuilder();
        List<Test> tests = this.getTests();
        Collections.sort(tests);
        for (int i = 0; i < tests.size(); ++i) {
            result.append(tests.get(i).getName() + " | ");
            if (tests.get(i).isExecuted()) {
                result.append("YES | ");
            } else {
                result.append("NO | ");
            }
            if (tests.get(i).isSuccessfull()) {
                result.append("YES ");
            } else {
                result.append("NO ");
            }
            result.append("\r\n");
        }
        return result.toString();
    }

    public ErrorMessageContainer getErrorMessageContainer() {
        ErrorMessageContainer result = new ErrorMessageContainer();
        for (int i = 0; i < this.getTests().size(); ++i) {
            if (!this.getTests().get(i).isExecuted() || this.getTests().get(i).isSuccessfull()) continue;
            if (this.getTests().get(i).getMessage() != null) {
                result.addErrorMessage(new ErrorMessage(this.getTests().get(i).getMessage()), this.getTests().get(i));
                continue;
            }
            result.addErrorMessage(new ErrorMessage(""), this.getTests().get(i));
        }
        return result;
    }

    public ErrorMessageContainer getValidMessageContainer() {
        ErrorMessageContainer result = new ErrorMessageContainer();
        for (int i = 0; i < this.getTests().size(); ++i) {
            if (!this.getTests().get(i).isExecuted() || !this.getTests().get(i).isSuccessfull()) continue;
            if (this.getTests().get(i).getMessage() != null) {
                result.addErrorMessage(new ErrorMessage(this.getTests().get(i).getMessage()), this.getTests().get(i));
                continue;
            }
            result.addErrorMessage(new ErrorMessage(""), this.getTests().get(i));
        }
        return result;
    }

    public ErrorMessageContainer getBrokenMessageContainer() {
        ErrorMessageContainer result = new ErrorMessageContainer();
        for (int i = 0; i < this.getTests().size(); ++i) {
            if (this.getTests().get(i).isExecuted()) continue;
            if (this.getTests().get(i).getMessage() != null) {
                result.addErrorMessage(new ErrorMessage(this.getTests().get(i).getMessage()), this.getTests().get(i));
                continue;
            }
            result.addErrorMessage(new ErrorMessage(""), this.getTests().get(i));
        }
        return result;
    }

    public void computeGetTests() {
        this.tests = new ArrayList();
        this.tests.ensureCapacity(this.getNumberOfTest());
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            this.tests.addAll(this.reports.get(i).getTests());
        }
    }

    public List<Test> getTests() {
        if (this.tests == null || this.tests.size() == 0) {
            this.computeGetTests();
        }
        return this.tests;
    }

    public ArrayList<Test> getExecutedTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            tests.addAll(this.reports.get(i).getExecutedTests());
        }
        return tests;
    }

    public ArrayList<Test> getNotExecutedTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            tests.addAll(this.reports.get(i).getNotExecutedTests());
        }
        return tests;
    }

    public int getNumberOfTest() {
        if (this.numberOfTest != 0) {
            return this.numberOfTest;
        }
        this.numberOfTest = this.computeNumberOfTest();
        return this.numberOfTest;
    }

    public int computeNumberOfTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            result += this.reports.get(i).getNumberOfTest();
        }
        return result;
    }

    public int getNumberOfExecutedTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            result += this.reports.get(i).getNumberOfExecutedTest();
        }
        return result;
    }

    public int computeNumberOfNotExecutedTest() {
        return this.getNotExecutedTests().size();
    }

    public int getNumberOfNotExecutedTest() {
        if (this.numberOfNotExecutedTest == 0) {
            this.numberOfNotExecutedTest = this.computeNumberOfNotExecutedTest();
        }
        return this.numberOfNotExecutedTest;
    }

    public double getPercentOfExecutedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfExecutedTest() / (double)this.getNumberOfTest() * 100.0;
        return ReportContainer.floor(resultat, 2);
    }

    public double getPercentOfNotExecutedTest() {
        double resultat = 0.0;
        resultat = 100.0 - this.getPercentOfExecutedTest();
        return ReportContainer.floor(resultat, 2);
    }

    public boolean isPercentOfFailedTestLowFifteen() {
        return this.getPercentOfFailedTest() < 15.0;
    }

    public boolean isPercentOfFailedTestSupFifteen() {
        return this.getPercentOfFailedTest() >= 15.0;
    }

    public int getNumberOfPassedTest() {
        if (this.numberOfPassedTest != 0) {
            return this.numberOfPassedTest;
        }
        this.numberOfPassedTest = this.computeNumberOfPassedTest();
        return this.numberOfPassedTest;
    }

    public int computeNumberOfPassedTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            result += this.reports.get(i).getNumberofPassedTest();
        }
        return result;
    }

    public int getNumberOfFailedTest() {
        if (this.numberOfFailedTest == 0) {
            this.numberOfFailedTest = this.computeNumberOfFailedTest();
        }
        return this.numberOfFailedTest;
    }

    public int computeNumberOfFailedTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            result += this.getReports().get(i).getNumberofFailedTest();
        }
        return result;
    }

    public double getPercentOfFailedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfFailedTest() / this.getNumberOfTrueFalseTest() * 100.0;
        return ReportContainer.floor(resultat, 2);
    }

    public double getPercentOfPassedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfPassedTest() / this.getNumberOfTrueFalseTest() * 100.0;
        return ReportContainer.floor(resultat, 2);
    }

    public double getNumberOfTrueFalseTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            result += this.reports.get(i).getNumberOfSuccessTest();
        }
        return result;
    }

    public void computeCompileTimeTest() {
        this.compileTimeTest = new ArrayList();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            for (int j = 0; j < this.getReports().get(i).getNumberOfExecutedTest(); ++j) {
                if (!this.getReports().get(i).getExecutedTests().get(j).isCompileTime() || !this.getReports().get(i).getExecutedTests().get(j).getCompileTime().isRelevant()) continue;
                this.compileTimeTest.add(this.getReports().get(i).getExecutedTests().get(j));
            }
        }
    }

    public ArrayList<Test> getCompileTimeTest() {
        if (this.compileTimeTest == null) {
            this.computeCompileTimeTest();
        }
        return this.compileTimeTest;
    }

    public int getNumberOfCompileTimeTest() {
        return this.getCompileTimeTest().size();
    }

    private Test computeBestCompileTimeTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfCompileTimeTest(); ++i) {
            if (!(result.getCompileTime().getMeasure() >= this.getCompileTimeTest().get(i).getCompileTime().getMeasure()) && i != 0) continue;
            result = this.getCompileTimeTest().get(i);
        }
        return result;
    }

    public Test getBestCompileTimeTest() {
        if (this.bestCompileTimeTest != null) {
            return this.bestCompileTimeTest;
        }
        this.bestCompileTimeTest = this.computeBestCompileTimeTest();
        return this.bestCompileTimeTest;
    }

    public double getBestCompileTimeTestValue() {
        return this.getBestCompileTimeTest().getCompileTime().getMeasure();
    }

    public String getBestCompileTimeTestName() {
        return this.getBestCompileTimeTest().getName();
    }

    private Test computeWorstCompileTimeTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfCompileTimeTest(); ++i) {
            if (!(result.getCompileTime().getMeasure() < this.getCompileTimeTest().get(i).getCompileTime().getMeasure()) && i != 0) continue;
            result = this.getCompileTimeTest().get(i);
        }
        return result;
    }

    public Test getWorstCompileTimeTest() {
        if (this.worstCompileTimeTest != null) {
            return this.worstCompileTimeTest;
        }
        this.worstCompileTimeTest = this.computeWorstCompileTimeTest();
        return this.worstCompileTimeTest;
    }

    public double getWorstCompileTimeTestValue() {
        return this.getWorstCompileTimeTest().getCompileTime().getMeasure();
    }

    public String getWorstCompileTimeTestName() {
        return this.getWorstCompileTimeTest().getName();
    }

    private double computeAverageOfCompileTime() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfCompileTimeTest(); ++i) {
            result += this.getCompileTimeTest().get(i).getCompileTime().getMeasure();
        }
        if (this.getNumberOfCompileTimeTest() != 0) {
            return ReportContainer.floor(result / (double)this.getNumberOfCompileTimeTest(), 2);
        }
        return 0.0;
    }

    public double getAverageOfCompileTime() {
        if (this.averageCompileTime != 0.0) {
            return this.averageCompileTime;
        }
        this.averageCompileTime = this.computeAverageOfCompileTime();
        return this.averageCompileTime;
    }

    public void computePerformanceTest() {
        this.performanceTest = new ArrayList();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            for (int j = 0; j < this.getReports().get(i).getNumberOfExecutedTest(); ++j) {
                if (!this.getReports().get(i).getExecutedTests().get(j).isPerformance() || !this.getReports().get(i).getExecutedTests().get(j).getPerformance().isRelevant()) continue;
                this.performanceTest.add(this.getReports().get(i).getExecutedTests().get(j));
            }
        }
    }

    public ArrayList<Test> getPerformanceTest() {
        if (this.performanceTest == null) {
            this.computePerformanceTest();
        }
        return this.performanceTest;
    }

    public int getNumberOfPerformanceTest() {
        return this.getPerformanceTest().size();
    }

    private Test computeBestPerformanceTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfPerformanceTest(); ++i) {
            if (!(result.getPerformance().getMeasure() <= this.getPerformanceTest().get(i).getPerformance().getMeasure()) && i != 0) continue;
            result = this.getPerformanceTest().get(i);
        }
        return result;
    }

    public Test getBestPerformanceTest() {
        if (this.bestPerformanceTest != null) {
            return this.bestPerformanceTest;
        }
        this.bestPerformanceTest = this.computeBestPerformanceTest();
        return this.bestPerformanceTest;
    }

    public double getBestPerformanceTestValue() {
        return this.getBestPerformanceTest().getPerformance().getMeasure();
    }

    public String getBestPerformanceTestName() {
        return this.getBestPerformanceTest().getName();
    }

    private Test computeWorstPerformanceTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfPerformanceTest(); ++i) {
            if (!(result.getPerformance().getMeasure() > this.getPerformanceTest().get(i).getPerformance().getMeasure()) && i != 0) continue;
            result = this.getPerformanceTest().get(i);
        }
        return result;
    }

    public Test getWorstPerformanceTest() {
        if (this.worstPerformanceTest != null) {
            return this.worstPerformanceTest;
        }
        this.worstPerformanceTest = this.computeWorstPerformanceTest();
        return this.worstPerformanceTest;
    }

    public double getWorstPerformanceTestValue() {
        return this.getWorstPerformanceTest().getPerformance().getMeasure();
    }

    public String getWorstPerformanceTestName() {
        return this.getWorstPerformanceTest().getName();
    }

    private double computeAverageOfPerformance() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformanceTest(); ++i) {
            result += this.getPerformanceTest().get(i).getPerformance().getMeasure();
        }
        if (this.getNumberOfPerformanceTest() != 0) {
            return ReportContainer.floor(result / (double)this.getNumberOfPerformanceTest(), 2);
        }
        return 0.0;
    }

    public double getAverageOfPerformance() {
        if (this.averagePerformance != 0.0) {
            return this.averagePerformance;
        }
        this.averagePerformance = this.computeAverageOfPerformance();
        return this.averagePerformance;
    }

    public void computeExecutionTimeTest() {
        this.executionTimeTest = new ArrayList();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            for (int j = 0; j < this.getReports().get(i).getNumberOfExecutedTest(); ++j) {
                if (!this.getReports().get(i).getExecutedTests().get(j).isExecutionTime() || !this.getReports().get(i).getExecutedTests().get(j).getExecutionTime().isRelevant()) continue;
                this.executionTimeTest.add(this.getReports().get(i).getExecutedTests().get(j));
            }
        }
    }

    public ArrayList<Test> getExecutionTimeTest() {
        if (this.executionTimeTest == null) {
            this.computeExecutionTimeTest();
        }
        return this.executionTimeTest;
    }

    public int getNumberOfExecutionTimeTest() {
        return this.getExecutionTimeTest().size();
    }

    private Test computeBestExecutionTimeTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfExecutionTimeTest(); ++i) {
            if (!(result.getExecutionTime().getMeasure() >= this.getExecutionTimeTest().get(i).getExecutionTime().getMeasure()) && i != 0) continue;
            result = this.getExecutionTimeTest().get(i);
        }
        return result;
    }

    public Test getBestExecutionTimeTest() {
        if (this.bestExecutionTimeTest != null) {
            return this.bestExecutionTimeTest;
        }
        this.bestExecutionTimeTest = this.computeBestExecutionTimeTest();
        return this.bestExecutionTimeTest;
    }

    public double getBestExecutionTimeTestValue() {
        return this.getBestExecutionTimeTest().getExecutionTime().getMeasure();
    }

    public String getBestExecutionTimeTestName() {
        return this.getBestExecutionTimeTest().getName();
    }

    private Test computeWorstExecutionTimeTest() {
        Test result = new Test();
        for (int i = 0; i < this.getNumberOfExecutionTimeTest(); ++i) {
            if (!(result.getExecutionTime().getMeasure() < this.getExecutionTimeTest().get(i).getExecutionTime().getMeasure()) && i != 0) continue;
            result = this.getExecutionTimeTest().get(i);
        }
        return result;
    }

    public Test getWorstExecutionTimeTest() {
        if (this.worstExecutionTimeTest != null) {
            return this.worstExecutionTimeTest;
        }
        this.worstExecutionTimeTest = this.computeWorstExecutionTimeTest();
        return this.worstExecutionTimeTest;
    }

    public double getWorstExecutionTimeTestValue() {
        return this.getWorstExecutionTimeTest().getExecutionTime().getMeasure();
    }

    public String getWorstExecutionTimeTestName() {
        return this.getWorstExecutionTimeTest().getName();
    }

    private double computeAverageOfExecutionTime() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTimeTest(); ++i) {
            result += this.getExecutionTimeTest().get(i).getExecutionTime().getMeasure();
        }
        if (this.getNumberOfExecutionTimeTest() != 0) {
            return ReportContainer.floor(result / (double)this.getNumberOfExecutionTimeTest(), 2);
        }
        return 0.0;
    }

    public double getAverageOfExecutionTime() {
        if (this.averageExecutionTime != 0.0) {
            return this.averageExecutionTime;
        }
        this.averageExecutionTime = this.computeAverageOfExecutionTime();
        return this.averageExecutionTime;
    }

    public Report getReportOfThisCategorie(String cat) {
        for (int i = 0; i < this.reports.size(); ++i) {
            if (!this.reports.get(i).getCategorie().equalsIgnoreCase(cat)) continue;
            return this.reports.get(i);
        }
        return null;
    }

    public Report getReportOfThisFile(String cat) {
        for (int i = 0; i < this.reports.size(); ++i) {
            if (!this.reports.get(i).getFile().equals(cat)) continue;
            return this.reports.get(i);
        }
        return null;
    }

    public ArrayList<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (int i = 0; i < this.reports.size(); ++i) {
            categories.add(this.reports.get(i).getCategorie());
        }
        return categories;
    }

    public ArrayList<Report> getReports() {
        return this.reports;
    }

    public ArrayList<String> getFiles() {
        return this.files;
    }

    public int getNumberOfFiles() {
        return this.files.size();
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    public ArrayList<Test> getSuccessTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            for (int j = 0; j < this.getReports().get(i).getNumberOfExecutedTest(); ++j) {
                if (!this.getReports().get(i).getExecutedTests().get(j).isSuccess()) continue;
                tests.add(this.getReports().get(i).getExecutedTests().get(j));
            }
        }
        return tests;
    }

    public int getNumberOfSuccessTests() {
        return this.getSuccessTests().size();
    }

    public int getNumberOfReports() {
        return this.reports.size();
    }

    public Test getTestWithName(String testName) {
        for (int i = 0; i < this.getNumberOfReports(); ++i) {
            if (this.getReports().get(i).getTestWithName(testName) == null) continue;
            return this.getReports().get(i).getTestWithName(testName);
        }
        return null;
    }

    public Map<String, Integer> getAllTargets() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < this.getExecutedTests().size(); ++i) {
            Test currentTest = this.getExecutedTests().get(i);
            for (int j = 0; j < currentTest.getTargets().size(); ++j) {
                if (result.containsKey(currentTest.getTargets().get(j).getName())) {
                    result.put(currentTest.getTargets().get(j).getName(), (Integer)result.get(currentTest.getTargets().get(j).getName()) + 1);
                    continue;
                }
                result.put(currentTest.getTargets().get(j).getName(), 1);
            }
        }
        return result;
    }

    public int getNumberOfTargets() {
        return this.getAllTargets().size();
    }

    public String getTargetName(int i) {
        String result = "";
        if (i < 0 || i >= this.getNumberOfTargets()) {
            return result;
        }
        int j = 0;
        for (Map.Entry<String, Integer> currentEntry : this.getAllTargets().entrySet()) {
            if (i == j) {
                return currentEntry.getKey();
            }
            ++j;
        }
        return result;
    }

    public int getTargetNumber(int i) {
        int result = 0;
        if (i < 0 || i >= this.getNumberOfTargets()) {
            return result;
        }
        int j = 0;
        for (Map.Entry<String, Integer> currentEntry : this.getAllTargets().entrySet()) {
            if (j == i) {
                return currentEntry.getValue();
            }
            ++j;
        }
        return result;
    }

    public String getTargetsGraphic() {
        String result = "";
        double percent = 0.0;
        double size = 0.0;
        ArrayList<String> couleurs = new ArrayList<String>();
        couleurs.add("#99CC33");
        couleurs.add("#FF9933");
        couleurs.add("#B88A00");
        couleurs.add("#CC33FF");
        int indice_couleur = 0;
        int indice_target = 0;
        int t_total = 0;
        for (Map.Entry<String, Integer> currentEntry : this.getAllTargets().entrySet()) {
            String col = "";
            if (indice_couleur >= couleurs.size()) {
                indice_couleur = 0;
            }
            col = (String)couleurs.get(indice_couleur);
            percent = ReportContainer.floor(currentEntry.getValue() * 100 / this.getNumberOfExecutedTest(), 2);
            size = ReportContainer.floor(100 / this.getAllTargets().size(), 2);
            t_total = (int)((double)t_total + size);
            if (indice_target == this.getAllTargets().size() - 1) {
                size += (double)(100 - t_total);
            }
            result = result + "<div id=\"red2\" style=\"background-color:" + col + "; width:" + size + "%\">" + currentEntry.getKey() + " (" + currentEntry.getValue() + ")</div>";
            ++indice_couleur;
            ++indice_target;
        }
        return result;
    }
}

