/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher.projectsAction;

import hudson.model.AbstractBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.PerfPublisher.AbstractPerfPublisherAction;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerfPublisherFreestyleProjectAction
extends AbstractPerfPublisherAction {
    private final Project project;

    public PerfPublisherFreestyleProjectAction(FreeStyleProject project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "Global test report";
    }

    public Project getProject() {
        return this.project;
    }

    public ReportContainer getReports() {
        PerfPublisherBuildAction ac;
        Run ob = this.getProject().getLastSuccessfulBuild();
        AbstractBuild build = (AbstractBuild)ob;
        if (build != null && (ac = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class)) != null) {
            return ac.getReports();
        }
        return null;
    }

    public PerfPublisherBuildAction getActionByBuildNumber(int number) {
        return (PerfPublisherBuildAction)this.project.getBuildByNumber(number).getAction(PerfPublisherBuildAction.class);
    }

    public void doTestsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createTestsGraph(), (int)800, (int)250);
    }

    public final void doMiniTestsGraphMap(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createTestsGraph(), (int)800, (int)250);
    }

    public void doMiniTestsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createTestsGraph(), (int)350, (int)200);
    }

    public void doCompileTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createCompileTimeGraph(), (int)800, (int)250);
    }

    public void doMiniCompileTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createCompileTimeGraph(), (int)350, (int)200);
    }

    public void doSuccessGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createSuccessGraph(), (int)800, (int)250);
    }

    public void doMiniSuccessGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createSuccessGraph(), (int)350, (int)200);
    }

    public void doExecutionTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createExecutionTimeGraph(), (int)800, (int)250);
    }

    public void doMiniExecutionTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createExecutionTimeGraph(), (int)350, (int)200);
    }

    public void doPerformanceGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createPerformanceGraph(), (int)800, (int)250);
    }

    public void doMiniPerformanceGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createPerformanceGraph(), (int)350, (int)200);
    }

    public void doStdDevGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createStdDevGraph(), (int)800, (int)150);
        }
    }

    public void doMeanRespLengthGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createMeanRespLengthGraph(), (int)800, (int)150);
        }
    }

    private JFreeChart createSuccessGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReports() == null) continue;
            builder.add((Number)action.getReports().getNumberOfFailedTest(), (Comparable)((Object)"Failed test"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getNumberOfPassedTest(), (Comparable)((Object)"Passed test"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getNumberOfNotExecutedTest(), (Comparable)((Object)"Broken test"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"Evolution of tests success", (String)"Build", (String)"Number of test", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createPerformanceGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReports() == null) continue;
            builder.add((Number)action.getReports().getWorstPerformanceTestValue(), (Comparable)((Object)"Worst Performance"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getAverageOfPerformance(), (Comparable)((Object)"Average Performance"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getBestPerformanceTestValue(), (Comparable)((Object)"Best Performance"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Performances", (String)"Build", (String)"GFlops", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.GREY);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createExecutionTimeGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReports() == null) continue;
            builder.add((Number)action.getReports().getWorstExecutionTimeTestValue(), (Comparable)((Object)"Worst Execution Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getAverageOfExecutionTime(), (Comparable)((Object)"Average Execution Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getBestExecutionTimeTestValue(), (Comparable)((Object)"Best Execution Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Execution Time", (String)"Build", (String)"Execution time", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.GREY);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createCompileTimeGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReports() == null) continue;
            builder.add((Number)action.getReports().getWorstCompileTimeTestValue(), (Comparable)((Object)"Worst Compile Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getAverageOfCompileTime(), (Comparable)((Object)"Average Compile Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getBestCompileTimeTestValue(), (Comparable)((Object)"Best Compile Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Compile Time", (String)"Build", (String)"Compile time", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.GREY);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createTestsGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReports() == null) continue;
            builder.add((Number)action.getReports().getNumberOfNotExecutedTest(), (Comparable)((Object)"Not executed test"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            builder.add((Number)action.getReports().getNumberOfExecutedTest(), (Comparable)((Object)"Executed test"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"Evolution of tests executions", (String)"Build", (String)"Number of test", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createStdDevGraph() {
        return this.createNumberBuildGraph("Standart time deviation", "Time (ms)");
    }

    private JFreeChart createMeanRespLengthGraph() {
        return this.createNumberBuildGraph("Mean respond time", "Length (bytes)");
    }

    private JFreeChart createNumberBuildGraph(String valueName, String unitName) {
        DataSetBuilder builder = new DataSetBuilder();
        for (Object build : this.project.getBuilds()) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE)) continue;
            PerfPublisherBuildAction action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class);
            builder.add((Number)1, (Comparable)((Object)valueName), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
        }
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)(valueName + " Trend"), (String)"Build", (String)unitName, (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private boolean shouldReloadGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        return this.shouldReloadGraph(request, response, this.project.getLastSuccessfulBuild());
    }
}

