/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.SeapineSoftware;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SurroundSCMChangeLogSetEntry
extends ChangeLogSet.Entry {
    private String comment;
    String affectedFile;
    String version;
    String date;
    private User user;
    private String action;

    public SurroundSCMChangeLogSetEntry(String name, String comment, String version, String action, String date, ChangeLogSet parent, String userName) {
        this.affectedFile = name;
        this.comment = comment;
        this.version = version;
        this.action = action;
        this.date = date;
        this.user = User.get((String)userName);
        this.setParent(parent);
    }

    public SurroundSCMChangeLogSetEntry() {
    }

    public String getMsg() {
        return "File: ".concat(this.affectedFile).concat(" Action: ").concat(this.action).concat(" Version: ").concat(this.version).concat(" Comment: ").concat(this.comment);
    }

    public String getMsgAnnotated() {
        return this.affectedFile;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.affectedFile;
    }

    public String getAffectedFile() {
        return this.affectedFile;
    }

    public String getAction() {
        return this.action;
    }

    public String getComment() {
        return this.comment;
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> col = new ArrayList<String>();
        col.add(this.affectedFile);
        return col;
    }

    public User getAuthor() {
        if (this.user == null) {
            return User.getUnknown();
        }
        return this.user;
    }

    @Exported
    public EditType getEditType() {
        if (this.action.equalsIgnoreCase("delete")) {
            return EditType.DELETE;
        }
        if (this.action.equalsIgnoreCase("add")) {
            return EditType.ADD;
        }
        return EditType.EDIT;
    }

    @Exported
    String getPath() {
        return this.affectedFile;
    }
}

