/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.SurroundSCMChangeLogParser;
import hudson.scm.SurroundSCMRevisionState;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class SurroundSCM
extends SCM {
    final int changesThreshold = 5;
    final int pluginVersion = 8;
    private String rsaKeyPath;
    private String server;
    private String serverPort;
    private String userName;
    private String password;
    private String branch;
    private String repository;
    private String surroundSCMExecutable;
    @Extension
    public static final SurroundSCMDescriptor DESCRIPTOR = new SurroundSCMDescriptor();
    public static final String SURROUND_DATETIME_FORMAT_STR = "yyyyMMddHHmmss";
    public static final String SURROUND_DATETIME_FORMAT_STR_2 = "yyyyMMddHH:mm:ss";

    public String getRsaKeyPath() {
        return this.rsaKeyPath;
    }

    public void setRsaKeyPath(String rsaKeyPath) {
        this.rsaKeyPath = rsaKeyPath;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getSurroundSCMExecutable() {
        if (this.surroundSCMExecutable == null) {
            return "sscm";
        }
        return this.surroundSCMExecutable;
    }

    public void setSurroundSCMExecutable(String surroundSCMExecutable) {
        this.surroundSCMExecutable = surroundSCMExecutable;
    }

    @DataBoundConstructor
    public SurroundSCM(String rsaKeyPath, String server, String serverPort, String userName, String password, String branch, String repository, String surroundSCMExecutable) {
        this.rsaKeyPath = rsaKeyPath;
        this.server = server;
        this.serverPort = serverPort;
        this.userName = userName;
        this.password = password;
        this.branch = branch;
        this.repository = repository;
        this.surroundSCMExecutable = surroundSCMExecutable;
    }

    public SurroundSCM() {
    }

    public SCMDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        SimpleDateFormat scm_datetime_formatter = new SimpleDateFormat(SURROUND_DATETIME_FORMAT_STR);
        Date lastBuildDate = build.getTime();
        int lastBuildNum = build.getNumber();
        SurroundSCMRevisionState scmRevisionState = new SurroundSCMRevisionState(lastBuildDate, lastBuildNum);
        listener.getLogger().println("calcRevisionsFromBuild determined revision for build #" + scmRevisionState.getBuildNumber() + " built originally at " + scm_datetime_formatter.format(scmRevisionState.getDate()) + " pluginVer: " + 8);
        return scmRevisionState;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        SimpleDateFormat scm_datetime_formatter = new SimpleDateFormat(SURROUND_DATETIME_FORMAT_STR);
        Date lastBuild = ((SurroundSCMRevisionState)baseline).getDate();
        int lastBuildNum = ((SurroundSCMRevisionState)baseline).getBuildNumber();
        Date now = new Date();
        File temporaryFile = File.createTempFile("changes", "txt");
        temporaryFile.deleteOnExit();
        listener.getLogger().println("Calculating changes since build #" + lastBuildNum + " which happened at " + scm_datetime_formatter.format(lastBuild) + " pluginVer: " + 8);
        temporaryFile.delete();
        double countChanges = this.determineChangeCount(launcher, workspace, listener, lastBuild, now, temporaryFile);
        if (countChanges == 0.0) {
            return PollingResult.NO_CHANGES;
        }
        if (countChanges < 5.0) {
            return PollingResult.SIGNIFICANT;
        }
        return PollingResult.BUILD_NOW;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean returnValue = true;
        SimpleDateFormat scm_datetime_formatter = new SimpleDateFormat(SURROUND_DATETIME_FORMAT_STR_2);
        if (this.server != null) {
            listener.getLogger().println("server: " + this.server);
        }
        Date currentDate = new Date();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(this.getSurroundSCMExecutable());
        cmd.add("get");
        cmd.add("/");
        cmd.add("-wreplace");
        cmd.addMasked("-y".concat(this.userName).concat(":").concat(this.password));
        if (this.rsaKeyPath != null && !this.rsaKeyPath.isEmpty()) {
            cmd.add("-z".concat(this.rsaKeyPath));
        } else {
            cmd.add("-z".concat(this.server).concat(":").concat(this.serverPort));
        }
        cmd.add("-b".concat(this.branch));
        cmd.add("-p".concat(this.repository));
        cmd.add("-d".concat(workspace.getRemote()));
        cmd.add("-r");
        cmd.add("-s" + scm_datetime_formatter.format(currentDate));
        int cmdResult = launcher.launch().cmds(cmd).envs(new String[0]).stdin(null).stdout((OutputStream)listener.getLogger()).pwd(workspace).join();
        if (cmdResult == 0) {
            Date lastBuildDate;
            Run lastBuild = build.getPreviousBuild();
            if (lastBuild == null) {
                lastBuildDate = new Date();
                lastBuildDate.setTime(0L);
                listener.getLogger().print("Never been built.");
            } else {
                lastBuildDate = lastBuild.getTimestamp().getTime();
            }
            SurroundSCMRevisionState scmRevisionState = new SurroundSCMRevisionState(currentDate, build.getNumber());
            build.addAction((Action)scmRevisionState);
            listener.getLogger().println("Checkout calculated ScmRevisionState for build #" + build.getNumber() + " to be the datetime " + scm_datetime_formatter.format(currentDate) + " pluginVer: " + 8);
            returnValue = this.captureChangeLog(launcher, workspace, listener, lastBuildDate, currentDate, changelogFile);
        } else {
            returnValue = false;
        }
        listener.getLogger().println("Checkout completed.");
        return returnValue;
    }

    public ChangeLogParser createChangeLogParser() {
        return new SurroundSCMChangeLogParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean captureChangeLog(Launcher launcher, FilePath workspace, BuildListener listener, Date lastBuildDate, Date currentDate, File changelogFile) throws IOException, InterruptedException {
        boolean result = true;
        SimpleDateFormat scm_datetime_formatter = new SimpleDateFormat(SURROUND_DATETIME_FORMAT_STR);
        String dateRange = scm_datetime_formatter.format(lastBuildDate);
        dateRange = dateRange.concat(":");
        dateRange = dateRange.concat(scm_datetime_formatter.format(currentDate));
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(this.getSurroundSCMExecutable());
        cmd.add("cc");
        cmd.add("/");
        cmd.add("-d".concat(dateRange));
        cmd.addMasked("-y".concat(this.userName).concat(":").concat(this.password));
        if (this.rsaKeyPath != null && !this.rsaKeyPath.isEmpty()) {
            cmd.add("-z".concat(this.rsaKeyPath));
        } else {
            cmd.add("-z".concat(this.server).concat(":").concat(this.serverPort));
        }
        cmd.add("-b".concat(this.branch));
        cmd.add("-p".concat(this.repository));
        cmd.add("-r");
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintWriter writer = new PrintWriter(new FileWriter(changelogFile));
            try {
                int cmdResult = launcher.launch().cmds(cmd).envs(new String[0]).stdin(null).stdout((OutputStream)bos).pwd(workspace).join();
                if (cmdResult != 0) {
                    listener.fatalError("Changelog failed with exit code " + cmdResult);
                    result = false;
                }
            }
            finally {
                writer.close();
                bos.close();
            }
        }
        finally {
            os.close();
        }
        listener.getLogger().println("Changelog calculated successfully.");
        listener.getLogger().println("Change log file: " + changelogFile.getAbsolutePath());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double determineChangeCount(Launcher launcher, FilePath workspace, TaskListener listener, Date lastBuildDate, Date currentDate, File changelogFile) throws IOException, InterruptedException {
        SimpleDateFormat scm_datetime_formatter = new SimpleDateFormat(SURROUND_DATETIME_FORMAT_STR);
        double changesCount = 0.0;
        if (this.server != null) {
            listener.getLogger().println("in determine Change Count server: " + this.server);
        }
        String dateRange = scm_datetime_formatter.format(lastBuildDate);
        dateRange = dateRange.concat(":");
        dateRange = dateRange.concat(scm_datetime_formatter.format(currentDate));
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(this.getSurroundSCMExecutable());
        cmd.add("cc");
        cmd.add("/");
        cmd.add("-d".concat(dateRange));
        cmd.addMasked("-y".concat(this.userName).concat(":").concat(this.password));
        if (this.rsaKeyPath != null && !this.rsaKeyPath.isEmpty()) {
            cmd.add("-z".concat(this.rsaKeyPath));
        } else {
            cmd.add("-z".concat(this.server).concat(":").concat(this.serverPort));
        }
        cmd.add("-b".concat(this.branch));
        cmd.add("-p".concat(this.repository));
        cmd.add("-r");
        listener.getLogger().println("determineChangeCount executing the command: " + cmd.toString() + " with date range: [ " + dateRange + " ]");
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            try {
                int cmdResult = launcher.launch().cmds(cmd).envs(new String[0]).stdin(null).stdout((OutputStream)bos).pwd(workspace).join();
                if (cmdResult != 0) {
                    listener.fatalError("Determine changes count failed with exit code " + cmdResult);
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            os.close();
        }
        BufferedReader br = null;
        String line = null;
        try {
            br = new BufferedReader(new FileReader(changelogFile));
            line = br.readLine();
            if (line != null) {
                listener.getLogger().println(line);
                String num = line.substring(6);
                try {
                    changesCount = Double.valueOf(num.trim());
                }
                catch (NumberFormatException nfe) {
                    listener.fatalError("NumberFormatException: " + nfe.getMessage());
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        listener.getLogger().println("Number of changes determined to be: " + changesCount);
        return changesCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SurroundSCMDescriptor
    extends SCMDescriptor<SurroundSCM> {
        protected SurroundSCMDescriptor() {
            super(SurroundSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "Surround SCM";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            SurroundSCM scm = (SurroundSCM)((Object)req.bindJSON(SurroundSCM.class, formData));
            return scm;
        }
    }
}

