/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.URLSCM;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.URLSCM.URLDateAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLSCM
extends SCM {
    private final ArrayList<URLTuple> urls = new ArrayList();
    private final boolean clearWorkspace;

    public URLSCM(String[] u, boolean clear) {
        for (int i = 0; i < u.length; ++i) {
            this.urls.add(new URLTuple(u[i]));
        }
        this.clearWorkspace = clear;
    }

    public URLTuple[] getUrls() {
        return this.urls.toArray(new URLTuple[this.urls.size()]);
    }

    public boolean isClearWorkspace() {
        return this.clearWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        if (this.clearWorkspace) {
            workspace.deleteContents();
        }
        URLDateAction dates = new URLDateAction();
        for (URLTuple tuple : this.urls) {
            String urlString = tuple.getUrl();
            InputStream is = null;
            OutputStream os = null;
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                dates.setLastModified(urlString, conn.getLastModified());
                is = conn.getInputStream();
                String path = new File(url.getPath()).getName();
                listener.getLogger().append("Copying " + urlString + " to " + path + "\n");
                os = workspace.child(path).write();
                byte[] buf = new byte[8192];
                int i = 0;
                while ((i = is.read(buf)) != -1) {
                    os.write(buf, 0, i);
                }
            }
            catch (Exception e) {
                listener.error("Unable to copy " + urlString + "\n" + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            build.addAction((Action)dates);
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new NullChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean change = false;
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        URLDateAction dates = (URLDateAction)lastBuild.getAction(URLDateAction.class);
        if (dates == null) {
            return true;
        }
        for (URLTuple tuple : this.urls) {
            String urlString = tuple.getUrl();
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                long lastMod = conn.getLastModified();
                long lastBuildMod = dates.getLastModified(urlString);
                if (lastBuildMod == lastMod) continue;
                listener.getLogger().println("Found change: " + urlString + " modified " + new Date(lastMod) + " previous modification was " + new Date(lastBuildMod));
                change = true;
            }
            catch (Exception e) {
                listener.error("Unable to check " + urlString + "\n" + e.getMessage());
            }
        }
        return change;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<URLSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        private DescriptorImpl() {
            super(URLSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "URL Copy";
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new URLSCM(req.getParameterValues("URL.url"), req.getParameter("URL.clear") != null);
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            return true;
        }

        public void doUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.URLCheck(req, rsp){

                protected void check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)this.request.getParameter("value"));
                    try {
                        this.open(new URL(url));
                    }
                    catch (Exception e) {
                        this.error("Cannot open " + url);
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }

    public static final class URLTuple {
        private String urlString;

        public URLTuple(String s) {
            this.urlString = s;
        }

        public String getUrl() {
            return this.urlString;
        }
    }
}

