/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.URLSCM;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.URLSCM.URLDateAction;
import hudson.plugins.URLSCM.URLSCM;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;

public class URLSCM
extends SCM {
    private final ArrayList<URLTuple> urls = new ArrayList();
    private final boolean clearWorkspace;

    public URLSCM(String[] u, boolean clear) {
        for (int i = 0; i < u.length; ++i) {
            this.urls.add(new URLTuple(u[i]));
        }
        this.clearWorkspace = clear;
    }

    public URLTuple[] getUrls() {
        return this.urls.toArray(new URLTuple[this.urls.size()]);
    }

    public boolean isClearWorkspace() {
        return this.clearWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        if (this.clearWorkspace) {
            workspace.deleteContents();
        }
        URLDateAction dates = new URLDateAction(build);
        for (URLTuple tuple : this.urls) {
            String urlString = tuple.getUrl();
            InputStream is = null;
            OutputStream os = null;
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                dates.setLastModified(urlString, conn.getLastModified());
                is = conn.getInputStream();
                String path = new File(url.getPath()).getName();
                listener.getLogger().append("Copying " + urlString + " to " + path + "\n");
                os = workspace.child(path).write();
                byte[] buf = new byte[8192];
                int i = 0;
                while ((i = is.read(buf)) != -1) {
                    os.write(buf, 0, i);
                }
            }
            catch (Exception e) {
                listener.error("Unable to copy " + urlString + "\n" + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        build.addAction((Action)dates);
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new NullChangeLogParser();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean change = false;
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        URLDateAction dates = (URLDateAction)lastBuild.getAction(URLDateAction.class);
        if (dates == null) {
            return true;
        }
        for (URLTuple tuple : this.urls) {
            String urlString = tuple.getUrl();
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                long lastMod = conn.getLastModified();
                long lastBuildMod = dates.getLastModified(urlString);
                if (lastBuildMod == lastMod) continue;
                listener.getLogger().println("Found change: " + urlString + " modified " + new Date(lastMod) + " previous modification was " + new Date(lastBuildMod));
                change = true;
            }
            catch (Exception e) {
                listener.error("Unable to check " + urlString + "\n" + e.getMessage());
            }
        }
        return change;
    }
}

