/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.URLSCM;

import hudson.model.AbstractBuild;
import hudson.model.AbstractModelObject;
import hudson.model.Action;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLDateAction
extends AbstractModelObject
implements Action {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Long> lastModified = new HashMap();
    private final AbstractBuild build;

    protected URLDateAction(AbstractBuild build) {
        this.build = build;
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    public long getLastModified(String u) {
        Long l = this.lastModified.get(u);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public void setLastModified(String u, long l) {
        this.lastModified.put(u, l);
    }

    public Map<String, String> getUrlDates() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, Long> e : this.lastModified.entrySet()) {
            long sinceEpoch = e.getValue();
            if (sinceEpoch == 0L) {
                ret.put(e.getKey(), "Last-modified not supported");
                continue;
            }
            ret.put(e.getKey(), DateFormat.getInstance().format(new Date(sinceEpoch)));
        }
        return ret;
    }

    public String getDisplayName() {
        return "URL Modification Dates";
    }

    public String getIconFileName() {
        return "save.gif";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getUrlName() {
        return "urlDates";
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        req.getView((Object)this, this.chooseAction()).forward((ServletRequest)req, (ServletResponse)rsp);
    }

    protected String chooseAction() {
        return "tagForm.jelly";
    }
}

