/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.websvn2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class WebSVN2RepositoryBrowser
extends SubversionRepositoryBrowser {
    private static final String CHANGE_SET_FORMAT = "revision.php?%1srev=%2d";
    private static final String DIFF_FORMAT = "diff.php?%1spath=%2s&rev=%3d";
    private static final String FILE_FORMAT = "filedetails.php?%1spath=%2s&rev=%3d";
    private static final Pattern URL_PATTERN = Pattern.compile("(.*/)(revision|diff|comp|filedetails|listing|blame|dl|log)\\.php([^?]*)\\?(repname=([^&]*))?(.*)");
    private static final int URL_PATTERN_BASE_URL_GROUP = 1;
    private static final int URL_PATTERN_REPNAME_GROUP = 4;
    public final URL url;
    private final URL baseUrl;
    private final String repname;

    @DataBoundConstructor
    public WebSVN2RepositoryBrowser(URL url) throws MalformedURLException {
        Matcher webSVNurl = URL_PATTERN.matcher(url.toString());
        this.url = url;
        if (!webSVNurl.matches()) {
            this.repname = "";
            this.baseUrl = url;
        } else {
            this.baseUrl = new URL(webSVNurl.group(1));
            this.repname = webSVNurl.group(4) + "&";
        }
    }

    public String getRepname() {
        return this.repname;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.baseUrl, String.format(DIFF_FORMAT, this.getRepname(), URLEncoder.encode(path.getValue(), "UTF-8"), path.getLogEntry().getRevision()));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.baseUrl, String.format(FILE_FORMAT, this.getRepname(), URLEncoder.encode(path.getValue(), "UTF-8"), path.getLogEntry().getRevision()));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.baseUrl, String.format(CHANGE_SET_FORMAT, this.getRepname(), changeSet.getRevision()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(WebSVN2RepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "WebSVN2";
        }

        public FormValidation doCheckReposUrl(@QueryParameter String value) {
            FormValidation result;
            block5: {
                Matcher matcher = URL_PATTERN.matcher(value);
                if (matcher.matches()) {
                    try {
                        URL repUrl = new URL(matcher.group(1));
                        String repName = matcher.group(4);
                        if (repName == null || "".equals(repName)) {
                            result = FormValidation.okWithMarkup((String)"Please set a url including the repname property if needed.");
                            break block5;
                        }
                        result = FormValidation.ok();
                    }
                    catch (MalformedURLException ex) {
                        result = FormValidation.error((String)("The entered url is not accepted: " + ex.getLocalizedMessage()));
                    }
                } else {
                    result = "".equals(value) ? FormValidation.okWithMarkup((String)"Please set a WebSVN url in the form https://<i>server</i>/websvn/listing.php?repname=<i>rep</i>&path=/trunk/..") : FormValidation.error((String)"Please set a url including the WebSVN php script.");
                }
            }
            return result;
        }

        public WebSVN2RepositoryBrowser newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (WebSVN2RepositoryBrowser)((Object)req.bindParameters(WebSVN2RepositoryBrowser.class, "webSVN2."));
        }
    }
}

