/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccurevTransaction
extends ChangeLogSet.Entry {
    private String revision;
    private User author;
    private Date date;
    private String msg;
    private String action;
    private List<String> affectedPaths = new ArrayList<String>();
    private int id;

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public User getAuthor() {
        return this.author;
    }

    public Collection<String> getAffectedPaths() {
        return this.affectedPaths;
    }

    public void setUser(String author) {
        this.author = User.get((String)author);
    }

    public String getUser() {
        return this.author.getDisplayName();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setAction(String action) {
        this.action = action;
        if ("chstream".equals(action) && (this.msg == null || "".equals(this.msg))) {
            this.msg = "Changed Parent Stream";
        }
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public EditType getEditType() {
        if (this.action.equals("promote")) {
            return EditType.EDIT;
        }
        if (this.action.equals("defunct")) {
            return EditType.DELETE;
        }
        if (this.action.equals("chstream")) {
            return EditType.EDIT;
        }
        if (this.action.equals("add")) {
            return EditType.ADD;
        }
        return EditType.EDIT;
    }

    public void addAffectedPath(String path) {
        this.affectedPaths.add(path);
    }

    public String getAction() {
        return this.action;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

