/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevChangeLogSet;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.plugins.accurev.AccurevWorkspace;
import hudson.plugins.jetty.security.Password;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOException2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.codehaus.plexus.util.StringOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccurevSCM
extends SCM {
    private static final Logger logger = Logger.getLogger(AccurevSCM.class.getName());
    public static final SimpleDateFormat ACCUREV_DATETIME_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final long MILLIS_PER_SECOND = 1000L;
    private final String serverName;
    private final String depot;
    private final String stream;
    private final boolean useWorkspace;
    private final boolean useUpdate;
    private final boolean synctime;
    private final String workspace;
    private final String workspaceSubPath;
    public static final AccurevSCMDescriptor DESCRIPTOR = new AccurevSCMDescriptor();

    public AccurevSCM(String serverName, String depot, String stream, boolean useWorkspace, String workspace, String workspaceSubPath, boolean synctime, boolean useUpdate) {
        this.serverName = serverName;
        this.depot = depot;
        this.stream = stream;
        this.useWorkspace = useWorkspace;
        this.workspace = workspace;
        this.workspaceSubPath = workspaceSubPath;
        this.synctime = synctime;
        this.useUpdate = useUpdate;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild;
        HashMap<String, String> accurevEnv;
        String accurevPath = (String)workspace.act((FilePath.FileCallable)new FindAccurevHome());
        AccurevServer server = DESCRIPTOR.getServer(this.serverName);
        if (!this.accurevLogin(server, accurevEnv = new HashMap<String, String>(), workspace, listener, accurevPath, launcher)) {
            return false;
        }
        if (this.synctime) {
            listener.getLogger().println("Synchronizing clock with the server...");
            if (!this.synctime(server, accurevEnv, workspace, listener, accurevPath, launcher)) {
                return false;
            }
        }
        if ((lastBuild = project.getLastBuild()) == null) {
            listener.getLogger().println("Project has never been built");
            return true;
        }
        Date buildDate = lastBuild.getTimestamp().getTime();
        listener.getLogger().println("Last build on " + buildDate);
        Map<String, AccurevStream> streams = this.getStreams(server, accurevEnv, workspace, listener, accurevPath, launcher);
        AccurevStream stream = streams.get(this.stream);
        if (stream == null) {
            return this.checkStreamForChanges(server, accurevEnv, workspace, listener, accurevPath, launcher, this.stream, buildDate);
        }
        do {
            if (!this.checkStreamForChanges(server, accurevEnv, workspace, listener, accurevPath, launcher, stream.getName(), buildDate)) continue;
            return true;
        } while ((stream = stream.getParent()) != null && stream.isReceivingChangesFromParent());
        return false;
    }

    private boolean checkStreamForChanges(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, TaskListener listener, String accurevPath, Launcher launcher, String stream, Date buildDate) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(accurevPath);
        cmd.add("hist");
        this.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(this.depot);
        cmd.add("-s");
        cmd.add(stream);
        cmd.add("-t");
        cmd.add("now.1");
        StringOutputStream sos = new StringOutputStream();
        int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, (OutputStream)sos, workspace);
        if (0 != rv) {
            listener.fatalError("History command failed with exit code " + rv);
            return false;
        }
        try {
            XmlPullParser parser = AccurevSCM.newPullParser();
            parser.setInput((Reader)new StringReader(sos.toString()));
            while (parser.next() != 2 || !parser.getName().equalsIgnoreCase("transaction")) {
            }
            String transactionId = parser.getAttributeValue("", "id");
            String transactionType = parser.getAttributeValue("", "type");
            String transactionTime = parser.getAttributeValue("", "time");
            String transactionUser = parser.getAttributeValue("", "user");
            Date transactionDate = AccurevSCM.convertAccurevTimestamp(transactionTime);
            listener.getLogger().println("Last change on " + transactionDate);
            listener.getLogger().println("#" + transactionId + " " + transactionUser + " " + transactionType);
            String transactionComment = null;
            boolean inComment = false;
            while (transactionComment == null) {
                switch (parser.next()) {
                    case 2: {
                        inComment = parser.getName().equalsIgnoreCase("comment");
                        break;
                    }
                    case 3: {
                        inComment = false;
                        break;
                    }
                    case 4: {
                        if (!inComment) break;
                        transactionComment = parser.getText();
                        break;
                    }
                    case 1: {
                        transactionComment = "";
                    }
                }
            }
            if (transactionComment != null) {
                listener.getLogger().println(transactionComment);
            }
            return buildDate == null || buildDate.compareTo(transactionDate) < 0;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace(listener.getLogger());
            logger.warning(e.getMessage());
            return false;
        }
    }

    private boolean synctime(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, TaskListener listener, String accurevPath, Launcher launcher) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(accurevPath);
        cmd.add("synctime");
        this.addServer(cmd, server);
        StringOutputStream sos = new StringOutputStream();
        int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, (OutputStream)sos, workspace);
        if (0 != rv) {
            listener.fatalError("Synctime command failed with exit code " + rv);
            return false;
        }
        return true;
    }

    private Map<String, AccurevStream> getStreams(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, TaskListener listener, String accurevPath, Launcher launcher) throws IOException, InterruptedException {
        HashMap<String, AccurevStream> streams = new HashMap<String, AccurevStream>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(accurevPath);
        cmd.add("show");
        this.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(this.depot);
        cmd.add("streams");
        StringOutputStream sos = new StringOutputStream();
        int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, (OutputStream)sos, workspace);
        if (0 != rv) {
            listener.fatalError("Show streams command failed with exit code " + rv);
            return null;
        }
        try {
            XmlPullParser parser = AccurevSCM.newPullParser();
            parser.setInput((Reader)new StringReader(sos.toString()));
            block10: while (true) {
                switch (parser.next()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (AccurevStream stream : streams.values()) {
                            if (stream.getBasisName() == null) continue;
                            stream.setParent((AccurevStream)streams.get(stream.getBasisName()));
                        }
                        return streams;
                    }
                    case 2: {
                        String tagName = parser.getName();
                        if (!"stream".equalsIgnoreCase(tagName)) break;
                        String streamName = parser.getAttributeValue("", "name");
                        String streamNumber = parser.getAttributeValue("", "streamNumber");
                        String basisStreamName = parser.getAttributeValue("", "basis");
                        String basisStreamNumber = parser.getAttributeValue("", "basisStreamNumber");
                        String streamType = parser.getAttributeValue("", "type");
                        String streamIsDynamic = parser.getAttributeValue("", "isDynamic");
                        String streamTimeString = parser.getAttributeValue("", "time");
                        Date streamTime = streamTimeString == null ? null : AccurevSCM.convertAccurevTimestamp(streamTimeString);
                        String streamStartTimeString = parser.getAttributeValue("", "startTime");
                        Date streamStartTime = streamTimeString == null ? null : AccurevSCM.convertAccurevTimestamp(streamTimeString);
                        try {
                            AccurevStream stream = new AccurevStream(streamName, streamNumber == null ? null : Long.valueOf(streamNumber), this.depot, basisStreamName, basisStreamNumber == null ? null : Long.valueOf(basisStreamNumber), streamIsDynamic == null ? false : Boolean.parseBoolean(streamIsDynamic), AccurevStream.StreamType.parseStreamType(streamType), streamTime, streamStartTime);
                            streams.put(streamName, stream);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace(listener.getLogger());
                        }
                        continue block10;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace(listener.getLogger());
            logger.warning(e.getMessage());
            return null;
        }
    }

    private Map<String, AccurevWorkspace> getWorkspaces(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, TaskListener listener, String accurevPath, Launcher launcher) throws IOException, InterruptedException {
        HashMap<String, AccurevWorkspace> workspaces = new HashMap<String, AccurevWorkspace>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(accurevPath);
        cmd.add("show");
        this.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(this.depot);
        cmd.add("wspaces");
        StringOutputStream sos = new StringOutputStream();
        int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, (OutputStream)sos, workspace);
        if (0 != rv) {
            listener.fatalError("Show workspaces command failed with exit code " + rv);
            return null;
        }
        try {
            XmlPullParser parser = AccurevSCM.newPullParser();
            parser.setInput((Reader)new StringReader(sos.toString()));
            block10: while (true) {
                switch (parser.next()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return workspaces;
                    }
                    case 2: {
                        String tagName = parser.getName();
                        if (!"Element".equalsIgnoreCase(tagName)) break;
                        String name = parser.getAttributeValue("", "Name");
                        String storage = parser.getAttributeValue("", "Storage");
                        String host = parser.getAttributeValue("", "Host");
                        String streamNumber = parser.getAttributeValue("", "Stream");
                        String depot = parser.getAttributeValue("", "depot");
                        try {
                            workspaces.put(name, new AccurevWorkspace(depot, streamNumber == null ? null : Long.valueOf(streamNumber), name, host, storage));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace(listener.getLogger());
                        }
                        continue block10;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace(listener.getLogger());
            logger.warning(e.getMessage());
            return null;
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        HashMap<String, String> accurevEnv;
        AccurevServer server;
        String accurevPath = (String)workspace.act((FilePath.FileCallable)new FindAccurevHome());
        if (!this.useWorkspace || !this.useUpdate || build.getPreviousBuild() != null && build.getPreviousBuild().getResult().isWorseThan(Result.UNSTABLE)) {
            workspace.act((FilePath.FileCallable)new PurgeWorkspaceContents((TaskListener)listener));
        }
        if (!this.accurevLogin(server = DESCRIPTOR.getServer(this.serverName), accurevEnv = new HashMap<String, String>(), workspace, (TaskListener)listener, accurevPath, launcher)) {
            return false;
        }
        if (this.synctime) {
            listener.getLogger().println("Synchronizing clock with the server...");
            if (!this.synctime(server, accurevEnv, workspace, (TaskListener)listener, accurevPath, launcher)) {
                return false;
            }
        }
        listener.getLogger().println("Getting a list of streams...");
        Map<String, AccurevStream> streams = this.getStreams(server, accurevEnv, workspace, (TaskListener)listener, accurevPath, launcher);
        if (this.depot == null || "".equals(this.depot)) {
            listener.fatalError("Must specify a depot");
            return false;
        }
        if (this.stream == null || "".equals(this.stream)) {
            listener.fatalError("Must specify a stream");
            return false;
        }
        if (streams != null && !streams.containsKey(this.stream)) {
            listener.fatalError("The specified stream does not appear to exist!");
            return false;
        }
        if (this.useWorkspace && (this.workspace == null || "".equals(this.workspace))) {
            listener.fatalError("Must specify a workspace");
            return false;
        }
        if (this.useWorkspace) {
            int rv;
            String oldStorage;
            RemoteWorkspaceDetails remoteDetails;
            listener.getLogger().println("Getting a list of workspaces...");
            Map<String, AccurevWorkspace> workspaces = this.getWorkspaces(server, accurevEnv, workspace, (TaskListener)listener, accurevPath, launcher);
            if (workspaces == null) {
                listener.fatalError("Cannot determine workspace configuration information");
                return false;
            }
            if (!workspaces.containsKey(this.workspace)) {
                listener.fatalError("The specified workspace does not appear to exist!");
                return false;
            }
            AccurevWorkspace accurevWorkspace = workspaces.get(this.workspace);
            if (!this.depot.equals(accurevWorkspace.getDepot())) {
                listener.fatalError("The specified workspace, " + this.workspace + ", is based in the depot " + accurevWorkspace.getDepot() + " not " + this.depot);
                return false;
            }
            for (AccurevStream accurevStream : streams.values()) {
                if (!accurevWorkspace.getStreamNumber().equals(accurevStream.getNumber())) continue;
                accurevWorkspace.setStream(accurevStream);
                break;
            }
            try {
                remoteDetails = (RemoteWorkspaceDetails)workspace.act((Callable)new DetermineRemoteHostname(workspace.getRemote()));
            }
            catch (IOException e) {
                listener.fatalError("Unable to validate workspace host.");
                e.printStackTrace(listener.getLogger());
                return false;
            }
            boolean needsRelocation = false;
            ArgumentListBuilder cmd = new ArgumentListBuilder();
            cmd.add(accurevPath);
            cmd.add("chws");
            this.addServer(cmd, server);
            cmd.add("-w");
            cmd.add(this.workspace);
            if (!this.stream.equals(accurevWorkspace.getStream().getParent().getName())) {
                listener.getLogger().println("Parent stream needs to be updated.");
                needsRelocation = true;
                cmd.add("-b");
                cmd.add(this.stream);
            }
            if (!accurevWorkspace.getHost().equals(remoteDetails.getHostName())) {
                listener.getLogger().println("Host needs to be updated.");
                needsRelocation = true;
                cmd.add("-m");
                cmd.add(remoteDetails.getHostName());
            }
            if (!(oldStorage = accurevWorkspace.getStorage().replace("/", remoteDetails.getFileSeparator()).replace("\\", remoteDetails.getFileSeparator())).equals(remoteDetails.getPath())) {
                listener.getLogger().println("Storage needs to be updated.");
                needsRelocation = true;
                cmd.add("-l");
                cmd.add(workspace.getRemote());
            }
            if (needsRelocation) {
                listener.getLogger().println("Relocating workspace...");
                listener.getLogger().println("  Old host: " + accurevWorkspace.getHost());
                listener.getLogger().println("  New host: " + remoteDetails.getHostName());
                listener.getLogger().println("  Old storage: " + oldStorage);
                listener.getLogger().println("  New storage: " + remoteDetails.getPath());
                listener.getLogger().println("  Old parent stream: " + accurevWorkspace.getStream().getParent().getName());
                listener.getLogger().println("  New parent stream: " + this.stream);
                listener.getLogger().println(cmd.toStringWithQuote());
                rv = this.launchAccurev(launcher, cmd, accurevEnv, null, listener.getLogger(), workspace);
                if (rv != 0) {
                    listener.fatalError("Relocation failed with exit code " + rv);
                    return false;
                }
                listener.getLogger().println("Relocation successfully.");
            }
            listener.getLogger().println("Updating workspace...");
            cmd = new ArgumentListBuilder();
            cmd.add(accurevPath);
            cmd.add("update");
            this.addServer(cmd, server);
            rv = this.launchAccurev(launcher, cmd, accurevEnv, null, listener.getLogger(), workspace);
            if (rv != 0) {
                listener.fatalError("Update failed with exit code " + rv);
                return false;
            }
            listener.getLogger().println("Update completed successfully.");
            listener.getLogger().println("Populating workspace...");
            cmd = new ArgumentListBuilder();
            cmd.add(accurevPath);
            cmd.add("pop");
            this.addServer(cmd, server);
            cmd.add("-R");
            if (this.workspaceSubPath == null || this.workspaceSubPath.trim().length() == 0) {
                cmd.add(".");
            } else {
                cmd.add(this.workspaceSubPath);
            }
            if (rv != 0) {
                listener.fatalError("Populate failed with exit code " + rv);
                return false;
            }
            listener.getLogger().println("Populate completed successfully.");
        } else {
            listener.getLogger().println("Populating workspace...");
            ArgumentListBuilder cmd = new ArgumentListBuilder();
            cmd.add(accurevPath);
            cmd.add("pop");
            this.addServer(cmd, server);
            cmd.add("-v");
            cmd.add(this.stream);
            cmd.add("-L");
            cmd.add(workspace.getRemote());
            cmd.add("-R");
            if (this.workspaceSubPath == null || this.workspaceSubPath.trim().length() == 0) {
                cmd.add(".");
            } else {
                cmd.add(this.workspaceSubPath);
            }
            int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, listener.getLogger(), workspace);
            if (rv != 0) {
                listener.fatalError("Populate failed with exit code " + rv);
                return false;
            }
            listener.getLogger().println("Populate completed successfully.");
        }
        listener.getLogger().println("Calculating changelog...");
        Calendar startTime = null;
        if (null == build.getPreviousBuild()) {
            listener.getLogger().println("Cannot find a previous build to compare against. Computing all changes.");
        } else {
            startTime = build.getPreviousBuild().getTimestamp();
        }
        AccurevStream stream = streams.get(this.stream);
        if (stream == null) {
            return this.captureChangelog(server, accurevEnv, workspace, listener, accurevPath, launcher, build.getTimestamp().getTime(), startTime == null ? null : startTime.getTime(), this.stream, changelogFile);
        }
        do {
            if (!this.checkStreamForChanges(server, accurevEnv, workspace, (TaskListener)listener, accurevPath, launcher, stream.getName(), startTime == null ? null : startTime.getTime())) continue;
            return this.captureChangelog(server, accurevEnv, workspace, listener, accurevPath, launcher, build.getTimestamp().getTime(), startTime == null ? null : startTime.getTime(), stream.getName(), changelogFile);
        } while ((stream = stream.getParent()) != null && stream.isReceivingChangesFromParent());
        return this.captureChangelog(server, accurevEnv, workspace, listener, accurevPath, launcher, build.getTimestamp().getTime(), startTime == null ? null : startTime.getTime(), this.stream, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean captureChangelog(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, BuildListener listener, String accurevPath, Launcher launcher, Date buildDate, Date startDate, String stream, File changelogFile) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(accurevPath);
        cmd.add("hist");
        this.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-a");
        cmd.add("-s");
        cmd.add(stream);
        cmd.add("-t");
        String dateRange = ACCUREV_DATETIME_FORMATTER.format(buildDate);
        dateRange = startDate != null ? dateRange + "-" + ACCUREV_DATETIME_FORMATTER.format(startDate) : dateRange + ".100";
        cmd.add(dateRange);
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            try {
                int rv = this.launchAccurev(launcher, cmd, accurevEnv, null, bos, workspace);
                if (rv != 0) {
                    listener.fatalError("Changelog failed with exit code " + rv);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            os.close();
        }
        listener.getLogger().println("Changelog calculated successfully.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accurevLogin(AccurevServer server, Map<String, String> accurevEnv, FilePath workspace, TaskListener listener, String accurevPath, Launcher launcher) throws IOException, InterruptedException {
        if (server != null) {
            boolean[] masks;
            accurevEnv.put("ACCUREV_HOME", workspace.getParent().getRemote());
            listener.getLogger().println("Authenticating with Accurev server...");
            ArgumentListBuilder cmd = new ArgumentListBuilder();
            cmd.add(accurevPath);
            cmd.add("login");
            this.addServer(cmd, server);
            cmd.add(server.getUsername());
            if (server.getPassword() == null || "".equals(server.getPassword())) {
                cmd.addQuoted("");
                masks = new boolean[cmd.toCommandArray().length];
            } else {
                cmd.add(server.getPassword());
                masks = new boolean[cmd.toCommandArray().length];
                masks[masks.length - 1] = true;
            }
            String resp = null;
            AccurevSCMDescriptor.ACCUREV_LOCK.lock();
            try {
                StringOutputStream sos = new StringOutputStream();
                int rv = launcher.launch(cmd.toCommandArray(), masks, Util.mapToEnv(accurevEnv), null, (OutputStream)sos, workspace).join();
                resp = rv == 0 ? null : sos.toString();
            }
            finally {
                AccurevSCMDescriptor.ACCUREV_LOCK.unlock();
            }
            if (null == resp || "".equals(resp)) {
                listener.getLogger().println("Authentication completed successfully.");
                return true;
            }
            listener.fatalError("Authentication failed: " + resp);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int launchAccurev(Launcher launcher, ArgumentListBuilder cmd, Map<String, String> env, InputStream in, OutputStream os, FilePath workspace) throws IOException, InterruptedException {
        int rv;
        AccurevSCMDescriptor.ACCUREV_LOCK.lock();
        try {
            rv = launcher.launch(cmd.toCommandArray(), Util.mapToEnv(env), in, os, workspace).join();
        }
        finally {
            AccurevSCMDescriptor.ACCUREV_LOCK.unlock();
        }
        return rv;
    }

    private void addServer(ArgumentListBuilder cmd, AccurevServer server) {
        if (null != server && null != server.getHost() && !"".equals(server.getHost())) {
            cmd.add("-H");
            if (server.getPort() != 0) {
                cmd.add(server.getHost() + ":" + server.getPort());
            } else {
                cmd.add(server.getHost());
            }
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new AccurevChangeLogParser();
    }

    public boolean isUseWorkspace() {
        return this.useWorkspace;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDepot() {
        return this.depot;
    }

    public String getStream() {
        return this.stream;
    }

    public String getWorkspaceSubPath() {
        return this.workspaceSubPath;
    }

    public boolean isSynctime() {
        return this.synctime;
    }

    private static Date convertAccurevTimestamp(String transactionTime) {
        if (transactionTime == null) {
            return null;
        }
        try {
            long time = Long.parseLong(transactionTime);
            long date = time * 1000L;
            return new Date(date);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static XmlPullParser newPullParser() throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XmlPullParser parser = factory.newPullParser();
        return parser;
    }

    public SCMDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetermineRemoteHostname
    implements Callable<RemoteWorkspaceDetails, UnknownHostException> {
        private final String path;

        public DetermineRemoteHostname(String path) {
            this.path = path;
        }

        public RemoteWorkspaceDetails call() throws UnknownHostException {
            String path;
            InetAddress addr = InetAddress.getLocalHost();
            File f = new File(this.path);
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                path = f.getAbsolutePath();
            }
            return new RemoteWorkspaceDetails(addr.getCanonicalHostName(), path, File.separator);
        }
    }

    private static class RemoteWorkspaceDetails
    implements Serializable {
        private final String hostName;
        private final String path;
        private final String fileSeparator;

        public RemoteWorkspaceDetails(String hostName, String path, String fileSeparator) {
            this.hostName = hostName;
            this.path = path;
            this.fileSeparator = fileSeparator;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getPath() {
            return this.path;
        }

        public String getFileSeparator() {
            return this.fileSeparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AccurevChangeLogParser
    extends ChangeLogParser {
        private AccurevChangeLogParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeLogSet<AccurevTransaction> parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
            List<AccurevTransaction> transactions = null;
            try {
                XmlPullParser parser = AccurevSCM.newPullParser();
                FileReader fis = null;
                BufferedReader bis = null;
                try {
                    fis = new FileReader(changelogFile);
                    bis = new BufferedReader(fis);
                    parser.setInput((Reader)bis);
                    transactions = this.parseTransactions(parser);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (XmlPullParserException e) {
                throw new IOException2((Throwable)e);
            }
            logger.info("transations size = " + transactions.size());
            return new AccurevChangeLogSet(build, transactions);
        }

        private List<AccurevTransaction> parseTransactions(XmlPullParser parser) throws IOException, XmlPullParserException {
            ArrayList<AccurevTransaction> transactions = new ArrayList<AccurevTransaction>();
            AccurevTransaction currentTransaction = null;
            boolean inComment = false;
            block7: while (true) {
                switch (parser.next()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return transactions;
                    }
                    case 2: {
                        String tagName = parser.getName();
                        inComment = "comment".equalsIgnoreCase(tagName);
                        if ("transaction".equalsIgnoreCase(tagName)) {
                            currentTransaction = new AccurevTransaction();
                            transactions.add(currentTransaction);
                            currentTransaction.setRevision(parser.getAttributeValue("", "id"));
                            currentTransaction.setUser(parser.getAttributeValue("", "user"));
                            currentTransaction.setDate(AccurevSCM.convertAccurevTimestamp(parser.getAttributeValue("", "time")));
                            currentTransaction.setAction(parser.getAttributeValue("", "type"));
                            break;
                        }
                        if (!"version".equalsIgnoreCase(tagName) || currentTransaction == null) continue block7;
                        String path = parser.getAttributeValue("", "path");
                        if (path != null && (path = path.replace("\\", "/")).startsWith("/./")) {
                            path = path.substring(3);
                        }
                        currentTransaction.addAffectedPath(path);
                        break;
                    }
                    case 3: {
                        inComment = false;
                        break;
                    }
                    case 4: {
                        if (!inComment || currentTransaction == null) continue block7;
                        currentTransaction.setMsg(parser.getText());
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindAccurevHome
    implements FilePath.FileCallable<String> {
        private String[] nonWindowsPaths = new String[]{"/usr/local/bin/accurev", "/usr/bin/accurev", "/bin/accurev", "/local/bin/accurev"};
        private String[] windowsPaths = new String[]{"C:\\Program Files\\AccuRev\\bin\\accurev.exe", "C:\\Program Files (x86)\\AccuRev\\bin\\accurev.exe"};

        private FindAccurevHome() {
        }

        private static String getExistingPath(String[] paths) {
            for (int i = 0; i < paths.length; ++i) {
                if (!new File(paths[i]).exists()) continue;
                return paths[i];
            }
            return paths[0];
        }

        public String invoke(File f, VirtualChannel channel) throws IOException {
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                return FindAccurevHome.getExistingPath(this.windowsPaths);
            }
            return FindAccurevHome.getExistingPath(this.nonWindowsPaths);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PurgeWorkspaceContents
    implements FilePath.FileCallable<Boolean> {
        private final TaskListener listener;

        public PurgeWorkspaceContents(TaskListener listener) {
            this.listener = listener;
        }

        public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
            this.listener.getLogger().println("Purging workspace...");
            Util.deleteContentsRecursive((File)ws);
            this.listener.getLogger().println("Workspace purged.");
            return Boolean.TRUE;
        }
    }

    public static final class AccurevServer {
        private String name;
        private String host;
        private int port;
        private String username;
        private String password;

        public AccurevServer() {
        }

        public AccurevServer(String name, String host, int port, String username, String password) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return Password.deobfuscate(this.password);
        }

        public void setPassword(String password) {
            this.password = Password.obfuscate(password);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AccurevSCMDescriptor
    extends SCMDescriptor<AccurevSCM>
    implements ModelObject {
        static final transient Lock ACCUREV_LOCK = new ReentrantLock();
        private List<AccurevServer> servers;

        protected AccurevSCMDescriptor() {
            super(AccurevSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "Accurev";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "accurev.");
            this.servers = req.bindParametersToList(AccurevServer.class, "accurev.server.");
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return (SCM)req.bindParameters(AccurevSCM.class, "accurev.");
        }

        public List<AccurevServer> getServers() {
            if (this.servers == null) {
                this.servers = new ArrayList<AccurevServer>();
            }
            return this.servers;
        }

        public void setServers(List<AccurevServer> servers) {
            this.servers = servers;
        }

        public AccurevServer getServer(String name) {
            if (name == null) {
                return null;
            }
            for (AccurevServer server : this.servers) {
                if (!name.equals(server.getName())) continue;
                return server;
            }
            return null;
        }

        public String[] getServerNames() {
            String[] result = new String[this.servers.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.servers.get(i).getName();
            }
            return result;
        }
    }
}

