/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.Variant;
import com4j.typelibs.activeDirectory.IADs;
import com4j.typelibs.activeDirectory.IADsGroup;
import com4j.typelibs.activeDirectory.IADsOpenDSObject;
import com4j.typelibs.activeDirectory.IADsUser;
import com4j.typelibs.ado20.ClassFactory;
import com4j.typelibs.ado20._Command;
import com4j.typelibs.ado20._Connection;
import com4j.typelibs.ado20._Recordset;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;

public class ActiveDirectoryAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private final String defaultNamingContext;
    private final _Connection con;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryAuthenticationProvider.class.getName());

    public ActiveDirectoryAuthenticationProvider() {
        IADs rootDSE = (IADs)COM4J.getObject(IADs.class, (String)"LDAP://RootDSE", null);
        this.defaultNamingContext = (String)rootDSE.get("defaultNamingContext");
        LOGGER.info("Active Directory domain is " + this.defaultNamingContext);
        this.con = ClassFactory.createConnection();
        this.con.provider("ADsDSOObject");
        this.con.open("Active Directory Provider", "", "", -1);
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        IADsUser usr;
        String password = (String)authentication.getCredentials();
        _Command cmd = ClassFactory.createCommand();
        cmd.activeConnection(this.con);
        cmd.commandText("<LDAP://" + this.defaultNamingContext + ">;(sAMAccountName=" + username + ");distinguishedName;subTree");
        _Recordset rs = cmd.execute(null, (Object)Variant.MISSING, -1);
        if (rs.eof()) {
            throw new UsernameNotFoundException("No such user: " + username);
        }
        String dn = rs.fields().item((Object)"distinguishedName").value().toString();
        IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
        try {
            usr = (IADsUser)dso.openDSObject("LDAP://" + dn, dn, password, 0).queryInterface(IADsUser.class);
        }
        catch (ComException e) {
            throw new BadCredentialsException("Incorrect password for " + username);
        }
        ArrayList<GrantedAuthorityImpl> groups = new ArrayList<GrantedAuthorityImpl>();
        for (Com4jObject g : usr.groups()) {
            IADsGroup grp = (IADsGroup)g.queryInterface(IADsGroup.class);
            groups.add(new GrantedAuthorityImpl(grp.name().substring(3)));
        }
        return new ActiveDirectoryUserDetail(username, password, !usr.accountDisabled(), true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
    }
}

