/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.sun.jndi.ldap.LdapCtxFactory;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.GroupDetailsService;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements UserDetailsService,
GroupDetailsService {
    private final String[] domainNames;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());

    public ActiveDirectoryUnixAuthenticationProvider(String domainName) {
        this.domainNames = domainName.split(",");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException("Active-directory plugin doesn't support user retrieval");
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        UserDetails userDetails = null;
        for (String domainName : this.domainNames) {
            try {
                userDetails = this.retrieveUser(username, authentication, domainName);
            }
            catch (BadCredentialsException bce) {
                LOGGER.log(Level.WARNING, "Credential exception tying to authenticate against " + domainName + " domain", bce);
            }
            if (userDetails != null) break;
        }
        if (userDetails == null) {
            LOGGER.log(Level.WARNING, "Exhausted all configured domains and could not authenticat against any.");
            throw new BadCredentialsException("Either no such user '" + username + "' or incorrect password");
        }
        return userDetails;
    }

    private UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication, String domainName) throws AuthenticationException {
        DirContext context;
        String password = null;
        if (authentication != null) {
            password = (String)authentication.getCredentials();
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        String principalName = username + '@' + domainName;
        props.put("java.naming.security.principal", principalName);
        props.put("java.naming.security.credentials", password);
        props.put("java.naming.referral", "follow");
        try {
            context = LdapCtxFactory.getLdapCtxInstance("ldap://" + ActiveDirectorySecurityRealm.DesciprotrImpl.INSTANCE.obtainLDAPServer(domainName) + '/', props);
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to bind to LDAP", e);
            throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", (Throwable)e);
        }
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> renum = context.search(ActiveDirectoryUnixAuthenticationProvider.toDC((String)domainName), "(& (userPrincipalName=" + principalName + ")(objectClass=user))", controls);
            if (!renum.hasMore() && !(renum = context.search(ActiveDirectoryUnixAuthenticationProvider.toDC((String)domainName), "(& (sAMAccountName=" + username + ")(objectClass=user))", controls)).hasMore()) {
                throw new BadCredentialsException("Authentication was successful but cannot locate the user information for " + username);
            }
            SearchResult result = renum.next();
            Attribute memberOf = result.getAttributes().get("memberOf");
            Set groups = this.resolveGroups(memberOf, context);
            groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            context.close();
            return new ActiveDirectoryUserDetail(username, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve user information for " + username, e);
            throw new BadCredentialsException("Failed to retrieve user information for " + username, (Throwable)e);
        }
    }

    private Set<GrantedAuthority> resolveGroups(Attribute memberOf, DirContext context) throws NamingException {
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        LinkedList<Attribute> membershipList = new LinkedList<Attribute>();
        membershipList.add(memberOf);
        while (!membershipList.isEmpty()) {
            Attribute memberships = (Attribute)membershipList.removeFirst();
            if (memberships == null) continue;
            for (int i = 0; i < memberships.size(); ++i) {
                Attribute members;
                Attributes atts = context.getAttributes("\"" + memberships.get(i) + '\"', new String[]{"CN", "memberOf"});
                Attribute cn = atts.get("CN");
                if (!groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString())) || (members = atts.get("memberOf")) == null) continue;
                membershipList.add(members);
            }
        }
        return groups;
    }

    private static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    public GroupDetails loadGroupByGroupname(String groupname) {
        throw new UserMayOrMayNotExistException(groupname);
    }
}

