/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import groovy.lang.Binding;
import hudson.Util;
import hudson.model.Hudson;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.GroupDetailsService;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActiveDirectorySecurityRealm
extends SecurityRealm {
    public final String domain;
    public final String site;
    public final String bindName;
    public final Secret bindPassword;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword) {
        this.domain = Util.fixEmpty((String)domain);
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(this.getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("realm", (Object)this);
        builder.parse(this.getClass().getResourceAsStream("ActiveDirectory.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context));
    }

    public DesciprotrImpl getDescriptor() {
        return (DesciprotrImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        StringWriter out;
        block11: {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                UserDetailsService uds = this.getSecurityComponents().userDetails;
                if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                    ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                    DesciprotrImpl descriptor = this.getDescriptor();
                    try {
                        pw.println("Domain=" + this.domain + " site=" + this.site);
                        List ldapServers = descriptor.obtainLDAPServer(this.domain, this.site);
                        pw.println("List of domain controllers: " + ldapServers);
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, this.domain, Collections.singletonList(ldapServer));
                                pw.println("Authenticated as " + d);
                            }
                            catch (AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                        break block11;
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                        break block11;
                    }
                }
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        GroupDetailsService groupDetailsService = (GroupDetailsService)this.getSecurityComponents().userDetails;
        return groupDetailsService.loadGroupByGroupname(groupname);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

