/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.GroupDetailsService;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements UserDetailsService,
GroupDetailsService {
    private final String[] domainNames;
    private final String site;
    private final String bindName;
    private final String bindPassword;
    private final ActiveDirectorySecurityRealm.DesciprotrImpl descriptor;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());

    public ActiveDirectoryUnixAuthenticationProvider(ActiveDirectorySecurityRealm realm) {
        this.domainNames = realm.domain.split(",");
        this.site = realm.site;
        this.bindName = realm.bindName;
        this.bindPassword = realm.bindPassword == null ? null : realm.bindPassword.toString();
        this.descriptor = realm.getDescriptor();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException("Active-directory plugin doesn't support user retrieval");
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        UserDetails userDetails = null;
        for (String domainName : this.domainNames) {
            try {
                userDetails = this.retrieveUser(username, authentication, domainName);
            }
            catch (BadCredentialsException bce) {
                LOGGER.log(Level.WARNING, "Credential exception tying to authenticate against " + domainName + " domain", bce);
            }
            if (userDetails != null) break;
        }
        if (userDetails == null) {
            LOGGER.log(Level.WARNING, "Exhausted all configured domains and could not authenticat against any.");
            throw new BadCredentialsException("Either no such user '" + username + "' or incorrect password");
        }
        return userDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication, String domainName) throws AuthenticationException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            List ldapServers;
            String password = null;
            if (authentication != null) {
                password = (String)authentication.getCredentials();
            }
            try {
                ldapServers = this.descriptor.obtainLDAPServer(domainName, this.site);
            }
            catch (NamingException e) {
                LOGGER.log(Level.WARNING, "Failed to find the LDAP service", e);
                throw new AuthenticationServiceException("Failed to find the LDAP service for the domain " + domainName, (Throwable)e);
            }
            UserDetails userDetails = this.retrieveUser(username, password, domainName, ldapServers);
            return userDetails;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public UserDetails retrieveUser(String username, String password, String domainName, List<SocketInfo> ldapServers) {
        DirContext context;
        String id;
        if (this.bindName != null) {
            try {
                id = username;
                context = this.descriptor.bind(this.bindName, this.bindPassword, ldapServers);
            }
            catch (BadCredentialsException e) {
                throw new AuthenticationServiceException("Failed to bind to LDAP server with the bind name/password", (Throwable)e);
            }
        } else {
            String principalName = this.getPrincipalName(username, domainName);
            id = principalName.substring(0, principalName.indexOf(64));
            context = this.descriptor.bind(principalName, password, ldapServers);
        }
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> renum = context.search(ActiveDirectoryUnixAuthenticationProvider.toDC((String)domainName), "(& (userPrincipalName={0})(objectClass=user))", new Object[]{id}, controls);
            if (!renum.hasMore()) {
                LOGGER.fine("Failed to find " + id + " in userPrincipalName. Trying sAMAccountName");
                renum = context.search(ActiveDirectoryUnixAuthenticationProvider.toDC((String)domainName), "(& (sAMAccountName={0})(objectClass=user))", new Object[]{id}, controls);
                if (!renum.hasMore()) {
                    throw new BadCredentialsException("Authentication was successful but cannot locate the user information for " + username);
                }
            }
            SearchResult result = renum.next();
            if (this.bindName != null) {
                Object dn = result.getAttributes().get("distinguishedName").get();
                if (dn == null) {
                    throw new BadCredentialsException("No distinguished name for " + username);
                }
                LOGGER.fine("Attempting to validate password for DN=" + dn);
                DirContext test = this.descriptor.bind(dn.toString(), password, ldapServers);
                test.close();
            }
            Set groups = this.resolveGroups(result.getAttributes(), context);
            groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            context.close();
            return new ActiveDirectoryUserDetail(id, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve user information for " + username, e);
            throw new BadCredentialsException("Failed to retrieve user information for " + username, (Throwable)e);
        }
    }

    private String getPrincipalName(String username, String domainName) {
        int slash = username.indexOf(92);
        String principalName = slash > 0 ? username.substring(slash + 1) + '@' + username.substring(0, slash) + '.' + domainName : (username.contains("@") ? username + '.' + domainName : username + '@' + domainName);
        return principalName;
    }

    private Set<GrantedAuthority> resolveGroups(Attributes identity, DirContext context) throws NamingException {
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        LinkedList<Attributes> membershipList = new LinkedList<Attributes>();
        membershipList.add(identity);
        while (!membershipList.isEmpty()) {
            identity = (Attributes)membershipList.removeFirst();
            Attribute memberOf = identity.get("memberOf");
            if (memberOf == null) continue;
            for (int i = 0; i < memberOf.size(); ++i) {
                Attributes group;
                Attribute cn;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(identity.get("CN").get() + " is a member of " + memberOf.get(i));
                }
                if (!groups.add((GrantedAuthority)new GrantedAuthorityImpl((cn = (group = context.getAttributes("\"" + memberOf.get(i) + '\"', new String[]{"CN", "memberOf"})).get("CN")).get().toString()))) continue;
                membershipList.add(group);
            }
        }
        return groups;
    }

    private static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    public GroupDetails loadGroupByGroupname(String groupname) {
        throw new UserMayOrMayNotExistException(groupname);
    }
}

