/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.sun.jndi.ldap.LdapCtxFactory;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements UserDetailsService {
    private final String domainName;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());

    public ActiveDirectoryUnixAuthenticationProvider(String domainName) {
        this.domainName = domainName;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException("Active-directory plugin doesn't support user retrieval");
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        DirContext context;
        String password = null;
        if (authentication != null) {
            password = (String)authentication.getCredentials();
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        String principalName = username + '@' + this.domainName;
        props.put("java.naming.security.principal", principalName);
        props.put("java.naming.security.credentials", password);
        try {
            context = LdapCtxFactory.getLdapCtxInstance("ldap://" + ActiveDirectorySecurityRealm.DesciprotrImpl.INSTANCE.obtainLDAPServer(this.domainName) + '/', props);
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to bind to LDAP", e);
            throw new BadCredentialsException("Either no such user '" + username + "' or incorrect password", (Throwable)e);
        }
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> renum = context.search(ActiveDirectoryUnixAuthenticationProvider.toDC(this.domainName), "(& (userPrincipalName=" + principalName + ")(objectClass=user))", controls);
            if (!renum.hasMore()) {
                throw new BadCredentialsException("Authentication was successful but cannot locate the user information for " + username);
            }
            SearchResult result = renum.next();
            ArrayList<GrantedAuthorityImpl> groups = new ArrayList<GrantedAuthorityImpl>();
            Attribute memberOf = result.getAttributes().get("memberOf");
            if (memberOf != null) {
                for (int i = 0; i < memberOf.size(); ++i) {
                    Attributes atts = context.getAttributes(memberOf.get(i).toString(), new String[]{"CN"});
                    Attribute att = atts.get("CN");
                    groups.add(new GrantedAuthorityImpl(att.get().toString()));
                }
            }
            context.close();
            return new ActiveDirectoryUserDetail(username, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve user information", e);
            throw new BadCredentialsException("Authentication was successful but more than one users in the directory matches the user name: " + username, (Throwable)e);
        }
    }

    private static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }
}

