/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import groovy.lang.Binding;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.active_directory.Messages;
import hudson.security.SecurityRealm;
import hudson.util.FormFieldValidator;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.userdetails.UserDetailsService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveDirectorySecurityRealm
extends SecurityRealm {
    public final String domain;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain) {
        this.domain = domain;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("domain", (Object)this.domain);
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("ActiveDirectory.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context));
    }

    public Descriptor<SecurityRealm> getDescriptor() {
        return DesciprotrImpl.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DesciprotrImpl
    extends Descriptor<SecurityRealm> {
        public static final DesciprotrImpl INSTANCE = new DesciprotrImpl();

        public DesciprotrImpl() {
            super(ActiveDirectorySecurityRealm.class);
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/active-directory/help/realm.html";
        }

        public void doDomainCheck(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="value") String value) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                protected void check() throws IOException, ServletException {
                    String serverHostName;
                    DirContext ictx;
                    String name = Util.fixEmptyAndTrim((String)value);
                    if (name == null) {
                        this.ok();
                        return;
                    }
                    if (!name.endsWith(".")) {
                        name = name + '.';
                    }
                    try {
                        LOGGER.fine("Attempting to resolve " + name + " to A record");
                        ictx = DesciprotrImpl.this.createDNSLookupContext();
                        Attributes attributes = ictx.getAttributes(name, new String[]{"A"});
                        Attribute a = attributes.get("A");
                        if (a == null) {
                            throw new NamingException();
                        }
                        LOGGER.fine(name + " resolved to " + a.get());
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.WARNING, "Failed to resolve " + name + " to A record", e);
                        this.error(name + " doesn't look like a valid domain name");
                        return;
                    }
                    String ldapServer = "_ldap._tcp." + name;
                    try {
                        serverHostName = DesciprotrImpl.this.obtainLDAPServer(ictx, name);
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.WARNING, "Failed to resolve " + ldapServer + " to SRV record", e);
                        this.error("No LDAP server was found in " + name);
                        return;
                    }
                    try {
                        new Socket(serverHostName, 389).close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to connect to LDAP port", e);
                        this.error("Failed to connect to the LDAP port (389) of " + serverHostName);
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public DirContext createDNSLookupContext() throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            return new InitialDirContext(env);
        }

        public String obtainLDAPServer(String domainName) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), domainName);
        }

        public String obtainLDAPServer(DirContext ictx, String domainName) throws NamingException {
            String ldapServer = "_ldap._tcp." + domainName;
            LOGGER.fine("Attempting to resolve " + ldapServer + " to SRV record");
            Attributes attributes = ictx.getAttributes(ldapServer, new String[]{"SRV"});
            Attribute a = attributes.get("SRV");
            if (a == null) {
                throw new NamingException();
            }
            LOGGER.fine(ldapServer + " resolved to " + a.get());
            return a.get().toString().split(" ")[3];
        }
    }
}

