/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.collector.AnalysisResultSummary;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.collector.Warning;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AnalysisResult
extends BuildResult {
    private static final long serialVersionUID = 847650789493429154L;
    private final Map<String, Integer> annotationsByOrigin = Maps.newHashMap();

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
        this.countAnnotations();
    }

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, AnalysisResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
        this.countAnnotations();
    }

    private void countAnnotations() {
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!this.annotationsByOrigin.containsKey(annotation.getOrigin())) {
                this.annotationsByOrigin.put(annotation.getOrigin(), 0);
            }
            this.annotationsByOrigin.put(annotation.getOrigin(), (Integer)this.annotationsByOrigin.get(annotation.getOrigin()) + 1);
        }
    }

    protected void configure(XStream xstream) {
        xstream.alias("warning", Warning.class);
    }

    public String getSummary() {
        return AnalysisResultSummary.createSummary((AnalysisResult)this);
    }

    public String getDetails() {
        String message = AnalysisResultSummary.createDeltaMessage((AnalysisResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.Analysis_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = AnalysisResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.Analysis_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.Analysis_ResultAction_MultipleHighScore((Object)days) + "</li>";
        }
        long days = AnalysisResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.Analysis_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.Analysis_ResultAction_MultipleNoHighScore((Object)days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "analysis.xml";
    }

    public String getDisplayName() {
        return Messages.Analysis_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return AnalysisResultAction.class;
    }

    public int getNumberOfAnnotationsByOrigin(String origin) {
        if (this.annotationsByOrigin.containsKey(origin)) {
            return (Integer)this.annotationsByOrigin.get(origin);
        }
        return 0;
    }
}

