/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.AnalysisProjectAction;
import hudson.plugins.analysis.collector.AnalysisResult;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.collector.AnalysisResultBuilder;
import hudson.plugins.analysis.core.AbstractResultAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 5512072640635006098L;

    @DataBoundConstructor
    public AnalysisPublisher(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, "ANALYSIS-COLLECTOR");
    }

    private ArrayList<Class<? extends AbstractResultAction<? extends BuildResult>>> getParticipatingPlugins() {
        ArrayList<Class<? extends AbstractResultAction<? extends BuildResult>>> pluginResults = new ArrayList<Class<? extends AbstractResultAction<? extends BuildResult>>>();
        if (AnalysisDescriptor.isCheckStyleInstalled()) {
            pluginResults.add(CheckStyleResultAction.class);
        }
        if (AnalysisDescriptor.isDryInstalled()) {
            pluginResults.add(DryResultAction.class);
        }
        if (AnalysisDescriptor.isFindBugsInstalled()) {
            pluginResults.add(FindBugsResultAction.class);
        }
        if (AnalysisDescriptor.isPmdInstalled()) {
            pluginResults.add(PmdResultAction.class);
        }
        if (AnalysisDescriptor.isOpenTasksInstalled()) {
            pluginResults.add(TasksResultAction.class);
        }
        if (AnalysisDescriptor.isWarningsInstalled()) {
            pluginResults.add(WarningsResultAction.class);
        }
        return pluginResults;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new AnalysisProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        ParserResult overallResult = new ParserResult();
        for (Class<? extends AbstractResultAction<? extends BuildResult>> result : this.getParticipatingPlugins()) {
            AbstractResultAction action = (AbstractResultAction)build.getAction(result);
            if (action == null) continue;
            BuildResult actualResult = action.getResult();
            Collection annotactualResultations = actualResult.getAnnotations();
            overallResult.addAnnotations(annotactualResultations);
        }
        AnalysisResult result = new AnalysisResultBuilder().build(build, overallResult, this.getDefaultEncoding());
        build.getActions().add(new AnalysisResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return super.getDescriptor();
    }

    protected boolean canContinue(Result result) {
        return true;
    }
}

