/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector.dashboard;

import hudson.model.Job;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.warnings.WarningsProjectAction;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsTablePortlet
extends DashboardPortlet {
    private static final String NO_RESULTS_FOUND = "-";

    @DataBoundConstructor
    public WarningsTablePortlet(String name) {
        super(name);
    }

    public String getCheckStyle(Job<?, ?> job) {
        if (AnalysisDescriptor.isCheckStyleInstalled()) {
            return this.getWarnings(job, CheckStyleProjectAction.class, "checkstyle");
        }
        return NO_RESULTS_FOUND;
    }

    public String getDry(Job<?, ?> job) {
        if (AnalysisDescriptor.isDryInstalled()) {
            return this.getWarnings(job, DryProjectAction.class, "dry");
        }
        return NO_RESULTS_FOUND;
    }

    public String getFindBugs(Job<?, ?> job) {
        if (AnalysisDescriptor.isFindBugsInstalled()) {
            return this.getWarnings(job, FindBugsProjectAction.class, "findbugs");
        }
        return NO_RESULTS_FOUND;
    }

    public String getPmd(Job<?, ?> job) {
        if (AnalysisDescriptor.isPmdInstalled()) {
            return this.getWarnings(job, PmdProjectAction.class, "pmd");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTasks(Job<?, ?> job) {
        if (AnalysisDescriptor.isOpenTasksInstalled()) {
            return this.getWarnings(job, TasksProjectAction.class, "tasks");
        }
        return NO_RESULTS_FOUND;
    }

    public String getWarnings(Job<?, ?> job) {
        if (AnalysisDescriptor.isWarningsInstalled()) {
            return this.getWarnings(job, WarningsProjectAction.class, "warnings");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTotal(Job<?, ?> job) {
        return String.valueOf(this.toInt(this.getCheckStyle(job)) + this.toInt(this.getDry(job)) + this.toInt(this.getFindBugs(job)) + this.toInt(this.getPmd(job)) + this.toInt(this.getTasks(job)) + this.toInt(this.getWarnings(job)));
    }

    private int toInt(String value) {
        try {
            return Integer.parseInt(StringUtils.substringBetween((String)value, (String)">", (String)"<"));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    private String getWarnings(Job<?, ?> job, Class<? extends AbstractProjectAction<?>> actionType, String plugin) {
        AbstractProjectAction action = (AbstractProjectAction)job.getAction(actionType);
        if (action != null && action.hasValidResults()) {
            BuildResult result = action.getLastAction().getResult();
            String value = String.format("<a href=\"%s%s\">%d</a>", job.getShortUrl(), plugin, result.getNumberOfAnnotations());
            if (result.isSuccessfulTouched()) {
                return value + result.getResultIcon();
            }
            return value;
        }
        return NO_RESULTS_FOUND;
    }

    private String getIcon(Job<?, ?> job, Class<? extends AbstractProjectAction<?>> actionType) {
        AbstractProjectAction action = (AbstractProjectAction)job.getAction(actionType);
        if (action != null && action.hasValidResults()) {
            return action.getLastAction().getResult().getResultIcon();
        }
        return "";
    }
}

