/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.collector.AnalysisResultSummary;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisResult
extends BuildResult {
    private static final long serialVersionUID = 847650789493429154L;
    private transient WeakReference<Map<String, Integer>> annotationsByOrigin;
    private transient Object mappingLock = new Object();

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, BuildHistory history) {
        super(build, defaultEncoding, result, history);
        this.annotationsByOrigin = this.newReference(this.countAnnotations());
    }

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
        this.annotationsByOrigin = this.newReference(this.countAnnotations());
    }

    protected Object readResolve() {
        super.readResolve();
        this.mappingLock = new Object();
        return this;
    }

    private Map<String, Integer> countAnnotations() {
        HashMap mapping = Maps.newHashMap();
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!mapping.containsKey(annotation.getOrigin())) {
                mapping.put(annotation.getOrigin(), 0);
            }
            mapping.put(annotation.getOrigin(), (Integer)mapping.get(annotation.getOrigin()) + 1);
        }
        return mapping;
    }

    private WeakReference<Map<String, Integer>> newReference(Map<String, Integer> mapping) {
        return new WeakReference<Map<String, Integer>>(mapping);
    }

    public String getSummary() {
        return AnalysisResultSummary.createSummary(this);
    }

    protected String createDeltaMessage() {
        return AnalysisResultSummary.createDeltaMessage(this);
    }

    protected String getSerializationFileName() {
        return "analysis.xml";
    }

    public String getDisplayName() {
        return Messages.Analysis_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return AnalysisResultAction.class;
    }

    public int getNumberOfAnnotationsByOrigin(String origin) {
        Map<String, Integer> mapping = this.getMapping();
        if (mapping.containsKey(origin)) {
            return mapping.get(origin);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getMapping() {
        Object object = this.mappingLock;
        synchronized (object) {
            if (this.annotationsByOrigin == null || this.annotationsByOrigin.get() == null) {
                Map<String, Integer> mapping = this.countAnnotations();
                this.annotationsByOrigin = this.newReference(mapping);
                return mapping;
            }
            return (Map)this.annotationsByOrigin.get();
        }
    }
}

