/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import hudson.plugins.analysis.collector.AnalysisResult;
import hudson.plugins.analysis.collector.Messages;

public final class AnalysisResultSummary {
    public static String createSummary(AnalysisResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfAnnotations();
        summary.append(Messages.Analysis_ProjectAction_Name());
        summary.append(": ");
        if (bugs > 0) {
            summary.append("<a href=\"analysisResult\">");
        }
        if (bugs == 1) {
            summary.append(Messages.Analysis_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Analysis_ResultAction_MultipleWarnings((Object)bugs));
        }
        if (bugs > 0) {
            summary.append("</a>");
        }
        summary.append(".");
        return summary.toString();
    }

    public static String createDeltaMessage(AnalysisResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"analysisResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Analysis_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Analysis_ResultAction_MultipleNewWarnings((Object)result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"analysisResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Analysis_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Analysis_ResultAction_MultipleFixedWarnings((Object)result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private AnalysisResultSummary() {
    }
}

