/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector.dashboard;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.warnings.WarningsProjectAction;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsTablePortlet
extends DashboardPortlet {
    private static final String NO_RESULTS_FOUND = "-";
    private final boolean useImages;

    @DataBoundConstructor
    public WarningsTablePortlet(String name, boolean useImages) {
        super(name);
        this.useImages = useImages;
    }

    public boolean getUseImages() {
        return this.useImages;
    }

    public boolean useIcons() {
        return this.useImages;
    }

    public boolean isCheckStyleInstalled() {
        return AnalysisDescriptor.isCheckStyleInstalled();
    }

    public boolean isDryInstalled() {
        return AnalysisDescriptor.isDryInstalled();
    }

    public boolean isFindBugsInstalled() {
        return AnalysisDescriptor.isFindBugsInstalled();
    }

    public boolean isPmdInstalled() {
        return AnalysisDescriptor.isPmdInstalled();
    }

    public boolean isTasksInstalled() {
        return AnalysisDescriptor.isOpenTasksInstalled();
    }

    public boolean isWarningsInstalled() {
        return AnalysisDescriptor.isWarningsInstalled();
    }

    public String getCheckStyle(Job<?, ?> job) {
        if (AnalysisDescriptor.isCheckStyleInstalled()) {
            return this.getWarnings(job, CheckStyleProjectAction.class, "checkstyle");
        }
        return NO_RESULTS_FOUND;
    }

    public String getDry(Job<?, ?> job) {
        if (AnalysisDescriptor.isDryInstalled()) {
            return this.getWarnings(job, DryProjectAction.class, "dry");
        }
        return NO_RESULTS_FOUND;
    }

    public String getFindBugs(Job<?, ?> job) {
        if (AnalysisDescriptor.isFindBugsInstalled()) {
            return this.getWarnings(job, FindBugsProjectAction.class, "findbugs");
        }
        return NO_RESULTS_FOUND;
    }

    public String getPmd(Job<?, ?> job) {
        if (AnalysisDescriptor.isPmdInstalled()) {
            return this.getWarnings(job, PmdProjectAction.class, "pmd");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTasks(Job<?, ?> job) {
        if (AnalysisDescriptor.isOpenTasksInstalled()) {
            return this.getWarnings(job, TasksProjectAction.class, "tasks");
        }
        return NO_RESULTS_FOUND;
    }

    public String getWarnings(Job<?, ?> job) {
        if (AnalysisDescriptor.isWarningsInstalled()) {
            return this.getWarnings(job, WarningsProjectAction.class, "warnings");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTotal(Job<?, ?> job) {
        return String.valueOf(this.toInt(this.getCheckStyle(job)) + this.toInt(this.getDry(job)) + this.toInt(this.getFindBugs(job)) + this.toInt(this.getPmd(job)) + this.toInt(this.getTasks(job)) + this.toInt(this.getWarnings(job)));
    }

    public String getCheckStyle(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getCheckStyle(job));
        }
        return String.valueOf(sum);
    }

    public String getDry(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getDry(job));
        }
        return String.valueOf(sum);
    }

    public String getFindBugs(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getFindBugs(job));
        }
        return String.valueOf(sum);
    }

    public String getPmd(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getPmd(job));
        }
        return String.valueOf(sum);
    }

    public String getTasks(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getTasks(job));
        }
        return String.valueOf(sum);
    }

    public String getWarnings(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getWarnings(job));
        }
        return String.valueOf(sum);
    }

    public String getTotal(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += Integer.parseInt(this.getTotal(job));
        }
        return String.valueOf(sum);
    }

    private int toInt(String value) {
        try {
            return Integer.parseInt(StringUtils.substringBetween((String)value, (String)">", (String)"<"));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    private String getWarnings(Job<?, ?> job, Class<? extends AbstractProjectAction<?>> actionType, String plugin) {
        AbstractProjectAction action = (AbstractProjectAction)job.getAction(actionType);
        if (action != null && action.hasValidResults()) {
            BuildResult result = action.getLastAction().getResult();
            int numberOfAnnotations = result.getNumberOfAnnotations();
            String value = numberOfAnnotations > 0 ? String.format("<a href=\"%s%s\">%d</a>", job.getShortUrl(), plugin, numberOfAnnotations) : String.valueOf(numberOfAnnotations);
            if (result.isSuccessfulTouched() && !result.isSuccessful()) {
                return value + result.getResultIcon();
            }
            return value;
        }
        return NO_RESULTS_FOUND;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningsPerJobDescriptor
    extends Descriptor<DashboardPortlet> {
        @Extension
        public static WarningsPerJobDescriptor newInstance() {
            if (Hudson.getInstance().getPlugin("dashboard-view") != null) {
                return new WarningsPerJobDescriptor();
            }
            return null;
        }

        public String getDisplayName() {
            return Messages.Portlet_WarningsTable();
        }
    }
}

