/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.collector.AnalysisResultSummary;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisResult
extends BuildResult {
    private static final long serialVersionUID = 847650789493429154L;
    private final Map<String, Integer> annotationsByOrigin = Maps.newHashMap();

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, BuildHistory history) {
        super(build, defaultEncoding, result, history);
        this.countAnnotations();
    }

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
        this.countAnnotations();
    }

    private void countAnnotations() {
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!this.annotationsByOrigin.containsKey(annotation.getOrigin())) {
                this.annotationsByOrigin.put(annotation.getOrigin(), 0);
            }
            this.annotationsByOrigin.put(annotation.getOrigin(), (Integer)this.annotationsByOrigin.get(annotation.getOrigin()) + 1);
        }
    }

    public String getSummary() {
        return AnalysisResultSummary.createSummary((AnalysisResult)this);
    }

    protected String createDeltaMessage() {
        return AnalysisResultSummary.createDeltaMessage((AnalysisResult)this);
    }

    protected String getSerializationFileName() {
        return "analysis.xml";
    }

    public String getDisplayName() {
        return Messages.Analysis_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return AnalysisResultAction.class;
    }

    public int getNumberOfAnnotationsByOrigin(String origin) {
        if (this.annotationsByOrigin.containsKey(origin)) {
            return (Integer)this.annotationsByOrigin.get(origin);
        }
        return 0;
    }
}

