/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import com.google.common.collect.Lists;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.AnalysisResult;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.util.ColorPalette;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginGraph
extends CategoryBuildResultGraph {
    private static final int HUDSON_GREEN_INDEX = 3;
    private static final Font LEGEND_FONT = new Font("SansSerif", 0, 10);
    private final List<String> originsKeys = Lists.newArrayList();
    private final List<String> originLabels = Lists.newArrayList();
    private static final Color ORANGE = new Color(255, 165, 0);
    private static final Color GRAY = new Color(77, 77, 77);
    private static final Color PINK = new Color(160, 32, 240);

    public OriginGraph() {
        if (AnalysisDescriptor.isCheckStyleInstalled()) {
            this.originsKeys.add("checkstyle");
            this.originLabels.add(Messages.Analysis_Checkstyle_Warning_Origin());
        }
        if (AnalysisDescriptor.isDryInstalled()) {
            this.originsKeys.add("dry");
            this.originLabels.add(Messages.Analysis_Dry_Warning_Origin());
        }
        if (AnalysisDescriptor.isFindBugsInstalled()) {
            this.originsKeys.add("findbugs");
            this.originLabels.add(Messages.Analysis_FindBugs_Warning_Origin());
        }
        if (AnalysisDescriptor.isPmdInstalled()) {
            this.originsKeys.add("pmd");
            this.originLabels.add(Messages.Analysis_PMD_Warning_Origin());
        }
        if (AnalysisDescriptor.isOpenTasksInstalled()) {
            this.originsKeys.add("tasks");
            this.originLabels.add(Messages.Analysis_Tasks_Warning_Origin());
        }
        if (AnalysisDescriptor.isWarningsInstalled()) {
            this.originsKeys.add("warnings");
            this.originLabels.add(Messages.Analysis_Warnings_Warning_Origin());
        }
    }

    public String getId() {
        return "ORIGIN";
    }

    protected String getPlugin() {
        return "analysis-collector";
    }

    public String getLabel() {
        return Messages.Trend_type_analysis();
    }

    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        if (current instanceof AnalysisResult) {
            AnalysisResult result = (AnalysisResult)current;
            for (String origin : this.originsKeys) {
                series.add(result.getNumberOfAnnotationsByOrigin(origin));
            }
        }
        return series;
    }

    protected JFreeChart createChart(CategoryDataset dataSet) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"count", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(chart.getCategoryPlot());
        chart.getCategoryPlot().getDomainAxis().setCategoryMargin(0.0);
        chart.getLegend().setItemFont(LEGEND_FONT);
        return chart;
    }

    protected Color[] getColors() {
        ArrayList colors = Lists.newArrayList((Iterable)ColorPalette.LINE_GRAPH);
        while (colors.size() > 3) {
            colors.remove(3);
        }
        colors.add(ORANGE);
        colors.add(GRAY);
        colors.add(PINK);
        colors.add(ColorPalette.RED);
        colors.add(ColorPalette.YELLOW);
        return colors.toArray(new Color[colors.size()]);
    }

    protected String getRowId(int level) {
        return (String)this.originLabels.get(level);
    }

    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, ToolTipProvider toolTipProvider) {
        LineAndShapeRenderer render = new LineAndShapeRenderer(true, false);
        render.setBaseStroke((Stroke)new BasicStroke(2.0f));
        return render;
    }
}

