/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.test;

import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.test.AbstractEnglishLocaleTest;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import org.apache.commons.lang.SystemUtils;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildResultTest<T extends BuildResult>
extends AbstractEnglishLocaleTest {
    private static final String WRONG_NEW_HIGHSCORE_INDICATOR = "Wrong new highscore indicator.";
    private static final long TWO_DAYS_IN_MS = 172800000L;
    private static final String WRONG_ZERO_WARNINGS_HIGH_SCORE = "Wrong zero warnings high score.";
    private static final String WRONG_ZERO_WARNINGS_SINCE_DATE_COUNTER = "Wrong zero warnings since date counter.";
    private static final String WRONG_ZERO_WARNINGS_SINCE_BUILD_COUNTER = "Wrong zero warnings since build counter.";
    private static final String WRONG_NUMBER_OF_ANNOTATIONS = "Wrong number of annotations.";
    private static final String FILENAME = "filename";

    @Test
    public void checkThatZeroWarningsIsUpdated() {
        GregorianCalendar calendar = new GregorianCalendar(2008, 8, 8, 12, 30);
        long timeOfFirstZeroWarningsBuild = calendar.getTime().getTime();
        T result = this.createBuildResult(this.createBuild(0, calendar), new ParserResult());
        this.verifyResult(0, 0, timeOfFirstZeroWarningsBuild, 0L, true, 0L, result);
        result = this.createResult(1, calendar, this.createResultWithWarnings());
        this.verifyResult(0, 1, timeOfFirstZeroWarningsBuild, 0L, true, 0L, result);
        calendar.add(6, 2);
        result = this.createResult(2, calendar, result);
        this.verifyResult(0, 1, timeOfFirstZeroWarningsBuild, 172800000L, true, 0L, result);
        result = this.createBuildResult(this.createBuild(3, calendar), this.createProjectWithWarning(), result);
        this.verifyResult(1, 0, 0L, 172800000L, false, 172800000L, result);
        calendar.add(6, 1);
        timeOfFirstZeroWarningsBuild = calendar.getTime().getTime();
        result = this.createResult(3, calendar, result);
        this.verifyResult(0, 3, timeOfFirstZeroWarningsBuild, 172800000L, false, 86400000L, result);
        calendar.add(6, 1);
        result = this.createResult(4, calendar, result);
        this.verifyResult(0, 3, timeOfFirstZeroWarningsBuild, 172800000L, false, 0L, result);
        calendar.add(6, 3);
        result = this.createResult(4, calendar, result);
        this.verifyResult(0, 3, timeOfFirstZeroWarningsBuild, 345600000L, true, 0L, result);
        result.getDataFile().delete();
    }

    @Test
    public void checkZeroWarningsCounterInitialization() {
        GregorianCalendar calendar = new GregorianCalendar(2008, 8, 8, 12, 30);
        long timeOfFirstZeroWarningsBuild = calendar.getTime().getTime();
        T result = this.createBuildResult(this.createBuild(0, calendar), new ParserResult());
        this.verifyResult(0, 0, timeOfFirstZeroWarningsBuild, 0L, true, 0L, result);
        calendar.add(6, 2);
        result = this.createBuildResult(this.createBuild(0, calendar), new ParserResult(), result);
        this.verifyResult(0, 0, timeOfFirstZeroWarningsBuild, 172800000L, true, 0L, result);
        result.getDataFile().delete();
    }

    @Test
    public void checkZeroWarningsCounterInitializationStartUnstable() {
        GregorianCalendar calendar = new GregorianCalendar(2008, 8, 8, 12, 30);
        T result = this.createBuildResult(this.createBuild(0, calendar), this.createProjectWithWarning());
        this.verifyResult(1, 0, 0L, 0L, false, 0L, result);
        calendar.add(6, 2);
        long timeOfFirstZeroWarningsBuild = calendar.getTime().getTime();
        result = this.createBuildResult(this.createBuild(1, calendar), new ParserResult(), result);
        this.verifyResult(0, 1, timeOfFirstZeroWarningsBuild, 0L, true, 0L, result);
        calendar.add(6, 2);
        result = this.createBuildResult(this.createBuild(0, calendar), new ParserResult(), result);
        this.verifyResult(0, 1, timeOfFirstZeroWarningsBuild, 172800000L, true, 0L, result);
        result.getDataFile().delete();
    }

    private T createResult(int buildNumner, GregorianCalendar calendar, T previousResult) {
        return this.createBuildResult(this.createBuild(buildNumner, calendar), new ParserResult(), previousResult);
    }

    private T createResultWithWarnings() {
        ParserResult projectWithWarning = this.createProjectWithWarning();
        return this.createBuildResult(this.createBuild(42, new GregorianCalendar(2008, 1, 1, 12, 0)), projectWithWarning);
    }

    private void verifyResult(int expectedAnnotationCount, int expectedZeroWarningsBuildNumber, long expectedZeroWarningsBuildDate, long expectedHighScore, boolean expectedIsNewHighScore, long gap, T result) {
        Assert.assertEquals((String)WRONG_NUMBER_OF_ANNOTATIONS, (int)expectedAnnotationCount, (int)result.getNumberOfAnnotations());
        Assert.assertEquals((String)WRONG_ZERO_WARNINGS_SINCE_BUILD_COUNTER, (int)expectedZeroWarningsBuildNumber, (int)result.getZeroWarningsSinceBuild());
        Assert.assertEquals((String)WRONG_ZERO_WARNINGS_SINCE_DATE_COUNTER, (long)expectedZeroWarningsBuildDate, (long)result.getZeroWarningsSinceDate());
        Assert.assertEquals((String)WRONG_ZERO_WARNINGS_HIGH_SCORE, (long)expectedHighScore, (long)result.getZeroWarningsHighScore());
        Assert.assertEquals((String)WRONG_NEW_HIGHSCORE_INDICATOR, (boolean)expectedIsNewHighScore, (boolean)result.isNewZeroWarningsHighScore());
        this.verifyHighScoreMessage(expectedZeroWarningsBuildNumber, expectedIsNewHighScore, expectedHighScore, gap, result);
    }

    protected abstract void verifyHighScoreMessage(int var1, boolean var2, long var3, long var5, T var7);

    private ParserResult createProjectWithWarning() {
        ParserResult project = new ParserResult();
        FileAnnotation annotation = (FileAnnotation)Mockito.mock(FileAnnotation.class);
        Mockito.when((Object)annotation.getPriority()).thenReturn((Object)Priority.HIGH);
        Mockito.when((Object)annotation.getFileName()).thenReturn((Object)FILENAME);
        Mockito.when((Object)annotation.getModuleName()).thenReturn((Object)"Module");
        Mockito.when((Object)annotation.getPackageName()).thenReturn((Object)"Package");
        project.addAnnotation(annotation);
        return project;
    }

    private AbstractBuild<?, ?> createBuild(int buildNumber, Calendar calendar) {
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getTimestamp()).thenReturn((Object)calendar);
        Mockito.when((Object)build.getRootDir()).thenReturn((Object)SystemUtils.getJavaIoTmpDir());
        Mockito.when((Object)build.getNumber()).thenReturn((Object)buildNumber);
        return build;
    }

    protected abstract T createBuildResult(AbstractBuild<?, ?> var1, ParserResult var2);

    protected abstract T createBuildResult(AbstractBuild<?, ?> var1, ParserResult var2, T var3);
}

