/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.test;

import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.test.AbstractEnglishLocaleTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractHealthDescriptorTest
extends AbstractEnglishLocaleTest {
    @Test
    public void testThresholds() {
        Assert.assertTrue((boolean)this.createHealthDescriptor("0", "", "").isThresholdEnabled());
        Assert.assertTrue((boolean)this.createHealthDescriptor("1", "", "").isThresholdEnabled());
        Assert.assertTrue((boolean)this.createHealthDescriptor("100", "", "").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("-1", "", "").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "", "").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor(null, "", "").isThresholdEnabled());
    }

    @Test
    public void testHealthyThresholds() {
        Assert.assertTrue((boolean)this.createHealthDescriptor("", "0", "1").isHealthyReportEnabled());
        Assert.assertTrue((boolean)this.createHealthDescriptor("", "1", "2").isHealthyReportEnabled());
        Assert.assertTrue((boolean)this.createHealthDescriptor("", "10", "20").isHealthyReportEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "0", "0").isHealthyReportEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "1", "1").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "2", "1").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "2", "").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", "", "2").isThresholdEnabled());
        Assert.assertFalse((boolean)this.createHealthDescriptor("", null, "2").isThresholdEnabled());
    }

    @Test
    public void testConversionOfThresholds() {
        Assert.assertEquals((long)0L, (long)this.createHealthDescriptor("0", "", "").getMinimumAnnotations());
        Assert.assertEquals((long)1L, (long)this.createHealthDescriptor("1", "", "").getMinimumAnnotations());
        Assert.assertEquals((long)100L, (long)this.createHealthDescriptor("100", "", "").getMinimumAnnotations());
    }

    @Test
    public void testConversionOfHealthiness() {
        Assert.assertEquals((long)1L, (long)this.createHealthDescriptor("0", "1", "2").getHealthyAnnotations());
        Assert.assertEquals((long)2L, (long)this.createHealthDescriptor("0", "1", "2").getUnHealthyAnnotations());
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyContractOfHealthy() {
        this.createHealthDescriptor("0", "-1", "0").getHealthyAnnotations();
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyContractOfUnHealthy() {
        this.createHealthDescriptor("0", "0", "-1").getUnHealthyAnnotations();
    }

    private AbstractHealthDescriptor createHealthDescriptor(String threshold, String healthy, String unHealthy) {
        HealthDescriptor healthDescriptor = (HealthDescriptor)Mockito.mock(HealthDescriptor.class);
        Mockito.when((Object)healthDescriptor.getThreshold()).thenReturn((Object)threshold);
        Mockito.when((Object)healthDescriptor.getHealthy()).thenReturn((Object)healthy);
        Mockito.when((Object)healthDescriptor.getUnHealthy()).thenReturn((Object)unHealthy);
        return this.createHealthDescriptor(healthDescriptor);
    }

    protected abstract AbstractHealthDescriptor createHealthDescriptor(HealthDescriptor var1);
}

