/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.AndroidPlatform;
import hudson.plugins.android_emulator.Constants;
import hudson.plugins.android_emulator.EmulatorConfig;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.ScreenDensity;
import hudson.plugins.android_emulator.ScreenResolution;
import hudson.plugins.android_emulator.ValidationResult;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.hudson.plugins.port_allocator.PortAllocationManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidEmulator
extends BuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ADB_CONNECT_TIMEOUT_MS = 60000;
    private static final int BOOT_COMPLETE_TIMEOUT_MS = 120000;
    private DescriptorImpl descriptor;
    private final transient boolean useNamedEmulator;
    private final String avdName;
    private final String osVersion;
    private final String screenDensity;
    private final String screenResolution;
    private final String deviceLocale;

    @DataBoundConstructor
    public AndroidEmulator(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        this.avdName = avdName;
        this.osVersion = osVersion;
        this.screenDensity = screenDensity;
        this.screenResolution = screenResolution;
        this.deviceLocale = deviceLocale;
        this.useNamedEmulator = avdName != null;
    }

    public boolean getUseNamedEmulator() {
        return this.useNamedEmulator;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        return this.deviceLocale;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (this.descriptor == null) {
            this.descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        }
        EnvVars localVars = Computer.currentComputer().getEnvironment();
        EnvVars envVars = new EnvVars(localVars);
        envVars.putAll((Map)build.getEnvironment((TaskListener)listener));
        Map buildVars = build.getBuildVariables();
        String avdName = this.expandVariables(envVars, buildVars, this.avdName);
        String osVersion = this.expandVariables(envVars, buildVars, this.osVersion);
        String screenDensity = this.expandVariables(envVars, buildVars, this.screenDensity);
        String screenResolution = this.expandVariables(envVars, buildVars, this.screenResolution);
        String deviceLocale = this.expandVariables(envVars, buildVars, this.deviceLocale);
        String androidHome = this.expandVariables(envVars, buildVars, this.descriptor.androidHome);
        androidHome = this.validateAndroidHome(launcher, localVars, androidHome);
        String configError = this.isConfigValid(avdName, osVersion, screenDensity, screenResolution, deviceLocale);
        if (configError != null) {
            this.log(logger, Messages.ERROR_MISCONFIGURED(configError));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        if (!this.validateAndroidToolsInPath(launcher, androidHome)) {
            this.log(logger, Messages.SDK_TOOLS_NOT_FOUND());
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        String displayHome = androidHome == null ? Messages.USING_PATH() : androidHome;
        this.log(logger, Messages.USING_SDK(displayHome));
        EmulatorConfig emuConfig = EmulatorConfig.create(avdName, osVersion, screenDensity, screenResolution, deviceLocale);
        return this.doSetUp(build, launcher, logger, androidHome, emuConfig);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild<?, ?> build, Launcher launcher, final PrintStream logger, String androidHome, final EmulatorConfig emuConfig) throws IOException, InterruptedException {
        boolean bootSucceeded;
        boolean emulatorAlreadyExists;
        Computer computer = Computer.currentComputer();
        EnvVars environment = computer.getEnvironment();
        try {
            Callable<Boolean, IOException> task = emuConfig.getEmulatorCreationTask(androidHome);
            emulatorAlreadyExists = (Boolean)launcher.getChannel().call(task);
        }
        catch (FileNotFoundException ex) {
            this.log(logger, Messages.CANNOT_START_EMULATOR(ex.getMessage()));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        final PortAllocationManager portAllocator = PortAllocationManager.getManager((Computer)computer);
        final int userPort = portAllocator.allocateRandom(build, 0);
        final int adbPort = portAllocator.allocateRandom(build, 0);
        String avdArgs = emuConfig.getCommandArguments();
        String emulatorArgs = String.format("-ports %s,%s %s", userPort, adbPort, avdArgs);
        ArgumentListBuilder emulatorCmd = this.getToolCommand(launcher, androidHome, "emulator", "emulator.exe", emulatorArgs);
        this.log(logger, Messages.STARTING_EMULATOR());
        long bootTime = System.currentTimeMillis();
        Launcher.ProcStarter procStarter = launcher.launch().stdout((OutputStream)logger).stderr((OutputStream)logger);
        final Proc emulatorProcess = procStarter.envs((Map)environment).cmds(emulatorCmd).start();
        boolean socket = this.waitForSocket(launcher, adbPort, 60000);
        if (!socket || !emulatorProcess.isAlive()) {
            this.log(logger, Messages.EMULATOR_DID_NOT_START());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        String adbConnectArgs = "connect localhost:" + adbPort;
        ArgumentListBuilder adbConnectCmd = this.getToolCommand(launcher, androidHome, "adb", "adb.exe", adbConnectArgs);
        int result = procStarter.cmds(adbConnectCmd).stdout((OutputStream)new NullOutputStream()).start().join();
        if (result != 0) {
            this.log(logger, Messages.CANNOT_CONNECT_TO_EMULATOR());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        final File artifactsDir = build.getArtifactsDir();
        final FilePath logcatFile = build.getWorkspace().createTempFile("logcat_", ".log");
        final OutputStream logcatStream = logcatFile.write();
        String logcatArgs = "-s localhost:" + adbPort + " logcat -v time";
        ArgumentListBuilder logcatCmd = this.getToolCommand(launcher, androidHome, "adb", "adb.exe", logcatArgs);
        final Proc logWriter = procStarter.cmds(logcatCmd).stdout(logcatStream).stderr((OutputStream)new NullOutputStream()).start();
        this.log(logger, Messages.WAITING_FOR_BOOT_COMPLETION());
        int bootTimeout = 120000;
        if (!emulatorAlreadyExists) {
            bootTimeout *= 4;
        }
        if (!(bootSucceeded = this.waitForBootCompletion(logger, launcher, androidHome, adbPort, bootTimeout))) {
            this.log(logger, Messages.BOOT_COMPLETION_TIMED_OUT(bootTimeout / 1000));
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
            return null;
        }
        long bootCompleteTime = System.currentTimeMillis();
        this.log(logger, Messages.EMULATOR_IS_READY((bootCompleteTime - bootTime) / 1000L));
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("ANDROID_AVD_NAME", emuConfig.getAvdName());
                if (!emuConfig.isNamedEmulator()) {
                    env.put("ANDROID_AVD_OS", emuConfig.getOsVersion().toString());
                    env.put("ANDROID_AVD_DENSITY", emuConfig.getScreenDensity().toString());
                    env.put("ANDROID_AVD_RESOLUTION", emuConfig.getScreenResolution().toString());
                    env.put("ANDROID_AVD_LOCALE", emuConfig.getDeviceLocale());
                }
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                AndroidEmulator.this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
                return true;
            }
        };
    }

    private synchronized void log(PrintStream logger, String message) {
        logger.print("[android] ");
        logger.println(message);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort) throws IOException, InterruptedException {
        this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort, null, null, null, null);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort, Proc logcatProcess, FilePath logcatFile, OutputStream logcatStream, File artifactsDir) throws IOException, InterruptedException {
        this.log(logger, Messages.STOPPING_EMULATOR());
        emulatorProcess.kill();
        portAllocator.free(adbPort);
        portAllocator.free(userPort);
        if (logcatProcess != null) {
            logcatProcess.kill();
            logcatStream.close();
            if (logcatFile.length() != 0L) {
                this.log(logger, Messages.ARCHIVING_LOG());
                logcatFile.copyTo(new FilePath(artifactsDir).child("logcat.txt"));
            }
            logcatFile.delete();
        }
    }

    private String expandVariables(EnvVars envVars, Map<String, String> buildVars, String token) {
        String result = Util.fixEmptyAndTrim((String)token);
        if (result != null) {
            result = Util.replaceMacro((String)Util.replaceMacro((String)result, (Map)envVars), buildVars);
        }
        return result;
    }

    private String isConfigValid(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        if (this.getUseNamedEmulator()) {
            ValidationResult result = this.descriptor.doCheckAvdName(avdName, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        } else {
            ValidationResult result = this.descriptor.doCheckOsVersion(osVersion, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckScreenDensity(screenDensity, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckScreenResolution(screenResolution, null, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckDeviceLocale(deviceLocale, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        }
        return null;
    }

    private String validateAndroidHome(Launcher launcher, final EnvVars envVars, final String androidHome) {
        Callable<String, InterruptedException> task = new Callable<String, InterruptedException>(){
            private static final long serialVersionUID = 1L;

            public String call() throws InterruptedException {
                String[] keys;
                if (this.validateHomeDir(androidHome)) {
                    return androidHome;
                }
                for (String key : keys = new String[]{"ANDROID_SDK_ROOT", "ANDROID_SDK_HOME", "ANDROID_HOME", "ANDROID_SDK"}) {
                    String home = (String)envVars.get((Object)key);
                    if (!this.validateHomeDir(home)) continue;
                    return home;
                }
                return androidHome;
            }

            private boolean validateHomeDir(String dir) {
                if (Util.fixEmptyAndTrim((String)dir) == null) {
                    return false;
                }
                return !AndroidEmulator.this.descriptor.doCheckAndroidHome(new File(dir), false).isFatal();
            }
        };
        String result = androidHome;
        try {
            result = (String)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private boolean validateAndroidToolsInPath(Launcher launcher, final String androidHome) {
        final String executable = "tools/" + (launcher.isUnix() ? "adb" : "adb.exe");
        Callable<Boolean, IOException> task = new Callable<Boolean, IOException>(){
            private static final long serialVersionUID = 1L;

            public Boolean call() throws IOException {
                String sep = System.getProperty("path.separator");
                List<String> list = Arrays.asList(System.getenv("PATH").split(sep));
                ArrayList<String> paths = new ArrayList<String>(list);
                paths.add(0, androidHome);
                for (String path : paths) {
                    if (!new File(path, executable).exists()) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return false;
    }

    private String getAndroidToolsDirectory(String androidHome) {
        String androidToolsDir = androidHome == null ? "" : androidHome + "/tools/";
        return androidToolsDir;
    }

    private ArgumentListBuilder getToolCommand(Launcher launcher, String androidHome, String unixCmd, String windowsCmd, String args) {
        String androidToolsDir = this.getAndroidToolsDirectory(androidHome);
        String executable = launcher.isUnix() ? unixCmd : windowsCmd;
        ArgumentListBuilder builder = new ArgumentListBuilder(new String[]{androidToolsDir + executable});
        if (args != null) {
            builder.add(Util.tokenize((String)args));
        }
        return builder;
    }

    private boolean waitForSocket(Launcher launcher, int port, int timeout) {
        try {
            LocalPortOpenTask task = new LocalPortOpenTask(port, timeout);
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException ex) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForBootCompletion(PrintStream logger, Launcher launcher, String androidHome, int port, int timeout) {
        long start = System.currentTimeMillis();
        int sleep = timeout / (int)Math.sqrt(timeout / 1000);
        String serialNo = "localhost:" + port;
        String args = "-s " + serialNo + " shell getprop dev.bootcomplete";
        ArgumentListBuilder cmd = this.getToolCommand(launcher, androidHome, "adb", "adb.exe", args);
        try {
            while (System.currentTimeMillis() < start + (long)timeout) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
                launcher.launch().cmds(cmd).stdout((OutputStream)stream).start().join();
                String result = stream.toString().trim();
                if (result.equals("1")) {
                    return true;
                }
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedException ex) {
            this.log(logger, Messages.INTERRUPTED_DURING_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        catch (IOException ex) {
            this.log(logger, Messages.COULD_NOT_CHECK_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        return false;
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalPortOpenTask
    implements Callable<Boolean, InterruptedException> {
        private static final long serialVersionUID = 1L;
        private final int port;
        private final int timeout;

        public LocalPortOpenTask(int port, int timeout) {
            this.port = port;
            this.timeout = timeout;
        }

        public Boolean call() throws InterruptedException {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + (long)this.timeout) {
                try {
                    Socket socket = new Socket("127.0.0.1", this.port);
                    socket.getOutputStream();
                    socket.close();
                    return true;
                }
                catch (IOException iOException) {
                    Thread.sleep(1000L);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=-100.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String VARIABLE_REGEX = "\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
        public String androidHome;

        public DescriptorImpl() {
            super(AndroidEmulator.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.JOB_DESCRIPTION();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "android-emulator.");
            this.save();
            return true;
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String avdName = null;
            String osVersion = null;
            String screenDensity = null;
            String screenResolution = null;
            String deviceLocale = null;
            JSONObject config = formData.getJSONObject("useNamed");
            String useNamedValue = config.getString("value");
            if (Boolean.parseBoolean(useNamedValue)) {
                avdName = config.getString("avdName");
            } else {
                osVersion = config.getString("osVersion");
                screenDensity = config.getString("screenDensity");
                screenResolution = config.getString("screenResolution");
                deviceLocale = config.getString("deviceLocale");
            }
            return new AndroidEmulator(avdName, osVersion, screenDensity, screenResolution, deviceLocale);
        }

        public String getHelpFile() {
            return "/plugin/android-emulator/help-buildConfig.html";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public AndroidPlatform[] getAndroidVersions() {
            return AndroidPlatform.PRESETS;
        }

        public ScreenDensity[] getDeviceDensities() {
            return ScreenDensity.PRESETS;
        }

        public ScreenResolution[] getDeviceResolutions() {
            return ScreenResolution.PRESETS;
        }

        public String[] getEmulatorLocales() {
            return Constants.EMULATOR_LOCALES;
        }

        public FormValidation doCheckAvdName(@QueryParameter String value) {
            return this.doCheckAvdName(value, true).getFormValidation();
        }

        private ValidationResult doCheckAvdName(String avdName, boolean allowVariables) {
            if (avdName == null || avdName.equals("")) {
                return ValidationResult.error(Messages.AVD_NAME_REQUIRED());
            }
            String regex = "[a-zA-Z0-9._-]+";
            if (allowVariables) {
                regex = "(([a-zA-Z0-9._-]+)*(\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$))*)+";
            }
            if (!avdName.matches(regex)) {
                return ValidationResult.error(Messages.INVALID_AVD_NAME());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckOsVersion(@QueryParameter String value) {
            return this.doCheckOsVersion(value, true).getFormValidation();
        }

        private ValidationResult doCheckOsVersion(String osVersion, boolean allowVariables) {
            if (osVersion == null || osVersion.equals("")) {
                return ValidationResult.error(Messages.OS_VERSION_REQUIRED());
            }
            if (!allowVariables && osVersion.matches(VARIABLE_REGEX)) {
                return ValidationResult.error(Messages.INVALID_OS_VERSION());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckScreenDensity(@QueryParameter String value) {
            return this.doCheckScreenDensity(value, true).getFormValidation();
        }

        private ValidationResult doCheckScreenDensity(String density, boolean allowVariables) {
            if (density == null || density.equals("")) {
                return ValidationResult.error(Messages.SCREEN_DENSITY_REQUIRED());
            }
            String regex = "[0-9]{2,4}|[hlm]dpi";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!density.matches(regex)) {
                return ValidationResult.error(Messages.SCREEN_DENSITY_NOT_NUMERIC());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckScreenResolution(@QueryParameter String value, @QueryParameter String density) {
            return this.doCheckScreenResolution(value, density, true).getFormValidation();
        }

        private ValidationResult doCheckScreenResolution(String resolution, String density, boolean allowVariables) {
            if (resolution == null || resolution.equals("")) {
                return ValidationResult.error(Messages.SCREEN_RESOLUTION_REQUIRED());
            }
            String regex = "F?[HQW]{1,2}VGA|[0-9]{3,4}x[0-9]{3,4}";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!resolution.matches(regex)) {
                return ValidationResult.error(Messages.INVALID_RESOLUTION_FORMAT());
            }
            ScreenResolution resolutionValue = ScreenResolution.valueOf(resolution);
            ScreenDensity densityValue = ScreenDensity.valueOf(density);
            if (resolutionValue != null && densityValue != null && !resolutionValue.isCustomResolution() && !densityValue.isCustomDensity()) {
                boolean densityFound = false;
                for (ScreenDensity okDensity : resolutionValue.getApplicableDensities()) {
                    if (!okDensity.equals(densityValue)) continue;
                    densityFound = true;
                    break;
                }
                if (!densityFound) {
                    return ValidationResult.warning(Messages.SUSPECT_RESOLUTION(resolution, densityValue));
                }
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckDeviceLocale(@QueryParameter String value) {
            return this.doCheckDeviceLocale(value, true).getFormValidation();
        }

        private ValidationResult doCheckDeviceLocale(String locale, boolean allowVariables) {
            if (locale == null || locale.equals("")) {
                return ValidationResult.warning(Messages.DEFAULT_LOCALE_WARNING("en_US"));
            }
            String regex = "[a-z]{2}_[A-Z]{2}";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!locale.matches(regex)) {
                return ValidationResult.error(Messages.LOCALE_FORMAT_WARNING());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckAndroidHome(@QueryParameter File value) {
            return this.doCheckAndroidHome(value, true).getFormValidation();
        }

        private ValidationResult doCheckAndroidHome(File sdkRoot, boolean fromWebConfig) {
            String[] requiredTools;
            if (fromWebConfig && !Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return ValidationResult.ok();
            }
            if (sdkRoot == null || sdkRoot.getPath().equals("")) {
                return ValidationResult.ok();
            }
            if (!sdkRoot.isDirectory()) {
                if (fromWebConfig && sdkRoot.getPath().matches(".*(\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)).*")) {
                    return ValidationResult.ok();
                }
                return ValidationResult.error(Messages.INVALID_DIRECTORY());
            }
            for (String dirName : new String[]{"tools", "platforms"}) {
                File dir = new File(sdkRoot, dirName);
                if (dir.exists() && dir.isDirectory()) continue;
                return ValidationResult.error(Messages.INVALID_SDK_DIRECTORY());
            }
            int toolsFound = 0;
            block1: for (String toolName : requiredTools = new String[]{"adb", "android", "emulator"}) {
                for (String extension : new String[]{"", ".bat", ".exe"}) {
                    File tool = new File(sdkRoot, "tools/" + toolName + extension);
                    if (!tool.exists() || !tool.isFile()) continue;
                    ++toolsFound;
                    continue block1;
                }
            }
            if (toolsFound != requiredTools.length) {
                return ValidationResult.errorWithMarkup(Messages.REQUIRED_SDK_TOOLS_NOT_FOUND());
            }
            File platformsDir = new File(sdkRoot, "platforms");
            if (platformsDir.list().length == 0) {
                return ValidationResult.warning(Messages.SDK_PLATFORMS_EMPTY());
            }
            return ValidationResult.ok();
        }
    }
}

