/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.Util;
import hudson.plugins.android_emulator.ScreenDensity;
import java.io.Serializable;

class ScreenResolution
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final ScreenResolution QVGA = new ScreenResolution(240, 320, "QVGA", ScreenDensity.LOW);
    static final ScreenResolution WQVGA = new ScreenResolution(240, 400, "WQVGA", ScreenDensity.LOW);
    static final ScreenResolution FWQVGA = new ScreenResolution(240, 432, "FWQVGA", ScreenDensity.LOW);
    static final ScreenResolution HVGA = new ScreenResolution(320, 480, "HVGA", ScreenDensity.MEDIUM);
    static final ScreenResolution WVGA = new ScreenResolution(480, 800, "WVGA", ScreenDensity.MEDIUM, ScreenDensity.HIGH);
    static final ScreenResolution FWVGA = new ScreenResolution(480, 854, "FWVGA", ScreenDensity.MEDIUM, ScreenDensity.HIGH);
    static final ScreenResolution[] PRESETS = new ScreenResolution[]{QVGA, WQVGA, FWQVGA, HVGA, WVGA, FWVGA};
    private final int width;
    private final int height;
    private final String alias;
    private final ScreenDensity[] densities;

    private ScreenResolution(int width, int height, String alias, ScreenDensity ... applicableDensities) {
        this.width = width;
        this.height = height;
        this.alias = alias;
        this.densities = applicableDensities;
    }

    private ScreenResolution(int width, int height) {
        this(width, height, null, null);
    }

    public static ScreenResolution valueOf(String resolution) {
        if (Util.fixEmptyAndTrim((String)resolution) == null) {
            return null;
        }
        for (ScreenResolution preset : PRESETS) {
            if (!resolution.equals(preset.alias)) continue;
            return preset;
        }
        if (!resolution.matches("[0-9]{3,4}x[0-9]{3,4}")) {
            return null;
        }
        int index = resolution.indexOf(120);
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(resolution.substring(0, index));
            height = Integer.parseInt(resolution.substring(index + 1));
        }
        catch (NumberFormatException ex) {
            return null;
        }
        for (ScreenResolution preset : PRESETS) {
            if (width != preset.width || height != preset.height) continue;
            return preset;
        }
        return new ScreenResolution(width, height);
    }

    public boolean isCustomResolution() {
        return this.alias == null;
    }

    public ScreenDensity[] getApplicableDensities() {
        return this.densities;
    }

    public String toString() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.width + "x" + this.height;
    }
}

