/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.android_emulator.AndroidPlatform;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.ScreenDensity;
import hudson.plugins.android_emulator.ScreenResolution;
import hudson.remoting.Callable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmulatorConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String avdName;
    private AndroidPlatform osVersion;
    private ScreenDensity screenDensity;
    private ScreenResolution screenResolution;
    private String deviceLocale;

    public EmulatorConfig(String avdName) {
        this.avdName = avdName;
    }

    public EmulatorConfig(String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        this.osVersion = AndroidPlatform.valueOf(osVersion);
        this.screenDensity = ScreenDensity.valueOf(screenDensity);
        this.screenResolution = ScreenResolution.valueOf(screenResolution);
        this.deviceLocale = deviceLocale;
    }

    public static final EmulatorConfig create(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        if (Util.fixEmptyAndTrim((String)avdName) == null) {
            return new EmulatorConfig(osVersion, screenDensity, screenResolution, deviceLocale);
        }
        return new EmulatorConfig(avdName);
    }

    public boolean isNamedEmulator() {
        return this.avdName != null && this.osVersion == null;
    }

    public String getAvdName() {
        if (this.isNamedEmulator()) {
            return this.avdName;
        }
        return this.getGeneratedAvdName();
    }

    private String getGeneratedAvdName() {
        String locale = this.getDeviceLocale().replace('_', '-');
        String density = this.screenDensity.toString();
        String resolution = this.screenResolution.toString();
        String platform = this.osVersion.getTargetName();
        return String.format("hudson_%s_%s_%s_%s", locale, density, resolution, platform);
    }

    public AndroidPlatform getOsVersion() {
        return this.osVersion;
    }

    public ScreenDensity getScreenDensity() {
        return this.screenDensity;
    }

    public ScreenResolution getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        if (this.deviceLocale == null) {
            return "en_US";
        }
        return this.deviceLocale;
    }

    public String getDeviceLanguage() {
        return this.getDeviceLocale().substring(0, 2);
    }

    public String getDeviceCountry() {
        return this.getDeviceLocale().substring(3);
    }

    public Callable<Boolean, IOException> getEmulatorCreationTask(String androidHome) {
        return new EmulatorCreationTask(androidHome);
    }

    private File getAvdHome(File homeDir) {
        return new File(homeDir, ".android/avd/");
    }

    private File getAvdDirectory(File homeDir) {
        return new File(this.getAvdHome(homeDir), this.getAvdName() + ".avd");
    }

    private void writeAvdMetadataFile(File homeDir) throws FileNotFoundException {
        File configFile = new File(this.getAvdHome(homeDir), this.getAvdName() + ".ini");
        PrintWriter out = new PrintWriter(configFile);
        out.print("target=");
        out.println(this.osVersion.getTargetName());
        out.print("path=");
        out.println(this.getAvdDirectory(homeDir).toString());
        out.flush();
        out.close();
    }

    private void writeAvdConfigFile(File homeDir, String targetName) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        sb.append("image.sysdir.1=");
        sb.append("platforms/");
        sb.append(targetName);
        sb.append("/images/");
        sb.append("\r\n");
        sb.append("sdcard.size=");
        sb.append("16M\r\n");
        sb.append("skin.name=");
        sb.append(this.screenResolution.getSkinName());
        sb.append("\r\n");
        sb.append("skin.path=");
        if (!this.screenResolution.isCustomResolution()) {
            sb.append("platforms/");
            sb.append(targetName);
            sb.append("/skins/");
        }
        sb.append(this.screenResolution.getSkinName());
        sb.append("\r\n");
        sb.append("hw.lcd.density=");
        sb.append(this.screenDensity.getDpi());
        sb.append("\r\n");
        File configFile = new File(this.getAvdDirectory(homeDir), "config.ini");
        PrintWriter out = new PrintWriter(configFile);
        out.print(sb.toString());
        out.flush();
        out.close();
    }

    public String getCommandArguments() {
        StringBuilder sb = new StringBuilder("-no-boot-anim");
        if (!this.isNamedEmulator()) {
            sb.append(" -prop persist.sys.language=");
            sb.append(this.getDeviceLanguage());
            sb.append(" -prop persist.sys.country=");
            sb.append(this.getDeviceCountry());
        }
        sb.append(" -avd ");
        sb.append(this.getAvdName());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EmulatorCreationTask
    implements Callable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String androidHome;

        public EmulatorCreationTask(String androidHome) {
            this.androidHome = androidHome;
        }

        public Boolean call() throws IOException {
            File homeDir = new File(System.getProperty("user.home"));
            File avdDirectory = EmulatorConfig.this.getAvdDirectory(homeDir);
            if (avdDirectory.exists()) {
                return true;
            }
            if (EmulatorConfig.this.isNamedEmulator()) {
                throw new FileNotFoundException(Messages.AVD_DOES_NOT_EXIST(EmulatorConfig.this.avdName));
            }
            if (this.androidHome == null) {
                throw new FileNotFoundException(Messages.SDK_NOT_SPECIFIED());
            }
            File sdkRoot = new File(this.androidHome);
            if (!sdkRoot.exists()) {
                throw new FileNotFoundException(Messages.SDK_NOT_FOUND(this.androidHome));
            }
            File platformsRoot = new File(sdkRoot, "platforms");
            String targetName = null;
            for (String target : new String[]{EmulatorConfig.this.osVersion.getTargetName(), EmulatorConfig.this.osVersion.getOldTargetName()}) {
                File tmp = new File(platformsRoot, target);
                System.out.println("");
                if (!tmp.exists()) continue;
                targetName = target;
                break;
            }
            if (targetName == null) {
                throw new FileNotFoundException(Messages.PLATFORM_NOT_FOUND(EmulatorConfig.this.osVersion.getTargetName()));
            }
            avdDirectory.mkdirs();
            File platformImage = new File(platformsRoot, targetName + "/images/userdata.img");
            if (!platformImage.exists()) {
                throw new FileNotFoundException(Messages.PLATFORM_IMAGE_NOT_FOUND(platformImage.toString()));
            }
            try {
                new FilePath(platformImage).copyTo(new FilePath(avdDirectory).child("userdata.img"));
            }
            catch (InterruptedException e) {
                try {
                    new FilePath(avdDirectory).deleteRecursive();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                e.printStackTrace();
                throw new IOException(Messages.AVD_CREATION_INTERRUPTED());
            }
            EmulatorConfig.this.writeAvdMetadataFile(homeDir);
            EmulatorConfig.this.writeAvdConfigFile(homeDir, targetName);
            return false;
        }
    }
}

