/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.Util;
import java.io.Serializable;

class ScreenDensity
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final ScreenDensity LOW = new ScreenDensity(120, "ldpi");
    static final ScreenDensity MEDIUM = new ScreenDensity(160, "mdpi");
    static final ScreenDensity HIGH = new ScreenDensity(240, "hdpi");
    static final ScreenDensity[] PRESETS = new ScreenDensity[]{LOW, MEDIUM, HIGH};
    private final int dpi;
    private final String alias;

    private ScreenDensity(int dpi, String alias) {
        this.dpi = dpi;
        this.alias = alias;
    }

    private ScreenDensity(String density) {
        this(Integer.parseInt(density), null);
    }

    public static ScreenDensity valueOf(String density) {
        if (Util.fixEmptyAndTrim((String)density) == null) {
            return null;
        }
        for (ScreenDensity preset : PRESETS) {
            if (!density.equals(preset.alias) && !density.equals(preset.toString())) continue;
            return preset;
        }
        try {
            Integer.parseInt(density);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new ScreenDensity(density);
    }

    public boolean isCustomDensity() {
        return this.alias == null;
    }

    public int getDpi() {
        return this.dpi;
    }

    public String toString() {
        return new Integer(this.dpi).toString();
    }
}

