/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.AndroidEmulator;
import hudson.plugins.android_emulator.EmulatorConfig;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.Utils;
import hudson.plugins.android_emulator.ValidationResult;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.hudson.plugins.port_allocator.PortAllocationManager;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AndroidEmulator
extends BuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ADB_CONNECT_TIMEOUT_MS = 60000;
    private static final int BOOT_COMPLETE_TIMEOUT_MS = 120000;
    private DescriptorImpl descriptor;
    private final String avdName;
    private final String osVersion;
    private final String screenDensity;
    private final String screenResolution;
    private final String deviceLocale;

    @DataBoundConstructor
    public AndroidEmulator(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        this.avdName = avdName;
        this.osVersion = osVersion;
        this.screenDensity = screenDensity;
        this.screenResolution = screenResolution;
        this.deviceLocale = deviceLocale;
    }

    public boolean getUseNamedEmulator() {
        return this.avdName != null;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        return this.deviceLocale;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (this.descriptor == null) {
            this.descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        }
        EnvVars localVars = Computer.currentComputer().getEnvironment();
        EnvVars envVars = new EnvVars(localVars);
        envVars.putAll((Map)build.getEnvironment((TaskListener)listener));
        Map buildVars = build.getBuildVariables();
        String avdName = this.expandVariables(envVars, buildVars, this.avdName);
        String osVersion = this.expandVariables(envVars, buildVars, this.osVersion);
        String screenDensity = this.expandVariables(envVars, buildVars, this.screenDensity);
        String screenResolution = this.expandVariables(envVars, buildVars, this.screenResolution);
        String deviceLocale = this.expandVariables(envVars, buildVars, this.deviceLocale);
        String androidHome = this.expandVariables(envVars, buildVars, this.descriptor.androidHome);
        androidHome = this.validateAndroidHome(launcher, localVars, androidHome);
        String configError = this.isConfigValid(avdName, osVersion, screenDensity, screenResolution, deviceLocale);
        if (configError != null) {
            this.log(logger, Messages.ERROR_MISCONFIGURED((Object)configError));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        if (!this.validateAndroidToolsInPath(launcher, androidHome)) {
            this.log(logger, Messages.SDK_TOOLS_NOT_FOUND());
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        String displayHome = androidHome == null ? Messages.USING_PATH() : androidHome;
        this.log(logger, Messages.USING_SDK((Object)displayHome));
        EmulatorConfig emuConfig = EmulatorConfig.create((String)avdName, (String)osVersion, (String)screenDensity, (String)screenResolution, (String)deviceLocale);
        return this.doSetUp(build, launcher, logger, androidHome, emuConfig);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild<?, ?> build, Launcher launcher, PrintStream logger, String androidHome, EmulatorConfig emuConfig) throws IOException, InterruptedException {
        boolean bootSucceeded;
        boolean emulatorAlreadyExists;
        Computer computer = Computer.currentComputer();
        try {
            Callable task = emuConfig.getEmulatorCreationTask(androidHome, launcher.isUnix());
            emulatorAlreadyExists = (Boolean)launcher.getChannel().call(task);
        }
        catch (FileNotFoundException ex) {
            this.log(logger, Messages.CANNOT_START_EMULATOR((Object)ex.getMessage()));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        PortAllocationManager portAllocator = PortAllocationManager.getManager((Computer)computer);
        int userPort = portAllocator.allocateRandom(build, 0);
        int adbPort = portAllocator.allocateRandom(build, 0);
        String avdArgs = emuConfig.getCommandArguments();
        String emulatorArgs = String.format("-ports %s,%s %s", userPort, adbPort, avdArgs);
        ArgumentListBuilder emulatorCmd = Utils.getToolCommand((Launcher)launcher, (String)androidHome, (String)"emulator", (String)"emulator.exe", (String)emulatorArgs);
        this.log(logger, Messages.STARTING_EMULATOR());
        long bootTime = System.currentTimeMillis();
        EnvVars buildEnvironment = build.getEnvironment(TaskListener.NULL);
        Launcher.ProcStarter procStarter = launcher.launch().stdout((OutputStream)logger).stderr((OutputStream)logger);
        Proc emulatorProcess = procStarter.envs((Map)buildEnvironment).cmds(emulatorCmd).start();
        boolean socket = this.waitForSocket(launcher, adbPort, 60000);
        if (!socket || !emulatorProcess.isAlive()) {
            this.log(logger, Messages.EMULATOR_DID_NOT_START());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        String adbConnectArgs = "connect localhost:" + adbPort;
        ArgumentListBuilder adbConnectCmd = Utils.getToolCommand((Launcher)launcher, (String)androidHome, (String)"adb", (String)"adb.exe", (String)adbConnectArgs);
        int result = procStarter.cmds(adbConnectCmd).stdout((OutputStream)new NullOutputStream(null)).start().join();
        if (result != 0) {
            this.log(logger, Messages.CANNOT_CONNECT_TO_EMULATOR());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        File artifactsDir = build.getArtifactsDir();
        FilePath logcatFile = build.getWorkspace().createTempFile("logcat_", ".log");
        OutputStream logcatStream = logcatFile.write();
        String logcatArgs = "-s localhost:" + adbPort + " logcat -v time";
        ArgumentListBuilder logcatCmd = Utils.getToolCommand((Launcher)launcher, (String)androidHome, (String)"adb", (String)"adb.exe", (String)logcatArgs);
        Proc logWriter = procStarter.cmds(logcatCmd).stdout(logcatStream).stderr((OutputStream)new NullOutputStream(null)).start();
        this.log(logger, Messages.WAITING_FOR_BOOT_COMPLETION());
        int bootTimeout = 120000;
        if (!emulatorAlreadyExists) {
            bootTimeout *= 4;
        }
        if (!(bootSucceeded = this.waitForBootCompletion(logger, launcher, androidHome, adbPort, bootTimeout))) {
            this.log(logger, Messages.BOOT_COMPLETION_TIMED_OUT((Object)(bootTimeout / 1000)));
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
            return null;
        }
        long bootCompleteTime = System.currentTimeMillis();
        this.log(logger, Messages.EMULATOR_IS_READY((Object)((bootCompleteTime - bootTime) / 1000L)));
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized void log(PrintStream logger, String message) {
        logger.print("[android] ");
        logger.println(message);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort) throws IOException, InterruptedException {
        this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort, null, null, null, null);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort, Proc logcatProcess, FilePath logcatFile, OutputStream logcatStream, File artifactsDir) throws IOException, InterruptedException {
        this.log(logger, Messages.STOPPING_EMULATOR());
        emulatorProcess.kill();
        portAllocator.free(adbPort);
        portAllocator.free(userPort);
        if (logcatProcess != null) {
            logcatProcess.kill();
            logcatStream.close();
            if (logcatFile.length() != 0L) {
                this.log(logger, Messages.ARCHIVING_LOG());
                logcatFile.copyTo(new FilePath(artifactsDir).child("logcat.txt"));
            }
            logcatFile.delete();
        }
    }

    private String expandVariables(EnvVars envVars, Map<String, String> buildVars, String token) {
        String result = Util.fixEmptyAndTrim((String)token);
        if (result != null) {
            result = Util.replaceMacro((String)Util.replaceMacro((String)result, (Map)envVars), buildVars);
        }
        return result;
    }

    private String isConfigValid(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        if (this.getUseNamedEmulator()) {
            ValidationResult result = DescriptorImpl.access$200((DescriptorImpl)this.descriptor, (String)avdName, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        } else {
            ValidationResult result = DescriptorImpl.access$300((DescriptorImpl)this.descriptor, (String)osVersion, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$400((DescriptorImpl)this.descriptor, (String)screenDensity, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$500((DescriptorImpl)this.descriptor, (String)screenResolution, null, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$600((DescriptorImpl)this.descriptor, (String)deviceLocale, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        }
        return null;
    }

    private String validateAndroidHome(Launcher launcher, EnvVars envVars, String androidHome) {
        2 task = new /* Unavailable Anonymous Inner Class!! */;
        String result = androidHome;
        try {
            result = (String)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private boolean validateAndroidToolsInPath(Launcher launcher, String androidHome) {
        String executable = "tools/" + (launcher.isUnix() ? "adb" : "adb.exe");
        3 task = new /* Unavailable Anonymous Inner Class!! */;
        try {
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForSocket(Launcher launcher, int port, int timeout) {
        try {
            LocalPortOpenTask task = new LocalPortOpenTask(port, timeout);
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException ex) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForBootCompletion(PrintStream logger, Launcher launcher, String androidHome, int port, int timeout) {
        long start = System.currentTimeMillis();
        int sleep = timeout / (int)Math.sqrt(timeout / 1000);
        String serialNo = "localhost:" + port;
        String args = "-s " + serialNo + " shell getprop dev.bootcomplete";
        ArgumentListBuilder cmd = Utils.getToolCommand((Launcher)launcher, (String)androidHome, (String)"adb", (String)"adb.exe", (String)args);
        try {
            while (System.currentTimeMillis() < start + (long)timeout) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
                launcher.launch().cmds(cmd).stdout((OutputStream)stream).start().join();
                String result = stream.toString().trim();
                if (result.equals("1")) {
                    return true;
                }
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedException ex) {
            this.log(logger, Messages.INTERRUPTED_DURING_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        catch (IOException ex) {
            this.log(logger, Messages.COULD_NOT_CHECK_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        return false;
    }

    static /* synthetic */ void access$100(AndroidEmulator x0, PrintStream x1, PortAllocationManager x2, Proc x3, int x4, int x5, Proc x6, FilePath x7, OutputStream x8, File x9) throws IOException, InterruptedException {
        x0.cleanUp(x1, x2, x3, x4, x5, x6, x7, x8, x9);
    }

    static /* synthetic */ DescriptorImpl access$700(AndroidEmulator x0) {
        return x0.descriptor;
    }
}

