/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.Util;
import java.io.Serializable;

class AndroidPlatform
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final AndroidPlatform SDK_1_1 = new AndroidPlatform("1.1", 2);
    static final AndroidPlatform SDK_1_5 = new AndroidPlatform("1.5", 3);
    static final AndroidPlatform SDK_1_6 = new AndroidPlatform("1.6", 4);
    static final AndroidPlatform SDK_2_0 = new AndroidPlatform("2.0", 5);
    static final AndroidPlatform SDK_2_0_1 = new AndroidPlatform("2.0.1", 6);
    static final AndroidPlatform SDK_2_1 = new AndroidPlatform("2.1", 7);
    static final AndroidPlatform[] PRESETS = new AndroidPlatform[]{SDK_1_1, SDK_1_5, SDK_1_6, SDK_2_0, SDK_2_0_1, SDK_2_1};
    private final String name;
    private final int level;

    private AndroidPlatform(String name, int level) {
        this.name = name;
        this.level = level;
    }

    private AndroidPlatform(String name) {
        this(name, -1);
    }

    public static AndroidPlatform valueOf(String version) {
        if (Util.fixEmptyAndTrim((String)version) == null) {
            return null;
        }
        for (AndroidPlatform preset : PRESETS) {
            if (!version.equals(preset.name) && !version.equals(preset.level + "")) continue;
            return preset;
        }
        return new AndroidPlatform(version);
    }

    public boolean isCustomPlatform() {
        return this.level == -1;
    }

    public String getTargetName() {
        if (this.isCustomPlatform()) {
            return this.name;
        }
        return "android-" + this.level;
    }

    public String getOldTargetName() {
        return "android-" + this.name;
    }

    public int getSdkLevel() {
        return this.level;
    }

    public String toString() {
        return this.name;
    }
}

