/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.Util;
import hudson.plugins.android_emulator.AndroidPlatform;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.ScreenDensity;
import hudson.plugins.android_emulator.ScreenResolution;
import hudson.plugins.android_emulator.Utils;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamCopyThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmulatorConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String avdName;
    private AndroidPlatform osVersion;
    private ScreenDensity screenDensity;
    private ScreenResolution screenResolution;
    private String deviceLocale;
    private String sdCardSize;

    public EmulatorConfig(String avdName) {
        this.avdName = avdName;
    }

    public EmulatorConfig(String osVersion, String screenDensity, String screenResolution, String deviceLocale) throws IllegalArgumentException {
        if (osVersion == null || screenDensity == null || screenResolution == null) {
            throw new IllegalArgumentException("Valid OS version and screen properties must be supplied.");
        }
        this.sdCardSize = "16M";
        int targetLength = osVersion.length();
        if (targetLength > 2 && osVersion.startsWith("\"") && osVersion.endsWith("\"")) {
            osVersion = osVersion.substring(1, targetLength - 1);
        }
        screenDensity = screenDensity.toLowerCase();
        if (screenResolution.matches("(?i)([HQ]|F?WQ?)VGA")) {
            screenResolution = screenResolution.toUpperCase();
        } else if (screenResolution.matches("(?i)[0-9]{3,4}x[0-9]{3,4}")) {
            screenResolution = screenResolution.toLowerCase();
        }
        if (deviceLocale != null) {
            deviceLocale = deviceLocale.substring(0, 2).toLowerCase() + "_" + deviceLocale.substring(3).toUpperCase();
        }
        this.osVersion = AndroidPlatform.valueOf(osVersion);
        this.screenDensity = ScreenDensity.valueOf(screenDensity);
        this.screenResolution = ScreenResolution.valueOf(screenResolution);
        this.deviceLocale = deviceLocale;
    }

    public static final EmulatorConfig create(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale) {
        if (Util.fixEmptyAndTrim((String)avdName) == null) {
            return new EmulatorConfig(osVersion, screenDensity, screenResolution, deviceLocale);
        }
        return new EmulatorConfig(avdName);
    }

    public boolean isNamedEmulator() {
        return this.avdName != null && this.osVersion == null;
    }

    public String getAvdName() {
        if (this.isNamedEmulator()) {
            return this.avdName;
        }
        return this.getGeneratedAvdName();
    }

    private String getGeneratedAvdName() {
        String locale = this.getDeviceLocale().replace('_', '-');
        String density = this.screenDensity.toString();
        String resolution = this.screenResolution.toString();
        String platform = this.osVersion.getTargetName().replace(':', '_').replace(' ', '_');
        return String.format("hudson_%s_%s_%s_%s", locale, density, resolution, platform);
    }

    public AndroidPlatform getOsVersion() {
        return this.osVersion;
    }

    public ScreenDensity getScreenDensity() {
        return this.screenDensity;
    }

    public ScreenResolution getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        if (this.deviceLocale == null) {
            return "en_US";
        }
        return this.deviceLocale;
    }

    public String getDeviceLanguage() {
        return this.getDeviceLocale().substring(0, 2);
    }

    public String getDeviceCountry() {
        return this.getDeviceLocale().substring(3);
    }

    public String getSdCardSize() {
        return this.sdCardSize;
    }

    public Callable<Boolean, IOException> getEmulatorCreationTask(String androidHome, boolean isUnix) {
        return new EmulatorCreationTask(androidHome, isUnix);
    }

    private File getAvdHome(File homeDir) {
        return new File(homeDir, ".android/avd/");
    }

    private File getAvdDirectory(File homeDir) {
        return new File(this.getAvdHome(homeDir), this.getAvdName() + ".avd");
    }

    private Map<String, String> parseAvdConfigFile(File homeDir) throws IOException {
        String line;
        File configFile = new File(this.getAvdDirectory(homeDir), "config.ini");
        FileReader fileReader = new FileReader(configFile);
        BufferedReader reader = new BufferedReader(fileReader);
        HashMap<String, String> values = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("=", 2);
            values.put(parts[0], parts[1]);
        }
        return values;
    }

    private void writeAvdConfigFile(File homeDir, Map<String, String> values) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        for (String key : values.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append(values.get(key));
            sb.append("\r\n");
        }
        File configFile = new File(this.getAvdDirectory(homeDir), "config.ini");
        PrintWriter out = new PrintWriter(configFile);
        out.print(sb.toString());
        out.flush();
        out.close();
    }

    public String getCommandArguments() {
        StringBuilder sb = new StringBuilder("-no-boot-anim");
        if (!this.isNamedEmulator()) {
            sb.append(" -prop persist.sys.language=");
            sb.append(this.getDeviceLanguage());
            sb.append(" -prop persist.sys.country=");
            sb.append(this.getDeviceCountry());
        }
        sb.append(" -avd ");
        sb.append(this.getAvdName());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EmulatorCreationTask
    implements Callable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String androidHome;
        private final boolean isUnix;

        public EmulatorCreationTask(String androidHome, boolean isUnix) {
            this.androidHome = androidHome;
            this.isUnix = isUnix;
        }

        public Boolean call() throws IOException {
            File homeDir = new File(System.getProperty("user.home"));
            File avdDirectory = EmulatorConfig.this.getAvdDirectory(homeDir);
            if (avdDirectory.exists()) {
                return true;
            }
            if (EmulatorConfig.this.isNamedEmulator()) {
                throw new FileNotFoundException(Messages.AVD_DOES_NOT_EXIST(EmulatorConfig.this.avdName));
            }
            if (this.androidHome == null) {
                throw new FileNotFoundException(Messages.SDK_NOT_SPECIFIED());
            }
            File sdkRoot = new File(this.androidHome);
            if (!sdkRoot.exists()) {
                throw new FileNotFoundException(Messages.SDK_NOT_FOUND(this.androidHome));
            }
            String androidCmd = this.isUnix ? "android" : "android.bat";
            StringBuilder args = new StringBuilder(100);
            args.append("create avd ");
            if (EmulatorConfig.this.sdCardSize != null) {
                args.append("-c ");
                args.append(EmulatorConfig.this.sdCardSize);
                args.append(" ");
            }
            args.append("-s ");
            args.append(EmulatorConfig.this.screenResolution.getSkinName());
            args.append(" -n ");
            args.append(EmulatorConfig.this.getAvdName());
            ArgumentListBuilder builder = Utils.getToolCommand(this.androidHome, androidCmd, args.toString());
            builder.add("-t");
            builder.addQuoted(EmulatorConfig.this.osVersion.getTargetName());
            ProcessBuilder procBuilder = new ProcessBuilder(builder.toList());
            Process process = procBuilder.start();
            new StreamCopyThread("", process.getErrorStream(), (OutputStream)System.err).start();
            boolean avdCreated = false;
            try {
                InputStream in = process.getInputStream();
                int len = in.read();
                if (len == -1 && process.exitValue() != 0) {
                    throw new IOException(Messages.AVD_CREATION_FAILED());
                }
                in.close();
                OutputStream stream = process.getOutputStream();
                stream.write(13);
                stream.write(10);
                stream.flush();
                int result = process.waitFor();
                if (result == 0) {
                    avdCreated = true;
                }
                stream.close();
            }
            catch (IOException e) {
                throw new IOException(Messages.AVD_CREATION_ABORTED(), e);
            }
            catch (InterruptedException e) {
                throw new IOException(Messages.AVD_CREATION_INTERRUPTED(), e);
            }
            finally {
                process.destroy();
            }
            if (!avdCreated) {
                throw new IOException();
            }
            Map configValues = EmulatorConfig.this.parseAvdConfigFile(homeDir);
            EmulatorConfig.this.writeAvdConfigFile(homeDir, configValues);
            return false;
        }
    }
}

