/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.AndroidEmulatorException;
import hudson.plugins.android_emulator.AndroidPlatform;
import hudson.plugins.android_emulator.Constants;
import hudson.plugins.android_emulator.EmulatorConfig;
import hudson.plugins.android_emulator.EmulatorDiscoveryException;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.ScreenDensity;
import hudson.plugins.android_emulator.ScreenResolution;
import hudson.plugins.android_emulator.Tool;
import hudson.plugins.android_emulator.Utils;
import hudson.plugins.android_emulator.ValidationResult;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.hudson.plugins.port_allocator.PortAllocationManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidEmulator
extends BuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ADB_CONNECT_TIMEOUT_MS = 60000;
    private static final int BOOT_COMPLETE_TIMEOUT_MS = 120000;
    private DescriptorImpl descriptor;
    private final String avdName;
    private final String osVersion;
    private final String screenDensity;
    private final String screenResolution;
    private final String deviceLocale;
    private final String sdCardSize;
    private final boolean wipeData;
    private final boolean showWindow;
    private final int startupDelay;

    @DataBoundConstructor
    public AndroidEmulator(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize, boolean wipeData, boolean showWindow, int startupDelay) {
        this.avdName = avdName;
        this.osVersion = osVersion;
        this.screenDensity = screenDensity;
        this.screenResolution = screenResolution;
        this.deviceLocale = deviceLocale;
        this.sdCardSize = sdCardSize;
        this.wipeData = wipeData;
        this.showWindow = showWindow;
        this.startupDelay = Math.abs(startupDelay);
    }

    public boolean getUseNamedEmulator() {
        return this.avdName != null;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        return this.deviceLocale;
    }

    public String getSdCardSize() {
        return this.sdCardSize;
    }

    public boolean shouldWipeData() {
        return this.wipeData;
    }

    public boolean shouldShowWindow() {
        return this.showWindow;
    }

    public int getStartupDelay() {
        return this.startupDelay;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (this.descriptor == null) {
            this.descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        }
        EnvVars localVars = Computer.currentComputer().getEnvironment();
        EnvVars envVars = new EnvVars(localVars);
        envVars.putAll((Map)build.getEnvironment((TaskListener)listener));
        Map buildVars = build.getBuildVariables();
        String avdName = this.expandVariables(envVars, buildVars, this.avdName);
        String osVersion = this.expandVariables(envVars, buildVars, this.osVersion);
        String screenDensity = this.expandVariables(envVars, buildVars, this.screenDensity);
        String screenResolution = this.expandVariables(envVars, buildVars, this.screenResolution);
        String deviceLocale = this.expandVariables(envVars, buildVars, this.deviceLocale);
        String sdCardSize = this.expandVariables(envVars, buildVars, this.sdCardSize);
        String androidHome = this.expandVariables(envVars, buildVars, this.descriptor.androidHome);
        androidHome = this.validateAndroidHome(launcher, localVars, androidHome);
        String configError = this.isConfigValid(avdName, osVersion, screenDensity, screenResolution, deviceLocale, sdCardSize);
        if (configError != null) {
            AndroidEmulator.log(logger, Messages.ERROR_MISCONFIGURED(configError));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        if (!this.validateAndroidToolsInPath(launcher, androidHome)) {
            AndroidEmulator.log(logger, Messages.SDK_TOOLS_NOT_FOUND());
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        String displayHome = androidHome == null ? Messages.USING_PATH() : androidHome;
        AndroidEmulator.log(logger, Messages.USING_SDK(displayHome));
        EmulatorConfig emuConfig = EmulatorConfig.create(avdName, osVersion, screenDensity, screenResolution, deviceLocale, sdCardSize, this.wipeData, this.showWindow);
        return this.doSetUp(build, launcher, listener, androidHome, emuConfig);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild<?, ?> build, final Launcher launcher, BuildListener listener, final String androidHome, final EmulatorConfig emuConfig) throws IOException, InterruptedException {
        boolean bootSucceeded;
        boolean emulatorAlreadyExists;
        final PrintStream logger = listener.getLogger();
        Computer computer = Computer.currentComputer();
        try {
            Callable<Boolean, AndroidEmulatorException> task = emuConfig.getEmulatorCreationTask(androidHome, launcher.isUnix(), listener);
            emulatorAlreadyExists = (Boolean)launcher.getChannel().call(task);
        }
        catch (EmulatorDiscoveryException ex) {
            AndroidEmulator.log(logger, Messages.CANNOT_START_EMULATOR(ex.getMessage()));
            build.setResult(Result.FAILURE);
            return null;
        }
        catch (AndroidEmulatorException ex) {
            AndroidEmulator.log(logger, Messages.COULD_NOT_CREATE_EMULATOR(ex.getMessage()));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        int delaySecs = this.getStartupDelay();
        if (delaySecs > 0) {
            AndroidEmulator.log(logger, Messages.DELAYING_START_UP(delaySecs));
            Thread.sleep(delaySecs * 1000);
        }
        final PortAllocationManager portAllocator = PortAllocationManager.getManager((Computer)computer);
        final int userPort = portAllocator.allocateRandom(build, 0);
        final int adbPort = portAllocator.allocateRandom(build, 0);
        String avdArgs = emuConfig.getCommandArguments();
        String emulatorArgs = String.format("-ports %s,%s %s", userPort, adbPort, avdArgs);
        ArgumentListBuilder emulatorCmd = Utils.getToolCommand(launcher, androidHome, Tool.EMULATOR, emulatorArgs);
        AndroidEmulator.log(logger, Messages.STARTING_EMULATOR());
        if (emulatorAlreadyExists && emuConfig.shouldWipeData()) {
            AndroidEmulator.log(logger, Messages.ERASING_EXISTING_EMULATOR_DATA());
        }
        long bootTime = System.currentTimeMillis();
        EnvVars buildEnvironment = build.getEnvironment(TaskListener.NULL);
        Launcher.ProcStarter procStarter = launcher.launch().stdout((OutputStream)logger).stderr((OutputStream)logger);
        final Proc emulatorProcess = procStarter.envs((Map)buildEnvironment).cmds(emulatorCmd).start();
        boolean socket = this.waitForSocket(launcher, adbPort, 60000);
        if (!socket || !emulatorProcess.isAlive()) {
            AndroidEmulator.log(logger, Messages.EMULATOR_DID_NOT_START());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        String adbConnectArgs = "connect localhost:" + adbPort;
        ArgumentListBuilder adbConnectCmd = Utils.getToolCommand(launcher, androidHome, Tool.ADB, adbConnectArgs);
        int result = procStarter.cmds(adbConnectCmd).stdout((OutputStream)new NullOutputStream()).start().join();
        if (result != 0) {
            AndroidEmulator.log(logger, Messages.CANNOT_CONNECT_TO_EMULATOR());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        final File artifactsDir = build.getArtifactsDir();
        final FilePath logcatFile = build.getWorkspace().createTempFile("logcat_", ".log");
        final OutputStream logcatStream = logcatFile.write();
        String logcatArgs = "-s localhost:" + adbPort + " logcat -v time";
        ArgumentListBuilder logcatCmd = Utils.getToolCommand(launcher, androidHome, Tool.ADB, logcatArgs);
        final Proc logWriter = procStarter.cmds(logcatCmd).stdout(logcatStream).stderr((OutputStream)new NullOutputStream()).start();
        AndroidEmulator.log(logger, Messages.WAITING_FOR_BOOT_COMPLETION());
        int bootTimeout = 120000;
        if (!emulatorAlreadyExists || emuConfig.shouldWipeData()) {
            bootTimeout *= 4;
        }
        if (!(bootSucceeded = this.waitForBootCompletion(logger, launcher, androidHome, adbPort, bootTimeout))) {
            AndroidEmulator.log(logger, Messages.BOOT_COMPLETION_TIMED_OUT(bootTimeout / 1000));
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, launcher, androidHome, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
            return null;
        }
        if (emulatorAlreadyExists && !this.wipeData) {
            AndroidEmulator.log(logger, Messages.UNLOCKING_SCREEN());
            Thread.sleep(5000L);
            this.sendEmulatorCommand(launcher, logger, userPort, "event send EV_KEY:KEY_MENU:1");
            this.sendEmulatorCommand(launcher, logger, userPort, "event send EV_KEY:KEY_MENU:0");
            if (emuConfig.isNamedEmulator()) {
                this.sendEmulatorCommand(launcher, logger, userPort, "event send EV_KEY:KEY_BACK:1");
                this.sendEmulatorCommand(launcher, logger, userPort, "event send EV_KEY:KEY_BACK:0");
            }
        }
        long bootCompleteTime = System.currentTimeMillis();
        AndroidEmulator.log(logger, Messages.EMULATOR_IS_READY((bootCompleteTime - bootTime) / 1000L));
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("ANDROID_AVD_DEVICE", "localhost:" + adbPort);
                env.put("ANDROID_AVD_ADB_PORT", Integer.toString(adbPort));
                env.put("ANDROID_AVD_USER_PORT", Integer.toString(userPort));
                env.put("ANDROID_AVD_NAME", emuConfig.getAvdName());
                if (!emuConfig.isNamedEmulator()) {
                    env.put("ANDROID_AVD_OS", emuConfig.getOsVersion().toString());
                    env.put("ANDROID_AVD_DENSITY", emuConfig.getScreenDensity().toString());
                    env.put("ANDROID_AVD_RESOLUTION", emuConfig.getScreenResolution().toString());
                    env.put("ANDROID_AVD_SKIN", emuConfig.getScreenResolution().getSkinName());
                    env.put("ANDROID_AVD_LOCALE", emuConfig.getDeviceLocale());
                }
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                AndroidEmulator.this.cleanUp(logger, launcher, androidHome, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
                return true;
            }
        };
    }

    static synchronized void log(PrintStream logger, String message) {
        AndroidEmulator.log(logger, message, false);
    }

    static synchronized void log(PrintStream logger, String message, boolean indent) {
        if (indent) {
            message = '\t' + message.replace("\n", "\n\t");
        } else {
            logger.print("[android] ");
        }
        logger.println(message);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort) throws IOException, InterruptedException {
        this.cleanUp(logger, null, null, portAllocator, emulatorProcess, adbPort, userPort, null, null, null, null);
    }

    private void cleanUp(PrintStream logger, Launcher launcher, String androidHome, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort, Proc logcatProcess, FilePath logcatFile, OutputStream logcatStream, File artifactsDir) throws IOException, InterruptedException {
        if (launcher != null) {
            String args = "disconnect localhost:" + adbPort;
            ArgumentListBuilder adbDisconnectCmd = Utils.getToolCommand(launcher, androidHome, Tool.ADB, args);
            Launcher.ProcStarter procStarter = launcher.launch().stderr((OutputStream)logger);
            procStarter.cmds(adbDisconnectCmd).stdout((OutputStream)new NullOutputStream()).start().join();
        }
        AndroidEmulator.log(logger, Messages.STOPPING_EMULATOR());
        if (logcatProcess != null) {
            this.sendEmulatorCommand(launcher, logger, userPort, "kill");
            logcatProcess.kill();
            logcatStream.close();
            if (logcatFile.length() != 0L) {
                AndroidEmulator.log(logger, Messages.ARCHIVING_LOG());
                logcatFile.copyTo(new FilePath(artifactsDir).child("logcat.txt"));
            }
            logcatFile.delete();
        }
        if (emulatorProcess.isAlive()) {
            emulatorProcess.kill();
        }
        portAllocator.free(adbPort);
        portAllocator.free(userPort);
    }

    private String expandVariables(EnvVars envVars, Map<String, String> buildVars, String token) {
        String result = Util.fixEmptyAndTrim((String)token);
        if (result != null) {
            result = Util.replaceMacro((String)Util.replaceMacro((String)result, (Map)envVars), buildVars);
        }
        return result;
    }

    private String isConfigValid(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize) {
        if (this.getUseNamedEmulator()) {
            ValidationResult result = this.descriptor.doCheckAvdName(avdName, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        } else {
            ValidationResult result = this.descriptor.doCheckOsVersion(osVersion, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckScreenDensity(screenDensity, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckScreenResolution(screenResolution, null, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckDeviceLocale(deviceLocale, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = this.descriptor.doCheckSdCardSize(sdCardSize, false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        }
        return null;
    }

    private String validateAndroidHome(Launcher launcher, final EnvVars envVars, final String androidHome) {
        Callable<String, InterruptedException> task = new Callable<String, InterruptedException>(){
            private static final long serialVersionUID = 1L;

            public String call() throws InterruptedException {
                String[] keys;
                if (this.validateHomeDir(androidHome)) {
                    return androidHome;
                }
                for (String key : keys = new String[]{"ANDROID_SDK_ROOT", "ANDROID_SDK_HOME", "ANDROID_HOME", "ANDROID_SDK"}) {
                    String home = (String)envVars.get((Object)key);
                    if (!this.validateHomeDir(home)) continue;
                    return home;
                }
                return androidHome;
            }

            private boolean validateHomeDir(String dir) {
                if (Util.fixEmptyAndTrim((String)dir) == null) {
                    return false;
                }
                return !AndroidEmulator.this.descriptor.doCheckAndroidHome(new File(dir), false).isFatal();
            }
        };
        String result = androidHome;
        try {
            result = (String)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private boolean validateAndroidToolsInPath(Launcher launcher, final String androidHome) {
        final String executable = "tools/" + (launcher.isUnix() ? "adb" : "adb.exe");
        Callable<Boolean, IOException> task = new Callable<Boolean, IOException>(){
            private static final long serialVersionUID = 1L;

            public Boolean call() throws IOException {
                String sep = System.getProperty("path.separator");
                List<String> list = Arrays.asList(System.getenv("PATH").split(sep));
                ArrayList<String> paths = new ArrayList<String>(list);
                paths.add(0, androidHome);
                for (String path : paths) {
                    if (!new File(path, executable).exists()) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForSocket(Launcher launcher, int port, int timeout) {
        try {
            LocalPortOpenTask task = new LocalPortOpenTask(port, timeout);
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException ex) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForBootCompletion(PrintStream logger, Launcher launcher, String androidHome, int port, int timeout) {
        long start = System.currentTimeMillis();
        int sleep = timeout / (int)Math.sqrt(timeout / 1000);
        String serialNo = "localhost:" + port;
        String args = "-s " + serialNo + " shell getprop dev.bootcomplete";
        ArgumentListBuilder cmd = Utils.getToolCommand(launcher, androidHome, Tool.ADB, args);
        try {
            while (System.currentTimeMillis() < start + (long)timeout) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
                launcher.launch().cmds(cmd).stdout((OutputStream)stream).start().join();
                String result = stream.toString().trim();
                if (result.equals("1")) {
                    return true;
                }
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedException ex) {
            AndroidEmulator.log(logger, Messages.INTERRUPTED_DURING_BOOT_COMPLETION());
        }
        catch (IOException ex) {
            AndroidEmulator.log(logger, Messages.COULD_NOT_CHECK_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        return false;
    }

    private boolean sendEmulatorCommand(Launcher launcher, PrintStream logger, final int port, final String command) {
        Callable<Boolean, IOException> task = new Callable<Boolean, IOException>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean call() throws IOException {
                Socket socket = null;
                BufferedReader in = null;
                PrintWriter out = null;
                try {
                    socket = new Socket("127.0.0.1", port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    if (in.readLine() == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    out.write(command);
                    out.write("\r\n");
                }
                finally {
                    try {
                        out.close();
                        in.close();
                        socket.close();
                    }
                    catch (Exception e) {}
                }
                return true;
            }
        };
        boolean result = false;
        try {
            result = (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (Exception e) {
            AndroidEmulator.log(logger, String.format("Failed to execute emulator command '%s': %s", command, e));
        }
        return result;
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalPortOpenTask
    implements Callable<Boolean, InterruptedException> {
        private static final long serialVersionUID = 1L;
        private final int port;
        private final int timeout;

        public LocalPortOpenTask(int port, int timeout) {
            this.port = port;
            this.timeout = timeout;
        }

        public Boolean call() throws InterruptedException {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + (long)this.timeout) {
                try {
                    Socket socket = new Socket("127.0.0.1", this.port);
                    socket.getOutputStream();
                    socket.close();
                    return true;
                }
                catch (IOException iOException) {
                    Thread.sleep(1000L);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=-100.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String VARIABLE_REGEX = "\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
        public String androidHome;

        public DescriptorImpl() {
            super(AndroidEmulator.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.JOB_DESCRIPTION();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "android-emulator.");
            this.save();
            return true;
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String avdName = null;
            String osVersion = null;
            String screenDensity = null;
            String screenResolution = null;
            String deviceLocale = null;
            String sdCardSize = null;
            boolean wipeData = false;
            boolean showWindow = true;
            int startupDelay = 0;
            JSONObject emulatorData = formData.getJSONObject("useNamed");
            String useNamedValue = emulatorData.getString("value");
            if (Boolean.parseBoolean(useNamedValue)) {
                avdName = Util.fixEmptyAndTrim((String)emulatorData.getString("avdName"));
            } else {
                osVersion = Util.fixEmptyAndTrim((String)emulatorData.getString("osVersion"));
                screenDensity = Util.fixEmptyAndTrim((String)emulatorData.getString("screenDensity"));
                screenResolution = Util.fixEmptyAndTrim((String)emulatorData.getString("screenResolution"));
                deviceLocale = Util.fixEmptyAndTrim((String)emulatorData.getString("deviceLocale"));
                sdCardSize = Util.fixEmptyAndTrim((String)emulatorData.getString("sdCardSize"));
                if (sdCardSize != null) {
                    sdCardSize = sdCardSize.toUpperCase().replaceAll("[ B]", "");
                }
            }
            wipeData = formData.getBoolean("wipeData");
            showWindow = formData.getBoolean("showWindow");
            try {
                startupDelay = Integer.parseInt(formData.getString("startupDelay"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return new AndroidEmulator(avdName, osVersion, screenDensity, screenResolution, deviceLocale, sdCardSize, wipeData, showWindow, startupDelay);
        }

        public String getHelpFile() {
            return "/plugin/android-emulator/help-buildConfig.html";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public AndroidPlatform[] getAndroidVersions() {
            return AndroidPlatform.PRESETS;
        }

        public ScreenDensity[] getDeviceDensities() {
            return ScreenDensity.PRESETS;
        }

        public ScreenResolution[] getDeviceResolutions() {
            return ScreenResolution.PRESETS;
        }

        public String[] getEmulatorLocales() {
            return Constants.EMULATOR_LOCALES;
        }

        public FormValidation doCheckAvdName(@QueryParameter String value) {
            return this.doCheckAvdName(value, true).getFormValidation();
        }

        private ValidationResult doCheckAvdName(String avdName, boolean allowVariables) {
            if (avdName == null || avdName.equals("")) {
                return ValidationResult.error(Messages.AVD_NAME_REQUIRED());
            }
            String regex = "[a-zA-Z0-9._-]+";
            if (allowVariables) {
                regex = "(([a-zA-Z0-9._-]+)*(\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$))*)+";
            }
            if (!avdName.matches(regex)) {
                return ValidationResult.error(Messages.INVALID_AVD_NAME());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckOsVersion(@QueryParameter String value) {
            return this.doCheckOsVersion(value, true).getFormValidation();
        }

        private ValidationResult doCheckOsVersion(String osVersion, boolean allowVariables) {
            if (osVersion == null || osVersion.equals("")) {
                return ValidationResult.error(Messages.OS_VERSION_REQUIRED());
            }
            if (!allowVariables && osVersion.matches(VARIABLE_REGEX)) {
                return ValidationResult.error(Messages.INVALID_OS_VERSION());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckScreenDensity(@QueryParameter String value) {
            return this.doCheckScreenDensity(value, true).getFormValidation();
        }

        private ValidationResult doCheckScreenDensity(String density, boolean allowVariables) {
            if (density == null || density.equals("")) {
                return ValidationResult.error(Messages.SCREEN_DENSITY_REQUIRED());
            }
            String regex = "[0-9]{2,4}|(?i)[hlm]dpi";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!density.matches(regex)) {
                return ValidationResult.error(Messages.SCREEN_DENSITY_NOT_NUMERIC());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckScreenResolution(@QueryParameter String value, @QueryParameter String density) {
            return this.doCheckScreenResolution(value, density, true).getFormValidation();
        }

        private ValidationResult doCheckScreenResolution(String resolution, String density, boolean allowVariables) {
            if (resolution == null || resolution.equals("")) {
                return ValidationResult.error(Messages.SCREEN_RESOLUTION_REQUIRED());
            }
            String regex = "([HQ]|F?WQ?)VGA|[0-9]{3,4}x[0-9]{3,4}";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!resolution.matches(regex)) {
                return ValidationResult.error(Messages.INVALID_RESOLUTION_FORMAT());
            }
            ScreenResolution resolutionValue = ScreenResolution.valueOf(resolution);
            ScreenDensity densityValue = ScreenDensity.valueOf(density);
            if (resolutionValue != null && densityValue != null && !resolutionValue.isCustomResolution() && !densityValue.isCustomDensity()) {
                boolean densityFound = false;
                for (ScreenDensity okDensity : resolutionValue.getApplicableDensities()) {
                    if (!okDensity.equals(densityValue)) continue;
                    densityFound = true;
                    break;
                }
                if (!densityFound) {
                    return ValidationResult.warning(Messages.SUSPECT_RESOLUTION(resolution, densityValue));
                }
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckDeviceLocale(@QueryParameter String value) {
            return this.doCheckDeviceLocale(value, true).getFormValidation();
        }

        private ValidationResult doCheckDeviceLocale(String locale, boolean allowVariables) {
            if (locale == null || locale.equals("")) {
                return ValidationResult.warning(Messages.DEFAULT_LOCALE_WARNING("en_US"));
            }
            String regex = "[a-z]{2}_[A-Z]{2}";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!locale.matches(regex)) {
                return ValidationResult.error(Messages.LOCALE_FORMAT_WARNING());
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckSdCardSize(@QueryParameter String value) {
            return this.doCheckSdCardSize(value, true).getFormValidation();
        }

        private ValidationResult doCheckSdCardSize(String sdCardSize, boolean allowVariables) {
            if (sdCardSize == null || sdCardSize.equals("")) {
                return ValidationResult.ok();
            }
            String regex = "(?i)([0-9]{1,12}) ?([KM])[B]?";
            if (allowVariables) {
                regex = regex + "|\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
            }
            if (!sdCardSize.matches(regex)) {
                return ValidationResult.error(Messages.INVALID_SD_CARD_SIZE());
            }
            Matcher matcher = Pattern.compile("(?i)([0-9]{1,12}) ?([KM])[B]?").matcher(sdCardSize);
            if (matcher.matches()) {
                long bytes = Long.parseLong(matcher.group(1));
                if (matcher.group(2).toUpperCase().equals("M")) {
                    bytes *= 1024L;
                }
                if ((bytes *= 1024L) < 0x900000L) {
                    return ValidationResult.error(Messages.SD_CARD_SIZE_TOO_SMALL());
                }
            }
            return ValidationResult.ok();
        }

        public FormValidation doCheckAndroidHome(@QueryParameter File value) {
            return this.doCheckAndroidHome(value, true).getFormValidation();
        }

        private ValidationResult doCheckAndroidHome(File sdkRoot, boolean fromWebConfig) {
            String[] requiredTools;
            if (fromWebConfig && !Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return ValidationResult.ok();
            }
            if (fromWebConfig && (sdkRoot == null || sdkRoot.getPath().equals(""))) {
                return ValidationResult.ok();
            }
            if (!sdkRoot.isDirectory()) {
                if (fromWebConfig && sdkRoot.getPath().matches(".*(\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)).*")) {
                    return ValidationResult.ok();
                }
                return ValidationResult.error(Messages.INVALID_DIRECTORY());
            }
            for (String dirName : new String[]{"tools", "platforms"}) {
                File dir = new File(sdkRoot, dirName);
                if (dir.exists() && dir.isDirectory()) continue;
                return ValidationResult.error(Messages.INVALID_SDK_DIRECTORY());
            }
            int toolsFound = 0;
            block1: for (String toolName : requiredTools = new String[]{"adb", "android", "emulator"}) {
                for (String extension : new String[]{"", ".bat", ".exe"}) {
                    File tool = new File(sdkRoot, "tools/" + toolName + extension);
                    if (!tool.exists() || !tool.isFile()) continue;
                    ++toolsFound;
                    continue block1;
                }
            }
            if (toolsFound != requiredTools.length) {
                return ValidationResult.errorWithMarkup(Messages.REQUIRED_SDK_TOOLS_NOT_FOUND());
            }
            File platformsDir = new File(sdkRoot, "platforms");
            if (platformsDir.list().length == 0) {
                return ValidationResult.warning(Messages.SDK_PLATFORMS_EMPTY());
            }
            return ValidationResult.ok();
        }
    }
}

