/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.Util;
import hudson.model.BuildListener;
import hudson.plugins.android_emulator.AndroidEmulator;
import hudson.plugins.android_emulator.AndroidEmulatorException;
import hudson.plugins.android_emulator.AndroidPlatform;
import hudson.plugins.android_emulator.EmulatorCreationException;
import hudson.plugins.android_emulator.EmulatorDiscoveryException;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.ScreenDensity;
import hudson.plugins.android_emulator.ScreenResolution;
import hudson.plugins.android_emulator.Tool;
import hudson.plugins.android_emulator.Utils;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamCopyThread;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmulatorConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String avdName;
    private AndroidPlatform osVersion;
    private ScreenDensity screenDensity;
    private ScreenResolution screenResolution;
    private String deviceLocale;
    private String sdCardSize;
    private final boolean wipeData;
    private final boolean showWindow;

    public EmulatorConfig(String avdName, boolean wipeData, boolean showWindow) {
        this.avdName = avdName;
        this.wipeData = wipeData;
        this.showWindow = showWindow;
    }

    public EmulatorConfig(String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize, boolean wipeData, boolean showWindow) throws IllegalArgumentException {
        if (osVersion == null || screenDensity == null || screenResolution == null) {
            throw new IllegalArgumentException("Valid OS version and screen properties must be supplied.");
        }
        int targetLength = osVersion.length();
        if (targetLength > 2 && osVersion.startsWith("\"") && osVersion.endsWith("\"")) {
            osVersion = osVersion.substring(1, targetLength - 1);
        }
        screenDensity = screenDensity.toLowerCase();
        if (screenResolution.matches("(?i)([HQ]|F?WQ?)VGA")) {
            screenResolution = screenResolution.toUpperCase();
        } else if (screenResolution.matches("(?i)[0-9]{3,4}x[0-9]{3,4}")) {
            screenResolution = screenResolution.toLowerCase();
        }
        if (deviceLocale != null && deviceLocale.length() > 4) {
            deviceLocale = deviceLocale.substring(0, 2).toLowerCase() + "_" + deviceLocale.substring(3).toUpperCase();
        }
        if (sdCardSize != null) {
            sdCardSize = sdCardSize.toUpperCase().replaceAll("[ B]", "");
        }
        this.osVersion = AndroidPlatform.valueOf(osVersion);
        this.screenDensity = ScreenDensity.valueOf(screenDensity);
        this.screenResolution = ScreenResolution.valueOf(screenResolution);
        this.deviceLocale = deviceLocale;
        this.sdCardSize = sdCardSize;
        this.wipeData = wipeData;
        this.showWindow = showWindow;
    }

    public static final EmulatorConfig create(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize, boolean wipeData, boolean showWindow) {
        if (Util.fixEmptyAndTrim((String)avdName) == null) {
            return new EmulatorConfig(osVersion, screenDensity, screenResolution, deviceLocale, sdCardSize, wipeData, showWindow);
        }
        return new EmulatorConfig(avdName, wipeData, showWindow);
    }

    public boolean isNamedEmulator() {
        return this.avdName != null && this.osVersion == null;
    }

    public String getAvdName() {
        if (this.isNamedEmulator()) {
            return this.avdName;
        }
        return this.getGeneratedAvdName();
    }

    private String getGeneratedAvdName() {
        String locale = this.getDeviceLocale().replace('_', '-');
        String density = this.screenDensity.toString();
        String resolution = this.screenResolution.toString();
        String platform = this.osVersion.getTargetName().replace(':', '_').replace(' ', '_');
        return String.format("hudson_%s_%s_%s_%s", locale, density, resolution, platform);
    }

    public AndroidPlatform getOsVersion() {
        return this.osVersion;
    }

    public ScreenDensity getScreenDensity() {
        return this.screenDensity;
    }

    public ScreenResolution getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        if (this.deviceLocale == null) {
            return "en_US";
        }
        return this.deviceLocale;
    }

    public String getDeviceLanguage() {
        return this.getDeviceLocale().substring(0, 2);
    }

    public String getDeviceCountry() {
        return this.getDeviceLocale().substring(3);
    }

    public String getSdCardSize() {
        return this.sdCardSize;
    }

    public boolean shouldWipeData() {
        return this.wipeData;
    }

    public boolean shouldShowWindow() {
        return this.showWindow;
    }

    public Callable<Boolean, AndroidEmulatorException> getEmulatorCreationTask(String androidHome, boolean isUnix, BuildListener listener) {
        return new EmulatorCreationTask(androidHome, isUnix, listener);
    }

    private File getAvdHome(File homeDir) {
        return new File(homeDir, ".android/avd/");
    }

    private File getAvdDirectory(File homeDir) {
        return new File(this.getAvdHome(homeDir), this.getAvdName() + ".avd");
    }

    private Map<String, String> parseAvdConfigFile(File homeDir) throws IOException {
        String line;
        File configFile = new File(this.getAvdDirectory(homeDir), "config.ini");
        FileReader fileReader = new FileReader(configFile);
        BufferedReader reader = new BufferedReader(fileReader);
        HashMap<String, String> values = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("=", 2);
            values.put(parts[0], parts[1]);
        }
        return values;
    }

    private void writeAvdConfigFile(File homeDir, Map<String, String> values) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        for (String key : values.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append(values.get(key));
            sb.append("\r\n");
        }
        File configFile = new File(this.getAvdDirectory(homeDir), "config.ini");
        PrintWriter out = new PrintWriter(configFile);
        out.print(sb.toString());
        out.flush();
        out.close();
    }

    public String getCommandArguments() {
        StringBuilder sb = new StringBuilder("-no-boot-anim");
        if (!this.isNamedEmulator()) {
            sb.append(" -prop persist.sys.language=");
            sb.append(this.getDeviceLanguage());
            sb.append(" -prop persist.sys.country=");
            sb.append(this.getDeviceCountry());
        }
        sb.append(" -avd ");
        sb.append(this.getAvdName());
        if (this.shouldWipeData()) {
            sb.append(" -wipe-data");
        }
        if (!this.shouldShowWindow()) {
            sb.append(" -no-window");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EmulatorCreationTask
    implements Callable<Boolean, AndroidEmulatorException> {
        private static final long serialVersionUID = 1L;
        private final String androidHome;
        private final boolean isUnix;
        private final BuildListener listener;
        private transient PrintStream logger;

        public EmulatorCreationTask(String androidHome, boolean isUnix, BuildListener listener) {
            this.androidHome = androidHome;
            this.isUnix = isUnix;
            this.listener = listener;
        }

        public Boolean call() throws AndroidEmulatorException {
            Map configValues;
            Process process;
            String homeDirPath;
            if (this.logger == null) {
                this.logger = this.listener.getLogger();
            }
            if ((homeDirPath = System.getenv("ANDROID_SDK_HOME")) == null) {
                if (this.isUnix) {
                    homeDirPath = System.getenv("HOME");
                    if (homeDirPath == null) {
                        homeDirPath = "/tmp";
                    }
                } else {
                    homeDirPath = System.getenv("USERPROFILE");
                    if (homeDirPath == null) {
                        homeDirPath = System.getProperty("user.home");
                    }
                }
            }
            File homeDir = new File(homeDirPath);
            File avdDirectory = EmulatorConfig.this.getAvdDirectory(homeDir);
            if (EmulatorConfig.this.isNamedEmulator() && !avdDirectory.exists()) {
                throw new EmulatorDiscoveryException(Messages.AVD_DOES_NOT_EXIST(EmulatorConfig.this.avdName));
            }
            boolean createSdCard = false;
            if (avdDirectory.exists()) {
                File sdCardFile = new File(EmulatorConfig.this.getAvdDirectory(homeDir), "sdcard.img");
                if (EmulatorConfig.this.getSdCardSize() == null || sdCardFile.exists()) {
                    return true;
                }
                createSdCard = true;
                AndroidEmulator.log(this.logger, Messages.ADDING_SD_CARD(EmulatorConfig.this.sdCardSize, EmulatorConfig.this.getAvdName()));
            } else {
                AndroidEmulator.log(this.logger, Messages.CREATING_AVD(avdDirectory));
            }
            if (this.androidHome == null) {
                throw new EmulatorCreationException(Messages.SDK_NOT_SPECIFIED());
            }
            File sdkRoot = new File(this.androidHome);
            if (!sdkRoot.exists()) {
                throw new EmulatorCreationException(Messages.SDK_NOT_FOUND(this.androidHome));
            }
            if (createSdCard) {
                if (!this.createSdCard(homeDir)) {
                    throw new EmulatorCreationException(Messages.SD_CARD_CREATION_FAILED());
                }
                try {
                    Map configValues2 = EmulatorConfig.this.parseAvdConfigFile(homeDir);
                    configValues2.put("sdcard.size", EmulatorConfig.this.sdCardSize);
                    EmulatorConfig.this.writeAvdConfigFile(homeDir, configValues2);
                }
                catch (IOException e) {
                    throw new EmulatorCreationException(Messages.AVD_CONFIG_NOT_READABLE(), e);
                }
                return true;
            }
            String androidCmd = this.isUnix ? "android" : "android.bat";
            StringBuilder args = new StringBuilder(100);
            args.append("create avd ");
            if (EmulatorConfig.this.sdCardSize != null) {
                args.append("-c ");
                args.append(EmulatorConfig.this.sdCardSize);
                args.append(" ");
            }
            args.append("-s ");
            args.append(EmulatorConfig.this.screenResolution.getSkinName());
            args.append(" -n ");
            args.append(EmulatorConfig.this.getAvdName());
            ArgumentListBuilder builder = Utils.getToolCommand(this.androidHome, androidCmd, args.toString());
            builder.add("-t");
            builder.add(EmulatorConfig.this.osVersion.getTargetName());
            boolean avdCreated = false;
            try {
                ProcessBuilder procBuilder = new ProcessBuilder(builder.toList());
                process = procBuilder.start();
            }
            catch (IOException ex) {
                throw new EmulatorCreationException(Messages.AVD_CREATION_FAILED());
            }
            ByteArrayOutputStream stderr = new ByteArrayOutputStream();
            new StreamCopyThread("", process.getErrorStream(), (OutputStream)stderr).start();
            try {
                boolean processAlive = true;
                InputStream in = process.getInputStream();
                int len = in.read();
                if (len == -1) {
                    if (process.waitFor() != 0) {
                        AndroidEmulator.log(this.logger, Messages.AVD_CREATION_FAILED());
                        AndroidEmulator.log(this.logger, stderr.toString(), true);
                        throw new EmulatorCreationException(Messages.AVD_CREATION_FAILED());
                    }
                    processAlive = false;
                }
                in.close();
                if (processAlive) {
                    OutputStream stream = process.getOutputStream();
                    stream.write(13);
                    stream.write(10);
                    stream.flush();
                    stream.close();
                }
                if (process.waitFor() == 0) {
                    avdCreated = true;
                }
            }
            catch (IOException e) {
                throw new EmulatorCreationException(Messages.AVD_CREATION_ABORTED(), e);
            }
            catch (InterruptedException e) {
                throw new EmulatorCreationException(Messages.AVD_CREATION_INTERRUPTED(), e);
            }
            finally {
                process.destroy();
            }
            if (!avdCreated) {
                String errOutput = stderr.toString();
                if (errOutput.length() != 0) {
                    AndroidEmulator.log(this.logger, stderr.toString(), true);
                }
                throw new EmulatorCreationException(Messages.AVD_CREATION_FAILED());
            }
            try {
                configValues = EmulatorConfig.this.parseAvdConfigFile(homeDir);
            }
            catch (IOException e) {
                throw new EmulatorCreationException(Messages.AVD_CONFIG_NOT_READABLE(), e);
            }
            try {
                EmulatorConfig.this.writeAvdConfigFile(homeDir, configValues);
            }
            catch (IOException e) {
                throw new EmulatorCreationException(Messages.AVD_CONFIG_NOT_WRITEABLE(), e);
            }
            return false;
        }

        private boolean createSdCard(File homeDir) {
            String androidCmd = Tool.MKSDCARD.getExecutable(this.isUnix);
            ArgumentListBuilder builder = Utils.getToolCommand(this.androidHome, androidCmd, null);
            builder.add(EmulatorConfig.this.sdCardSize);
            builder.add(new File(EmulatorConfig.this.getAvdDirectory(homeDir), "sdcard.img"));
            try {
                ProcessBuilder procBuilder = new ProcessBuilder(builder.toList());
                procBuilder.start().waitFor();
            }
            catch (InterruptedException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }
    }
}

