/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.util.FormValidation;

public class ValidationResult {
    private final Type type;
    private final String message;
    private final boolean hasMarkup;

    public ValidationResult(Type type, String message) {
        this(type, message, false);
    }

    public ValidationResult(Type type, String message, boolean hasMarkup) {
        this.type = type;
        this.message = message;
        this.hasMarkup = hasMarkup;
    }

    public static ValidationResult ok() {
        return new ValidationResult(Type.OK, null);
    }

    public static ValidationResult warning(String message) {
        return new ValidationResult(Type.WARNING, message);
    }

    public static ValidationResult error(String message) {
        return new ValidationResult(Type.ERROR, message);
    }

    public static ValidationResult errorWithMarkup(String message) {
        return new ValidationResult(Type.ERROR, message, true);
    }

    public FormValidation getFormValidation() {
        switch (this.type) {
            case WARNING: {
                return FormValidation.warning((String)this.message);
            }
            case ERROR: {
                if (this.hasMarkup) {
                    return FormValidation.errorWithMarkup((String)this.message);
                }
                return FormValidation.error((String)this.message);
            }
        }
        return FormValidation.ok();
    }

    public boolean isFatal() {
        return this.type == Type.ERROR;
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "ValidationResult[type=" + (Object)((Object)this.type) + ", message=" + this.message + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        OK,
        WARNING,
        ERROR;

    }
}

