/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.plugins.android_emulator.ValidationResult;
import hudson.util.FormValidation;

public class ValidationResult {
    private final Type type;
    private final String message;
    private final boolean hasMarkup;

    public ValidationResult(Type type, String message) {
        this(type, message, false);
    }

    public ValidationResult(Type type, String message, boolean hasMarkup) {
        this.type = type;
        this.message = message;
        this.hasMarkup = hasMarkup;
    }

    public static ValidationResult ok() {
        return new ValidationResult(Type.OK, null);
    }

    public static ValidationResult warning(String message) {
        return new ValidationResult(Type.WARNING, message);
    }

    public static ValidationResult error(String message) {
        return new ValidationResult(Type.ERROR, message);
    }

    public static ValidationResult errorWithMarkup(String message) {
        return new ValidationResult(Type.ERROR, message, true);
    }

    public FormValidation getFormValidation() {
        switch (1.$SwitchMap$hudson$plugins$android_emulator$ValidationResult$Type[this.type.ordinal()]) {
            case 1: {
                return FormValidation.warning((String)this.message);
            }
            case 2: {
                if (this.hasMarkup) {
                    return FormValidation.errorWithMarkup((String)this.message);
                }
                return FormValidation.error((String)this.message);
            }
        }
        return FormValidation.ok();
    }

    public boolean isFatal() {
        return this.type == Type.ERROR;
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "ValidationResult[type=" + this.type + ", message=" + this.message + "]";
    }
}

