// CHECKSTYLE:OFF

package hudson.plugins.android_emulator;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Android SDK directory needs to be specified in order to create an emulator
     * 
     */
    public static String SDK_NOT_SPECIFIED() {
        return holder.format("SDK_NOT_SPECIFIED");
    }

    /**
     * Android SDK directory needs to be specified in order to create an emulator
     * 
     */
    public static Localizable _SDK_NOT_SPECIFIED() {
        return new Localizable(holder, "SDK_NOT_SPECIFIED");
    }

    /**
     * Attempting to unlock emulator screen
     * 
     */
    public static String UNLOCKING_SCREEN() {
        return holder.format("UNLOCKING_SCREEN");
    }

    /**
     * Attempting to unlock emulator screen
     * 
     */
    public static Localizable _UNLOCKING_SCREEN() {
        return new Localizable(holder, "UNLOCKING_SCREEN");
    }

    /**
     * Could not create Android emulator: {0}
     * 
     */
    public static String COULD_NOT_CREATE_EMULATOR(Object arg1) {
        return holder.format("COULD_NOT_CREATE_EMULATOR", arg1);
    }

    /**
     * Could not create Android emulator: {0}
     * 
     */
    public static Localizable _COULD_NOT_CREATE_EMULATOR(Object arg1) {
        return new Localizable(holder, "COULD_NOT_CREATE_EMULATOR", arg1);
    }

    /**
     * Cannot start Android emulator: {0}
     * 
     */
    public static String CANNOT_START_EMULATOR(Object arg1) {
        return holder.format("CANNOT_START_EMULATOR", arg1);
    }

    /**
     * Cannot start Android emulator: {0}
     * 
     */
    public static Localizable _CANNOT_START_EMULATOR(Object arg1) {
        return new Localizable(holder, "CANNOT_START_EMULATOR", arg1);
    }

    /**
     * Using Android SDK: {0}
     * 
     */
    public static String USING_SDK(Object arg1) {
        return holder.format("USING_SDK", arg1);
    }

    /**
     * Using Android SDK: {0}
     * 
     */
    public static Localizable _USING_SDK(Object arg1) {
        return new Localizable(holder, "USING_SDK", arg1);
    }

    /**
     * Locale should have format: ab_XY
     * 
     */
    public static String LOCALE_FORMAT_WARNING() {
        return holder.format("LOCALE_FORMAT_WARNING");
    }

    /**
     * Locale should have format: ab_XY
     * 
     */
    public static Localizable _LOCALE_FORMAT_WARNING() {
        return new Localizable(holder, "LOCALE_FORMAT_WARNING");
    }

    /**
     * Starting Android emulator
     * 
     */
    public static String STARTING_EMULATOR() {
        return holder.format("STARTING_EMULATOR");
    }

    /**
     * Starting Android emulator
     * 
     */
    public static Localizable _STARTING_EMULATOR() {
        return new Localizable(holder, "STARTING_EMULATOR");
    }

    /**
     * Invalid OS version
     * 
     */
    public static String INVALID_OS_VERSION() {
        return holder.format("INVALID_OS_VERSION");
    }

    /**
     * Invalid OS version
     * 
     */
    public static Localizable _INVALID_OS_VERSION() {
        return new Localizable(holder, "INVALID_OS_VERSION");
    }

    /**
     * Creating Android AVD at {0}
     * 
     */
    public static String CREATING_AVD(Object arg1) {
        return holder.format("CREATING_AVD", arg1);
    }

    /**
     * Creating Android AVD at {0}
     * 
     */
    public static Localizable _CREATING_AVD(Object arg1) {
        return new Localizable(holder, "CREATING_AVD", arg1);
    }

    /**
     * Cannot find Android SDK at ''{0}''
     * 
     */
    public static String SDK_NOT_FOUND(Object arg1) {
        return holder.format("SDK_NOT_FOUND", arg1);
    }

    /**
     * Cannot find Android SDK at ''{0}''
     * 
     */
    public static Localizable _SDK_NOT_FOUND(Object arg1) {
        return new Localizable(holder, "SDK_NOT_FOUND", arg1);
    }

    /**
     * Could not create directory ''{0}''
     * 
     */
    public static String AVD_DIRECTORY_CREATION_FAILED(Object arg1) {
        return holder.format("AVD_DIRECTORY_CREATION_FAILED", arg1);
    }

    /**
     * Could not create directory ''{0}''
     * 
     */
    public static Localizable _AVD_DIRECTORY_CREATION_FAILED(Object arg1) {
        return new Localizable(holder, "AVD_DIRECTORY_CREATION_FAILED", arg1);
    }

    /**
     * AVD name is required
     * 
     */
    public static String AVD_NAME_REQUIRED() {
        return holder.format("AVD_NAME_REQUIRED");
    }

    /**
     * AVD name is required
     * 
     */
    public static Localizable _AVD_NAME_REQUIRED() {
        return new Localizable(holder, "AVD_NAME_REQUIRED");
    }

    /**
     * SD card size should be numeric with suffix, e.g. 32M
     * 
     */
    public static String INVALID_SD_CARD_SIZE() {
        return holder.format("INVALID_SD_CARD_SIZE");
    }

    /**
     * SD card size should be numeric with suffix, e.g. 32M
     * 
     */
    public static Localizable _INVALID_SD_CARD_SIZE() {
        return new Localizable(holder, "INVALID_SD_CARD_SIZE");
    }

    /**
     * Screen density is required
     * 
     */
    public static String SCREEN_DENSITY_REQUIRED() {
        return holder.format("SCREEN_DENSITY_REQUIRED");
    }

    /**
     * Screen density is required
     * 
     */
    public static Localizable _SCREEN_DENSITY_REQUIRED() {
        return new Localizable(holder, "SCREEN_DENSITY_REQUIRED");
    }

    /**
     * Adding {0} SD card to AVD ''{1}''...
     * 
     */
    public static String ADDING_SD_CARD(Object arg1, Object arg2) {
        return holder.format("ADDING_SD_CARD", arg1, arg2);
    }

    /**
     * Adding {0} SD card to AVD ''{1}''...
     * 
     */
    public static Localizable _ADDING_SD_CARD(Object arg1, Object arg2) {
        return new Localizable(holder, "ADDING_SD_CARD", arg1, arg2);
    }

    /**
     * Cannot start emulator: required Android tools not found in PATH
     * 
     */
    public static String SDK_TOOLS_NOT_FOUND() {
        return holder.format("SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Cannot start emulator: required Android tools not found in PATH
     * 
     */
    public static Localizable _SDK_TOOLS_NOT_FOUND() {
        return new Localizable(holder, "SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Resolution should be xVGA, or WWWxHHH
     * 
     */
    public static String INVALID_RESOLUTION_FORMAT() {
        return holder.format("INVALID_RESOLUTION_FORMAT");
    }

    /**
     * Resolution should be xVGA, or WWWxHHH
     * 
     */
    public static Localizable _INVALID_RESOLUTION_FORMAT() {
        return new Localizable(holder, "INVALID_RESOLUTION_FORMAT");
    }

    /**
     * AVD ''{0}'' does not exist
     * 
     */
    public static String AVD_DOES_NOT_EXIST(Object arg1) {
        return holder.format("AVD_DOES_NOT_EXIST", arg1);
    }

    /**
     * AVD ''{0}'' does not exist
     * 
     */
    public static Localizable _AVD_DOES_NOT_EXIST(Object arg1) {
        return new Localizable(holder, "AVD_DOES_NOT_EXIST", arg1);
    }

    /**
     * Does not appear to be a valid directory
     * 
     */
    public static String INVALID_DIRECTORY() {
        return holder.format("INVALID_DIRECTORY");
    }

    /**
     * Does not appear to be a valid directory
     * 
     */
    public static Localizable _INVALID_DIRECTORY() {
        return new Localizable(holder, "INVALID_DIRECTORY");
    }

    /**
     * Failed to run AVD creation command
     * 
     */
    public static String AVD_CREATION_FAILED() {
        return holder.format("AVD_CREATION_FAILED");
    }

    /**
     * Failed to run AVD creation command
     * 
     */
    public static Localizable _AVD_CREATION_FAILED() {
        return new Localizable(holder, "AVD_CREATION_FAILED");
    }

    /**
     * Erasing existing emulator data...
     * 
     */
    public static String ERASING_EXISTING_EMULATOR_DATA() {
        return holder.format("ERASING_EXISTING_EMULATOR_DATA");
    }

    /**
     * Erasing existing emulator data...
     * 
     */
    public static Localizable _ERASING_EXISTING_EMULATOR_DATA() {
        return new Localizable(holder, "ERASING_EXISTING_EMULATOR_DATA");
    }

    /**
     * Run an Android emulator during build
     * 
     */
    public static String JOB_DESCRIPTION() {
        return holder.format("JOB_DESCRIPTION");
    }

    /**
     * Run an Android emulator during build
     * 
     */
    public static Localizable _JOB_DESCRIPTION() {
        return new Localizable(holder, "JOB_DESCRIPTION");
    }

    /**
     * Could not connect to running emulator; cannot continue
     * 
     */
    public static String CANNOT_CONNECT_TO_EMULATOR() {
        return holder.format("CANNOT_CONNECT_TO_EMULATOR");
    }

    /**
     * Could not connect to running emulator; cannot continue
     * 
     */
    public static Localizable _CANNOT_CONNECT_TO_EMULATOR() {
        return new Localizable(holder, "CANNOT_CONNECT_TO_EMULATOR");
    }

    /**
     * Archiving emulator log
     * 
     */
    public static String ARCHIVING_LOG() {
        return holder.format("ARCHIVING_LOG");
    }

    /**
     * Archiving emulator log
     * 
     */
    public static Localizable _ARCHIVING_LOG() {
        return new Localizable(holder, "ARCHIVING_LOG");
    }

    /**
     * Cannot find desired platform image at ''{0}''
     * 
     */
    public static String PLATFORM_IMAGE_NOT_FOUND(Object arg1) {
        return holder.format("PLATFORM_IMAGE_NOT_FOUND", arg1);
    }

    /**
     * Cannot find desired platform image at ''{0}''
     * 
     */
    public static Localizable _PLATFORM_IMAGE_NOT_FOUND(Object arg1) {
        return new Localizable(holder, "PLATFORM_IMAGE_NOT_FOUND", arg1);
    }

    /**
     * Failed to parse AVD config file
     * 
     */
    public static String AVD_CONFIG_NOT_READABLE() {
        return holder.format("AVD_CONFIG_NOT_READABLE");
    }

    /**
     * Failed to parse AVD config file
     * 
     */
    public static Localizable _AVD_CONFIG_NOT_READABLE() {
        return new Localizable(holder, "AVD_CONFIG_NOT_READABLE");
    }

    /**
     * Stopping Android emulator
     * 
     */
    public static String STOPPING_EMULATOR() {
        return holder.format("STOPPING_EMULATOR");
    }

    /**
     * Stopping Android emulator
     * 
     */
    public static Localizable _STOPPING_EMULATOR() {
        return new Localizable(holder, "STOPPING_EMULATOR");
    }

    /**
     * SD card size must be at least 9 megabytes
     * 
     */
    public static String SD_CARD_SIZE_TOO_SMALL() {
        return holder.format("SD_CARD_SIZE_TOO_SMALL");
    }

    /**
     * SD card size must be at least 9 megabytes
     * 
     */
    public static Localizable _SD_CARD_SIZE_TOO_SMALL() {
        return new Localizable(holder, "SD_CARD_SIZE_TOO_SMALL");
    }

    /**
     * Waiting {0} seconds before starting emulator...
     * 
     */
    public static String DELAYING_START_UP(Object arg1) {
        return holder.format("DELAYING_START_UP", arg1);
    }

    /**
     * Waiting {0} seconds before starting emulator...
     * 
     */
    public static Localizable _DELAYING_START_UP(Object arg1) {
        return new Localizable(holder, "DELAYING_START_UP", arg1);
    }

    /**
     * Could not add SD card to emulator:
     * 
     */
    public static String SD_CARD_CREATION_FAILED() {
        return holder.format("SD_CARD_CREATION_FAILED");
    }

    /**
     * Could not add SD card to emulator:
     * 
     */
    public static Localizable _SD_CARD_CREATION_FAILED() {
        return new Localizable(holder, "SD_CARD_CREATION_FAILED");
    }

    /**
     * OS version is required
     * 
     */
    public static String OS_VERSION_REQUIRED() {
        return holder.format("OS_VERSION_REQUIRED");
    }

    /**
     * OS version is required
     * 
     */
    public static Localizable _OS_VERSION_REQUIRED() {
        return new Localizable(holder, "OS_VERSION_REQUIRED");
    }

    /**
     * Screen resolution is required
     * 
     */
    public static String SCREEN_RESOLUTION_REQUIRED() {
        return holder.format("SCREEN_RESOLUTION_REQUIRED");
    }

    /**
     * Screen resolution is required
     * 
     */
    public static Localizable _SCREEN_RESOLUTION_REQUIRED() {
        return new Localizable(holder, "SCREEN_RESOLUTION_REQUIRED");
    }

    /**
     * Cannot start Android emulator due to misconfiguration: {0}
     * 
     */
    public static String ERROR_MISCONFIGURED(Object arg1) {
        return holder.format("ERROR_MISCONFIGURED", arg1);
    }

    /**
     * Cannot start Android emulator due to misconfiguration: {0}
     * 
     */
    public static Localizable _ERROR_MISCONFIGURED(Object arg1) {
        return new Localizable(holder, "ERROR_MISCONFIGURED", arg1);
    }

    /**
     * Screen density should be a number
     * 
     */
    public static String SCREEN_DENSITY_NOT_NUMERIC() {
        return holder.format("SCREEN_DENSITY_NOT_NUMERIC");
    }

    /**
     * Screen density should be a number
     * 
     */
    public static Localizable _SCREEN_DENSITY_NOT_NUMERIC() {
        return new Localizable(holder, "SCREEN_DENSITY_NOT_NUMERIC");
    }

    /**
     * SDK platforms directory appears to be empty.  See inline help for info
     * 
     */
    public static String SDK_PLATFORMS_EMPTY() {
        return holder.format("SDK_PLATFORMS_EMPTY");
    }

    /**
     * SDK platforms directory appears to be empty.  See inline help for info
     * 
     */
    public static Localizable _SDK_PLATFORMS_EMPTY() {
        return new Localizable(holder, "SDK_PLATFORMS_EMPTY");
    }

    /**
     * Timed-out after waiting {0} seconds for emulator
     * 
     */
    public static String BOOT_COMPLETION_TIMED_OUT(Object arg1) {
        return holder.format("BOOT_COMPLETION_TIMED_OUT", arg1);
    }

    /**
     * Timed-out after waiting {0} seconds for emulator
     * 
     */
    public static Localizable _BOOT_COMPLETION_TIMED_OUT(Object arg1) {
        return new Localizable(holder, "BOOT_COMPLETION_TIMED_OUT", arg1);
    }

    /**
     * Invalid AVD name
     * 
     */
    public static String INVALID_AVD_NAME() {
        return holder.format("INVALID_AVD_NAME");
    }

    /**
     * Invalid AVD name
     * 
     */
    public static Localizable _INVALID_AVD_NAME() {
        return new Localizable(holder, "INVALID_AVD_NAME");
    }

    /**
     * {0} resolution with density of {1}dpi.. are you sure?
     * 
     */
    public static String SUSPECT_RESOLUTION(Object arg1, Object arg2) {
        return holder.format("SUSPECT_RESOLUTION", arg1, arg2);
    }

    /**
     * {0} resolution with density of {1}dpi.. are you sure?
     * 
     */
    public static Localizable _SUSPECT_RESOLUTION(Object arg1, Object arg2) {
        return new Localizable(holder, "SUSPECT_RESOLUTION", arg1, arg2);
    }

    /**
     * Interrupted while waiting for emulator to finish booting.
     * 
     */
    public static String INTERRUPTED_DURING_BOOT_COMPLETION() {
        return holder.format("INTERRUPTED_DURING_BOOT_COMPLETION");
    }

    /**
     * Interrupted while waiting for emulator to finish booting.
     * 
     */
    public static Localizable _INTERRUPTED_DURING_BOOT_COMPLETION() {
        return new Localizable(holder, "INTERRUPTED_DURING_BOOT_COMPLETION");
    }

    /**
     * Interrupted while creating new emulator
     * 
     */
    public static String AVD_CREATION_INTERRUPTED() {
        return holder.format("AVD_CREATION_INTERRUPTED");
    }

    /**
     * Interrupted while creating new emulator
     * 
     */
    public static Localizable _AVD_CREATION_INTERRUPTED() {
        return new Localizable(holder, "AVD_CREATION_INTERRUPTED");
    }

    /**
     * Does not look like an Android SDK directory
     * 
     */
    public static String INVALID_SDK_DIRECTORY() {
        return holder.format("INVALID_SDK_DIRECTORY");
    }

    /**
     * Does not look like an Android SDK directory
     * 
     */
    public static Localizable _INVALID_SDK_DIRECTORY() {
        return new Localizable(holder, "INVALID_SDK_DIRECTORY");
    }

    /**
     * Locale will default to ''{0}'' if not specified
     * 
     */
    public static String DEFAULT_LOCALE_WARNING(Object arg1) {
        return holder.format("DEFAULT_LOCALE_WARNING", arg1);
    }

    /**
     * Locale will default to ''{0}'' if not specified
     * 
     */
    public static Localizable _DEFAULT_LOCALE_WARNING(Object arg1) {
        return new Localizable(holder, "DEFAULT_LOCALE_WARNING", arg1);
    }

    /**
     * Cannot find desired platform ''{0}''; are you sure it is installed?
     * 
     */
    public static String PLATFORM_NOT_FOUND(Object arg1) {
        return holder.format("PLATFORM_NOT_FOUND", arg1);
    }

    /**
     * Cannot find desired platform ''{0}''; are you sure it is installed?
     * 
     */
    public static Localizable _PLATFORM_NOT_FOUND(Object arg1) {
        return new Localizable(holder, "PLATFORM_NOT_FOUND", arg1);
    }

    /**
     * Failed to save AVD config file
     * 
     */
    public static String AVD_CONFIG_NOT_WRITEABLE() {
        return holder.format("AVD_CONFIG_NOT_WRITEABLE");
    }

    /**
     * Failed to save AVD config file
     * 
     */
    public static Localizable _AVD_CONFIG_NOT_WRITEABLE() {
        return new Localizable(holder, "AVD_CONFIG_NOT_WRITEABLE");
    }

    /**
     * [none found; relying on PATH]
     * 
     */
    public static String USING_PATH() {
        return holder.format("USING_PATH");
    }

    /**
     * [none found; relying on PATH]
     * 
     */
    public static Localizable _USING_PATH() {
        return new Localizable(holder, "USING_PATH");
    }

    /**
     * Emulator is ready for use (took {0} seconds)
     * 
     */
    public static String EMULATOR_IS_READY(Object arg1) {
        return holder.format("EMULATOR_IS_READY", arg1);
    }

    /**
     * Emulator is ready for use (took {0} seconds)
     * 
     */
    public static Localizable _EMULATOR_IS_READY(Object arg1) {
        return new Localizable(holder, "EMULATOR_IS_READY", arg1);
    }

    /**
     * Could not check for boot completion:
     * 
     */
    public static String COULD_NOT_CHECK_BOOT_COMPLETION() {
        return holder.format("COULD_NOT_CHECK_BOOT_COMPLETION");
    }

    /**
     * Could not check for boot completion:
     * 
     */
    public static Localizable _COULD_NOT_CHECK_BOOT_COMPLETION() {
        return new Localizable(holder, "COULD_NOT_CHECK_BOOT_COMPLETION");
    }

    /**
     * Required tools not found (&lt;tt>adb&lt;/tt> etc.)
     * 
     */
    public static String REQUIRED_SDK_TOOLS_NOT_FOUND() {
        return holder.format("REQUIRED_SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Required tools not found (&lt;tt>adb&lt;/tt> etc.)
     * 
     */
    public static Localizable _REQUIRED_SDK_TOOLS_NOT_FOUND() {
        return new Localizable(holder, "REQUIRED_SDK_TOOLS_NOT_FOUND");
    }

    /**
     * The desired AVD platform ''{0}'' is not installed on this machine
     * 
     */
    public static String INVALID_AVD_TARGET(Object arg1) {
        return holder.format("INVALID_AVD_TARGET", arg1);
    }

    /**
     * The desired AVD platform ''{0}'' is not installed on this machine
     * 
     */
    public static Localizable _INVALID_AVD_TARGET(Object arg1) {
        return new Localizable(holder, "INVALID_AVD_TARGET", arg1);
    }

    /**
     * Waiting for emulator to finish booting...
     * 
     */
    public static String WAITING_FOR_BOOT_COMPLETION() {
        return holder.format("WAITING_FOR_BOOT_COMPLETION");
    }

    /**
     * Waiting for emulator to finish booting...
     * 
     */
    public static Localizable _WAITING_FOR_BOOT_COMPLETION() {
        return new Localizable(holder, "WAITING_FOR_BOOT_COMPLETION");
    }

    /**
     * Emulator did not appear to start; giving up
     * 
     */
    public static String EMULATOR_DID_NOT_START() {
        return holder.format("EMULATOR_DID_NOT_START");
    }

    /**
     * Emulator did not appear to start; giving up
     * 
     */
    public static Localizable _EMULATOR_DID_NOT_START() {
        return new Localizable(holder, "EMULATOR_DID_NOT_START");
    }

    /**
     * AVD creation command failed to complete normally
     * 
     */
    public static String AVD_CREATION_ABORTED() {
        return holder.format("AVD_CREATION_ABORTED");
    }

    /**
     * AVD creation command failed to complete normally
     * 
     */
    public static Localizable _AVD_CREATION_ABORTED() {
        return new Localizable(holder, "AVD_CREATION_ABORTED");
    }

}
