/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.android_emulator;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.AndroidEmulator;
import hudson.plugins.android_emulator.AndroidEmulatorException;
import hudson.plugins.android_emulator.AndroidSdk;
import hudson.plugins.android_emulator.EmulatorConfig;
import hudson.plugins.android_emulator.EmulatorDiscoveryException;
import hudson.plugins.android_emulator.Messages;
import hudson.plugins.android_emulator.Tool;
import hudson.plugins.android_emulator.Utils;
import hudson.plugins.android_emulator.ValidationResult;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.hudson.plugins.port_allocator.PortAllocationManager;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AndroidEmulator
extends BuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ADB_CONNECT_TIMEOUT_MS = 60000;
    private static final int BOOT_COMPLETE_TIMEOUT_MS = 120000;
    private DescriptorImpl descriptor;
    private final String avdName;
    private final String osVersion;
    private final String screenDensity;
    private final String screenResolution;
    private final String deviceLocale;
    private final String sdCardSize;
    private final boolean wipeData;
    private final boolean showWindow;
    private final String commandLineOptions;
    private final int startupDelay;

    @DataBoundConstructor
    public AndroidEmulator(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize, boolean wipeData, boolean showWindow, String commandLineOptions, int startupDelay) {
        this.avdName = avdName;
        this.osVersion = osVersion;
        this.screenDensity = screenDensity;
        this.screenResolution = screenResolution;
        this.deviceLocale = deviceLocale;
        this.sdCardSize = sdCardSize;
        this.wipeData = wipeData;
        this.showWindow = showWindow;
        this.commandLineOptions = commandLineOptions;
        this.startupDelay = Math.abs(startupDelay);
    }

    public boolean getUseNamedEmulator() {
        return this.avdName != null;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getDeviceLocale() {
        return this.deviceLocale;
    }

    public String getSdCardSize() {
        return this.sdCardSize;
    }

    public boolean shouldWipeData() {
        return this.wipeData;
    }

    public boolean shouldShowWindow() {
        return this.showWindow;
    }

    public String getCommandLineOptions() {
        return this.commandLineOptions;
    }

    public int getStartupDelay() {
        return this.startupDelay;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (this.descriptor == null) {
            this.descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        }
        EnvVars localVars = Computer.currentComputer().getEnvironment();
        EnvVars envVars = new EnvVars(localVars);
        envVars.putAll((Map)build.getEnvironment((TaskListener)listener));
        Map buildVars = build.getBuildVariables();
        String avdName = this.expandVariables(envVars, buildVars, this.avdName);
        String osVersion = this.expandVariables(envVars, buildVars, this.osVersion);
        String screenDensity = this.expandVariables(envVars, buildVars, this.screenDensity);
        String screenResolution = this.expandVariables(envVars, buildVars, this.screenResolution);
        String deviceLocale = this.expandVariables(envVars, buildVars, this.deviceLocale);
        String sdCardSize = this.expandVariables(envVars, buildVars, this.sdCardSize);
        String commandLineOptions = this.expandVariables(envVars, buildVars, this.commandLineOptions);
        String androidHome = this.expandVariables(envVars, buildVars, this.descriptor.androidHome);
        androidHome = this.discoverAndroidHome(launcher, localVars, androidHome);
        String configError = this.isConfigValid(avdName, osVersion, screenDensity, screenResolution, deviceLocale, sdCardSize);
        if (configError != null) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.ERROR_MISCONFIGURED((Object)configError));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        AndroidSdk androidSdk = new AndroidSdk(androidHome);
        if (androidHome == null) {
            if (!this.validateAndroidToolsInPath(launcher)) {
                AndroidEmulator.log((PrintStream)logger, (String)Messages.SDK_TOOLS_NOT_FOUND());
                build.setResult(Result.NOT_BUILT);
                return null;
            }
        } else {
            boolean usesPlatformTools = this.sdkUsesPlatformTools(launcher, androidSdk);
            androidSdk.setUsesPlatformTools(usesPlatformTools);
        }
        String displayHome = androidSdk.hasKnownRoot() ? androidSdk.getSdkRoot() : Messages.USING_PATH();
        AndroidEmulator.log((PrintStream)logger, (String)Messages.USING_SDK((Object)displayHome));
        EmulatorConfig emuConfig = EmulatorConfig.create((String)avdName, (String)osVersion, (String)screenDensity, (String)screenResolution, (String)deviceLocale, (String)sdCardSize, (boolean)this.wipeData, (boolean)this.showWindow, (String)commandLineOptions);
        return this.doSetUp(build, launcher, listener, androidSdk, emuConfig);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, AndroidSdk androidSdk, EmulatorConfig emuConfig) throws IOException, InterruptedException {
        boolean bootSucceeded;
        boolean emulatorAlreadyExists;
        PrintStream logger = listener.getLogger();
        boolean isUnix = launcher.isUnix();
        Computer computer = Computer.currentComputer();
        try {
            Callable task = emuConfig.getEmulatorCreationTask(androidSdk, isUnix, listener);
            emulatorAlreadyExists = (Boolean)launcher.getChannel().call(task);
        }
        catch (EmulatorDiscoveryException ex) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.CANNOT_START_EMULATOR((Object)ex.getMessage()));
            build.setResult(Result.FAILURE);
            return null;
        }
        catch (AndroidEmulatorException ex) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.COULD_NOT_CREATE_EMULATOR((Object)ex.getMessage()));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        int delaySecs = this.getStartupDelay();
        if (delaySecs > 0) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.DELAYING_START_UP((Object)delaySecs));
            Thread.sleep(delaySecs * 1000);
        }
        PortAllocationManager portAllocator = PortAllocationManager.getManager((Computer)computer);
        int userPort = portAllocator.allocateRandom(build, 0);
        int adbPort = portAllocator.allocateRandom(build, 0);
        String avdArgs = emuConfig.getCommandArguments();
        String emulatorArgs = String.format("-ports %s,%s %s", userPort, adbPort, avdArgs);
        ArgumentListBuilder emulatorCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)isUnix, (Tool)Tool.EMULATOR, (String)emulatorArgs);
        AndroidEmulator.log((PrintStream)logger, (String)Messages.STARTING_EMULATOR());
        if (emulatorAlreadyExists && emuConfig.shouldWipeData()) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.ERASING_EXISTING_EMULATOR_DATA());
        }
        long bootTime = System.currentTimeMillis();
        EnvVars buildEnvironment = build.getEnvironment(TaskListener.NULL);
        Launcher.ProcStarter procStarter = launcher.launch().stdout((OutputStream)logger).stderr((OutputStream)logger);
        Proc emulatorProcess = procStarter.envs((Map)buildEnvironment).cmds(emulatorCmd).start();
        boolean socket = this.waitForSocket(launcher, adbPort, 60000);
        if (!socket || !emulatorProcess.isAlive()) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.EMULATOR_DID_NOT_START());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        String adbConnectArgs = "connect localhost:" + adbPort;
        ArgumentListBuilder adbConnectCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)isUnix, (Tool)Tool.ADB, (String)adbConnectArgs);
        int result = procStarter.cmds(adbConnectCmd).stdout((OutputStream)new NullOutputStream(null)).start().join();
        if (result != 0) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.CANNOT_CONNECT_TO_EMULATOR());
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, portAllocator, emulatorProcess, adbPort, userPort);
            return null;
        }
        File artifactsDir = build.getArtifactsDir();
        FilePath logcatFile = build.getWorkspace().createTempFile("logcat_", ".log");
        OutputStream logcatStream = logcatFile.write();
        String logcatArgs = "-s localhost:" + adbPort + " logcat -v time";
        ArgumentListBuilder logcatCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)isUnix, (Tool)Tool.ADB, (String)logcatArgs);
        Proc logWriter = procStarter.cmds(logcatCmd).stdout(logcatStream).stderr((OutputStream)new NullOutputStream(null)).start();
        AndroidEmulator.log((PrintStream)logger, (String)Messages.WAITING_FOR_BOOT_COMPLETION());
        int bootTimeout = 120000;
        if (!emulatorAlreadyExists || emuConfig.shouldWipeData()) {
            bootTimeout *= 4;
        }
        if (!(bootSucceeded = this.waitForBootCompletion(logger, launcher, androidSdk, adbPort, bootTimeout))) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.BOOT_COMPLETION_TIMED_OUT((Object)(bootTimeout / 1000)));
            build.setResult(Result.NOT_BUILT);
            this.cleanUp(logger, launcher, androidSdk, portAllocator, emulatorProcess, adbPort, userPort, logWriter, logcatFile, logcatStream, artifactsDir);
            return null;
        }
        if (emulatorAlreadyExists && !this.wipeData) {
            long bootDuration = System.currentTimeMillis() - bootTime;
            Thread.sleep(bootDuration / 4L);
            AndroidEmulator.log((PrintStream)logger, (String)Messages.UNLOCKING_SCREEN());
            String keyEventArgs = String.format("-s localhost:%d shell input keyevent %%d", adbPort);
            String menuArgs = String.format(keyEventArgs, 82);
            ArgumentListBuilder menuCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)isUnix, (Tool)Tool.ADB, (String)menuArgs);
            procStarter.cmds(menuCmd).start().join();
            if (emuConfig.isNamedEmulator()) {
                String backArgs = String.format(keyEventArgs, 4);
                ArgumentListBuilder backCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)isUnix, (Tool)Tool.ADB, (String)backArgs);
                procStarter.cmds(backCmd).start().join();
            }
        }
        long bootCompleteTime = System.currentTimeMillis();
        AndroidEmulator.log((PrintStream)logger, (String)Messages.EMULATOR_IS_READY((Object)((bootCompleteTime - bootTime) / 1000L)));
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static synchronized void log(PrintStream logger, String message) {
        AndroidEmulator.log((PrintStream)logger, (String)message, (boolean)false);
    }

    static synchronized void log(PrintStream logger, String message, boolean indent) {
        if (indent) {
            message = '\t' + message.replace("\n", "\n\t");
        } else {
            logger.print("[android] ");
        }
        logger.println(message);
    }

    private void cleanUp(PrintStream logger, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort) throws IOException, InterruptedException {
        this.cleanUp(logger, null, null, portAllocator, emulatorProcess, adbPort, userPort, null, null, null, null);
    }

    private void cleanUp(PrintStream logger, Launcher launcher, AndroidSdk androidSdk, PortAllocationManager portAllocator, Proc emulatorProcess, int adbPort, int userPort, Proc logcatProcess, FilePath logcatFile, OutputStream logcatStream, File artifactsDir) throws IOException, InterruptedException {
        if (launcher != null) {
            String args = "disconnect localhost:" + adbPort;
            ArgumentListBuilder adbDisconnectCmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)launcher.isUnix(), (Tool)Tool.ADB, (String)args);
            Launcher.ProcStarter procStarter = launcher.launch().stderr((OutputStream)logger);
            procStarter.cmds(adbDisconnectCmd).stdout((OutputStream)new NullOutputStream(null)).start().join();
        }
        AndroidEmulator.log((PrintStream)logger, (String)Messages.STOPPING_EMULATOR());
        if (logcatProcess != null) {
            this.sendEmulatorCommand(launcher, logger, userPort, "kill");
            if (logcatProcess.isAlive()) {
                logcatProcess.kill();
            }
            logcatStream.close();
            if (logcatFile.length() != 0L) {
                AndroidEmulator.log((PrintStream)logger, (String)Messages.ARCHIVING_LOG());
                logcatFile.copyTo(new FilePath(artifactsDir).child("logcat.txt"));
            }
            logcatFile.delete();
        }
        if (emulatorProcess.isAlive()) {
            emulatorProcess.kill();
        }
        portAllocator.free(adbPort);
        portAllocator.free(userPort);
    }

    private String expandVariables(EnvVars envVars, Map<String, String> buildVars, String token) {
        String result = Util.fixEmptyAndTrim((String)token);
        if (result != null) {
            result = Util.replaceMacro((String)Util.replaceMacro((String)result, (Map)envVars), buildVars);
        }
        return result;
    }

    private String isConfigValid(String avdName, String osVersion, String screenDensity, String screenResolution, String deviceLocale, String sdCardSize) {
        if (this.getUseNamedEmulator()) {
            ValidationResult result = DescriptorImpl.access$200((DescriptorImpl)this.descriptor, (String)avdName, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        } else {
            ValidationResult result = DescriptorImpl.access$300((DescriptorImpl)this.descriptor, (String)osVersion, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$400((DescriptorImpl)this.descriptor, (String)screenDensity, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$500((DescriptorImpl)this.descriptor, (String)screenResolution, null, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$600((DescriptorImpl)this.descriptor, (String)deviceLocale, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
            result = DescriptorImpl.access$700((DescriptorImpl)this.descriptor, (String)sdCardSize, (boolean)false);
            if (result.isFatal()) {
                return result.getMessage();
            }
        }
        return null;
    }

    private String discoverAndroidHome(Launcher launcher, EnvVars envVars, String androidHome) {
        2 task = new /* Unavailable Anonymous Inner Class!! */;
        String result = androidHome;
        try {
            result = (String)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private boolean validateAndroidToolsInPath(Launcher launcher) {
        boolean isUnix = launcher.isUnix();
        3 task = new /* Unavailable Anonymous Inner Class!! */;
        try {
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return false;
    }

    private boolean sdkUsesPlatformTools(Launcher launcher, AndroidSdk androidSdk) {
        4 task = new /* Unavailable Anonymous Inner Class!! */;
        try {
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForSocket(Launcher launcher, int port, int timeout) {
        try {
            LocalPortOpenTask task = new LocalPortOpenTask(port, timeout);
            return (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (InterruptedException ex) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private boolean waitForBootCompletion(PrintStream logger, Launcher launcher, AndroidSdk androidSdk, int port, int timeout) {
        long start = System.currentTimeMillis();
        int sleep = timeout / (int)Math.sqrt(timeout / 1000);
        String serialNo = "localhost:" + port;
        String args = "-s " + serialNo + " shell getprop dev.bootcomplete";
        ArgumentListBuilder cmd = Utils.getToolCommand((AndroidSdk)androidSdk, (boolean)launcher.isUnix(), (Tool)Tool.ADB, (String)args);
        try {
            while (System.currentTimeMillis() < start + (long)timeout) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
                launcher.launch().cmds(cmd).stdout((OutputStream)stream).start().join();
                String result = stream.toString().trim();
                if (result.equals("1")) {
                    return true;
                }
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedException ex) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.INTERRUPTED_DURING_BOOT_COMPLETION());
        }
        catch (IOException ex) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.COULD_NOT_CHECK_BOOT_COMPLETION());
            ex.printStackTrace(logger);
        }
        return false;
    }

    private boolean sendEmulatorCommand(Launcher launcher, PrintStream logger, int port, String command) {
        5 task = new /* Unavailable Anonymous Inner Class!! */;
        boolean result = false;
        try {
            result = (Boolean)launcher.getChannel().call((Callable)task);
        }
        catch (Exception e) {
            AndroidEmulator.log((PrintStream)logger, (String)String.format("Failed to execute emulator command '%s': %s", command, e));
        }
        return result;
    }

    static /* synthetic */ void access$100(AndroidEmulator x0, PrintStream x1, Launcher x2, AndroidSdk x3, PortAllocationManager x4, Proc x5, int x6, int x7, Proc x8, FilePath x9, OutputStream x10, File x11) throws IOException, InterruptedException {
        x0.cleanUp(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
    }

    static /* synthetic */ DescriptorImpl access$800(AndroidEmulator x0) {
        return x0.descriptor;
    }
}

