/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Plugin;
import hudson.logging.LogRecorder;
import hudson.logging.LogRecorderManager;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.security.ACL;
import hudson.security.ChainedServletFilter;
import hudson.security.HudsonFilter;
import hudson.security.SecurityRealm;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class AuditTrailPlugin
extends Plugin {
    private String log = "";
    private String pattern = ".*/(?:configSubmit|doDelete|build|toggleLogKeep|doWipeOutWorkspace|createItem|createView)";
    private int limit = 1;
    private int count = 1;
    private transient ServletContext context;

    public String getLog() {
        return this.log;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        final HudsonFilter mainFilter = HudsonFilter.get((ServletContext)this.context);
        this.context.setAttribute(HudsonFilter.class.getName(), (Object)new HudsonFilter(){

            public void reset(final SecurityRealm securityRealm) throws ServletException {
                SecurityRealm wrappedRealm = securityRealm == null ? null : new SecurityRealm(){

                    public SecurityRealm.SecurityComponents createSecurityComponents() {
                        return securityRealm.createSecurityComponents();
                    }

                    public Descriptor<SecurityRealm> getDescriptor() {
                        return null;
                    }

                    public Filter createFilter(FilterConfig filterConfig) {
                        return new ChainedServletFilter(new Filter[]{securityRealm.createFilter(filterConfig), new AuditTrailFilter()});
                    }
                };
                mainFilter.reset(wrappedRealm);
            }
        });
        this.load();
        this.applySettings();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
                LogRecorderManager lrm = Hudson.getInstance().getLog();
                if (!lrm.logRecorders.containsKey("Audit Trail")) {
                    LogRecorder logRecorder = new LogRecorder("Audit Trail");
                    logRecorder.targets.add((Object)new LogRecorder.Target(AuditTrailFilter.class.getName(), Level.INFO));
                    try {
                        logRecorder.save();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lrm.logRecorders.put("Audit Trail", logRecorder);
                }
                SecurityContextHolder.clearContext();
            }
        }.start();
    }

    public void configure(JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.log = formData.optString("log");
        this.limit = formData.optInt("limit", 1);
        this.count = formData.optInt("count", 1);
        this.pattern = formData.optString("pattern");
        this.save();
        this.applySettings();
    }

    private void applySettings() {
        try {
            AuditTrailFilter.uriPattern = Pattern.compile(this.pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Logger logger = Logger.getLogger("hudson.plugins.audit_trail");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
        if (this.log != null && this.log.length() > 0) {
            try {
                FileHandler handler = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                handler.setLevel(Level.CONFIG);
                handler.setFormatter(new Formatter(){
                    SimpleDateFormat dateformat = new SimpleDateFormat("MMM d, yyyy h:mm:ss aa ");

                    public synchronized String format(LogRecord record) {
                        return this.dateformat.format(new Date(record.getMillis())) + record.getMessage() + '\n';
                    }
                });
                logger.addHandler(handler);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doRegexCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new FormFieldValidator(req, rsp, false){

            protected void check() throws IOException, ServletException {
                try {
                    Pattern.compile(this.request.getParameter("value"));
                    this.ok();
                }
                catch (Exception ex) {
                    this.errorWithMarkup("Invalid <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">regular expression</a> (" + ex.getMessage() + ")");
                }
            }
        }.process();
    }
}

