/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import hudson.security.HudsonFilter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class AuditTrailPlugin
extends Plugin {
    private String log = "";
    private String pattern = ".*/(?:configSubmit|doDelete|build|toggleLogKeep|doWipeOutWorkspace|createItem|createView)";
    private int limit = 1;
    private int count = 1;
    private transient ServletContext context;

    public String getLog() {
        return this.log;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        HudsonFilter mainFilter = HudsonFilter.get((ServletContext)this.context);
        this.context.setAttribute(HudsonFilter.class.getName(), (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.load();
        this.applySettings();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void configure(JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.log = formData.optString("log");
        this.limit = formData.optInt("limit", 1);
        this.count = formData.optInt("count", 1);
        this.pattern = formData.optString("pattern");
        this.save();
        this.applySettings();
    }

    private void applySettings() {
        try {
            AuditTrailFilter.uriPattern = Pattern.compile(this.pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Logger logger = Logger.getLogger("hudson.plugins.audit_trail");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
        if (this.log != null && this.log.length() > 0) {
            try {
                FileHandler handler = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                handler.setLevel(Level.CONFIG);
                handler.setFormatter((Formatter)new /* Unavailable Anonymous Inner Class!! */);
                logger.setLevel(Level.CONFIG);
                logger.addHandler(handler);
                logger.setUseParentHandlers(false);
                logger.addHandler((Handler)new RouteToHudsonHandler(null));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doRegexCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new /* Unavailable Anonymous Inner Class!! */.process();
    }
}

