/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditTrailPlugin
extends Plugin {
    private String log = "";
    private String pattern = ".*/(?:configSubmit|doDelete|postBuildResult|cancelQueue|stop|toggleLogKeep|doWipeOutWorkspace|createItem|createView|toggleOffline)";
    private int limit = 1;
    private int count = 1;
    private boolean logBuildCause = true;
    private transient ServletContext context;
    public static final AuditTrailRunListener LISTENER = new AuditTrailRunListener(null);

    public String getLog() {
        return this.log;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getLogBuildCause() {
        return this.logBuildCause;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        this.load();
        this.applySettings();
        PluginServletFilter.addFilter((Filter)new AuditTrailFilter());
    }

    public void postInitialize() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.log = formData.optString("log");
        this.limit = formData.optInt("limit", 1);
        this.count = formData.optInt("count", 1);
        this.pattern = formData.optString("pattern");
        this.logBuildCause = formData.optBoolean("logBuildCause", true);
        this.save();
        this.applySettings();
    }

    private void applySettings() {
        try {
            AuditTrailFilter.uriPattern = Pattern.compile(this.pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AuditTrailRunListener.access$000((AuditTrailRunListener)LISTENER, (boolean)this.logBuildCause);
        Logger logger = Logger.getLogger(AuditTrailFilter.class.getPackage().getName());
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
        if (this.log != null && this.log.length() > 0) {
            try {
                FileHandler handler = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                handler.setLevel(Level.CONFIG);
                handler.setFormatter((Formatter)new /* Unavailable Anonymous Inner Class!! */);
                logger.setLevel(Level.CONFIG);
                logger.addHandler(handler);
                logger.setUseParentHandlers(false);
                logger.addHandler((Handler)new RouteToHudsonHandler(null));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public FormValidation doRegexCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (Exception ex) {
            return FormValidation.errorWithMarkup((String)("Invalid <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">regular expression</a> (" + ex.getMessage() + ")"));
        }
    }
}

