/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Plugin;
import hudson.logging.LogRecorder;
import hudson.logging.LogRecorderManager;
import hudson.logging.WeakLogHandler;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AuditTrailPlugin
extends Plugin {
    private String log = "";
    private String pattern = ".*/(?:configSubmit|doDelete|postBuildResult|cancelQueue|stop|toggleLogKeep|doWipeOutWorkspace|createItem|createView|toggleOffline)";
    private int limit = 1;
    private int count = 1;
    private boolean logBuildCause = true;
    private transient ServletContext context;
    public static final AuditTrailRunListener LISTENER = new AuditTrailRunListener();

    public String getLog() {
        return this.log;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getLogBuildCause() {
        return this.logBuildCause;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        this.load();
        this.applySettings();
        PluginServletFilter.addFilter((Filter)new AuditTrailFilter());
    }

    public void postInitialize() {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
                LogRecorderManager lrm = Hudson.getInstance().getLog();
                if (!lrm.logRecorders.containsKey("Audit Trail")) {
                    LogRecorder logRecorder = new LogRecorder("Audit Trail");
                    logRecorder.targets.add((Object)new LogRecorder.Target(AuditTrailFilter.class.getPackage().getName(), Level.CONFIG));
                    try {
                        logRecorder.save();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lrm.logRecorders.put("Audit Trail", logRecorder);
                }
                SecurityContextHolder.clearContext();
            }
        }.start();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.log = formData.optString("log");
        this.limit = formData.optInt("limit", 1);
        this.count = formData.optInt("count", 1);
        this.pattern = formData.optString("pattern");
        this.logBuildCause = formData.optBoolean("logBuildCause", true);
        this.save();
        this.applySettings();
    }

    private void applySettings() {
        try {
            AuditTrailFilter.uriPattern = Pattern.compile(this.pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AuditTrailPlugin.LISTENER.setActive(this.logBuildCause);
        Logger logger = Logger.getLogger(AuditTrailFilter.class.getPackage().getName());
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
            handler.close();
        }
        if (this.log != null && this.log.length() > 0) {
            try {
                FileHandler handler = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                handler.setLevel(Level.CONFIG);
                handler.setFormatter(new Formatter(){
                    SimpleDateFormat dateformat = new SimpleDateFormat("MMM d, yyyy h:mm:ss aa ");

                    public synchronized String format(LogRecord record) {
                        return this.dateformat.format(new Date(record.getMillis())) + record.getMessage() + '\n';
                    }
                });
                logger.setLevel(Level.CONFIG);
                logger.addHandler(handler);
                logger.setUseParentHandlers(false);
                logger.addHandler(new RouteToHudsonHandler());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public FormValidation doRegexCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (Exception ex) {
            return FormValidation.errorWithMarkup((String)("Invalid <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">regular expression</a> (" + ex.getMessage() + ")"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AuditTrailRunListener
    extends RunListener<Run> {
        private boolean active = false;
        private Logger LOG = Logger.getLogger(AuditTrailRunListener.class.getName());

        private AuditTrailRunListener() {
            super(Run.class);
        }

        private void setActive(boolean active) {
            this.active = active;
        }

        public void onStarted(Run run, TaskListener listener) {
            if (this.active) {
                StringBuilder buf = new StringBuilder(100);
                for (CauseAction action : run.getActions(CauseAction.class)) {
                    for (Cause cause : action.getCauses()) {
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(cause.getShortDescription());
                    }
                }
                if (buf.length() == 0) {
                    buf.append("Started");
                }
                this.LOG.config(run.getParent().getUrl() + " #" + run.getNumber() + ' ' + buf.toString());
            }
        }
    }

    private static class RouteToHudsonHandler
    extends Handler {
        private RouteToHudsonHandler() {
        }

        public void publish(LogRecord record) {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof WeakLogHandler)) continue;
                handler.publish(record);
            }
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

