/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.backlog.BacklogProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class BacklogChangelogAnnotator
extends ChangeLogAnnotator {
    private static final Log LOG = LogFactory.getLog(BacklogChangelogAnnotator.class);
    public static final Pattern ISSUE_KEY_PATTERN = Pattern.compile("(?:(?<![/A-Z0-9a-z-])([A-Z0-9]+-[1-9][0-9]*)|\\[\\[([A-Z0-9]+-[1-9][0-9]*)\\]\\])");

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        BacklogProjectProperty bpp = (BacklogProjectProperty)build.getProject().getProperty(BacklogProjectProperty.class);
        if (bpp == null || bpp.spaceURL == null) {
            LOG.debug((Object)"BacklogProjectProperty is null or BacklogProjectProperty's spaceURL is null");
            return;
        }
        this.annotate(bpp.spaceURL, text);
    }

    void annotate(String spaceURL, MarkupText text) {
        Matcher m = ISSUE_KEY_PATTERN.matcher(text.getText());
        ArrayList<MarkupText.SubText> r = new ArrayList<MarkupText.SubText>();
        while (m.find()) {
            MarkupText markupText = text;
            markupText.getClass();
            MarkupText.SubText st = new MarkupText.SubText(markupText, m, 0);
            r.add(st);
        }
        for (MarkupText.SubText token : r) {
            LOG.debug((Object)("token=" + token.getText()));
            token.surroundWith("<a href=\"" + spaceURL + "view/$1$2\">", "</a>");
        }
    }
}

