/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.backlog.BacklogNotifier;
import hudson.plugins.backlog.api.BacklogApiClient;
import hudson.plugins.backlog.api.entity.Issue;
import hudson.plugins.backlog.api.entity.Priority;
import hudson.plugins.backlog.api.entity.Project;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.xmlrpc.XmlRpcException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacklogNotifier
extends Notifier {
    public final String space;
    public final String projectKey;
    public final String userId;
    public final String password;

    @DataBoundConstructor
    public BacklogNotifier(String space, String projectKey, String userId, String password) {
        this.space = space;
        this.projectKey = projectKey;
        this.userId = userId;
        this.password = password;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.SUCCESS) {
            return true;
        }
        AbstractBuild pb = (AbstractBuild)build.getPreviousBuild();
        if (pb == null || pb.getResult() != Result.SUCCESS) {
            return true;
        }
        BacklogApiClient client = new BacklogApiClient();
        try {
            client.login(this.space, this.userId, this.password);
        }
        catch (IllegalArgumentException e) {
            listener.getLogger().println(e.getMessage());
            return true;
        }
        try {
            Project project = client.getProject(this.projectKey);
            MimeMessage message = new MessageCreator(build, listener).getMessage();
            Issue newIssue = new Issue();
            newIssue.setSummary(message.getSubject());
            newIssue.setDescription(message.getContent().toString());
            if (build.getResult() == Result.FAILURE) {
                newIssue.setPriority(Priority.HIGH);
            } else if (build.getResult() == Result.UNSTABLE) {
                newIssue.setPriority(Priority.MIDDLE);
            }
            Issue issue = client.createIssue(project.getId(), newIssue);
            listener.getLogger().println("Created issue is [" + issue.getKey() + "] : " + issue.getUrl());
        }
        catch (XmlRpcException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (MessagingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

