/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.api;

import hudson.plugins.backlog.api.Method;
import hudson.plugins.backlog.api.entity.Issue;
import hudson.plugins.backlog.api.entity.Project;
import hudson.plugins.backlog.api.entity.User;
import hudson.plugins.backlog.api.util.ConvertUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class BacklogApiClient {
    private final XmlRpcClient client = new XmlRpcClient();

    public void login(String space, String userName, String password) {
        String url = "https://" + space + ".backlog.jp/XML-RPC";
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(url));
            config.setBasicUserName(userName);
            config.setBasicPassword(password);
            this.client.setConfig((XmlRpcClientConfig)config);
            this.getUser(userName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (XmlRpcException e) {
            throw new IllegalArgumentException("Login Failed to Backlog : Space=" + space + ", UserId=" + userName + ", Password=" + password);
        }
    }

    public User getUser(String userId) throws XmlRpcException {
        Object[] params = new Object[]{userId};
        Object result = this.client.execute(Method.GET_USER.getName(), params);
        User user = ConvertUtil.responseToUser((Object)result);
        return user;
    }

    public Project getProject(String key) throws XmlRpcException {
        Object[] params = new Object[]{key};
        Object result = this.client.execute(Method.GET_PROJECT.getName(), params);
        Project project = ConvertUtil.responseToProject((Object)result);
        return project;
    }

    public Issue createIssue(int projectId, Issue newIssue) throws XmlRpcException {
        Map request = ConvertUtil.issueToRequest((Issue)newIssue);
        request.put("projectId", projectId);
        Object[] params = new Object[]{request};
        Object result = this.client.execute(Method.CREATE_ISSUE.getName(), params);
        Issue issue = ConvertUtil.responseToIssue((Object)result);
        return issue;
    }
}

